/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import java.io.Closeable;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.tajo.QueryId;
import org.apache.tajo.auth.UserRoleInfo;
import org.apache.tajo.client.QueryStatus;
import org.apache.tajo.exception.NoSuchSessionVariableException;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.TajoMemoryResultSet;

public interface QueryClient
extends Closeable {
    public boolean isConnected();

    public String getSessionId();

    public Map<String, String> getClientSideSessionVars();

    public String getBaseDatabase();

    public void setMaxRows(int var1);

    public int getMaxRows();

    @Override
    public void close();

    public UserRoleInfo getUserInfo();

    public void closeQuery(QueryId var1);

    public void closeNonForwardQuery(QueryId var1);

    public String getCurrentDatabase();

    public void selectDatabase(String var1) throws UndefinedDatabaseException;

    public Map<String, String> updateSessionVariables(Map<String, String> var1);

    public Map<String, String> unsetSessionVariables(List<String> var1);

    public String getSessionVariable(String var1) throws NoSuchSessionVariableException;

    public boolean existSessionVariable(String var1);

    public Map<String, String> getAllSessionVariables();

    public ClientProtos.SubmitQueryResponse executeQuery(String var1);

    public ClientProtos.SubmitQueryResponse executeQueryWithJson(String var1);

    public ResultSet executeQueryAndGetResult(String var1) throws TajoException;

    public ResultSet executeJsonQueryAndGetResult(String var1) throws TajoException;

    public QueryStatus getQueryStatus(QueryId var1) throws QueryNotFoundException;

    public ResultSet getQueryResult(QueryId var1) throws TajoException;

    public ResultSet createNullResultSet(QueryId var1);

    public ClientProtos.GetQueryResultResponse getResultResponse(QueryId var1) throws TajoException;

    public Future<TajoMemoryResultSet> fetchNextQueryResultAsync(QueryId var1, int var2);

    public boolean updateQuery(String var1) throws TajoException;

    public boolean updateQueryWithJson(String var1) throws TajoException;

    public List<ClientProtos.BriefQueryInfo> getRunningQueryList();

    public List<ClientProtos.BriefQueryInfo> getFinishedQueryList();

    public List<ClientProtos.WorkerResourceInfo> getClusterInfo();

    public QueryStatus killQuery(QueryId var1) throws QueryNotFoundException;

    public ClientProtos.QueryInfoProto getQueryInfo(QueryId var1) throws QueryNotFoundException;

    public ClientProtos.QueryHistoryProto getQueryHistory(QueryId var1) throws QueryNotFoundException;
}

