/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ServiceException;
import java.net.InetSocketAddress;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.QueryId;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.SessionVars;
import org.apache.tajo.TajoIdProtos;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.auth.UserRoleInfo;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.QueryStatus;
import org.apache.tajo.client.SessionConnection;
import org.apache.tajo.client.TajoClientUtil;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.NoSuchSessionVariableException;
import org.apache.tajo.exception.QueryFailedException;
import org.apache.tajo.exception.QueryKilledException;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.ipc.QueryMasterClientProtocol;
import org.apache.tajo.ipc.TajoMasterClientProtocol;
import org.apache.tajo.jdbc.FetchResultSet;
import org.apache.tajo.jdbc.TajoMemoryResultSet;
import org.apache.tajo.rpc.NettyClientBase;
import org.apache.tajo.rpc.RpcClientManager;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.util.ProtoUtil;

public class QueryClientImpl
implements QueryClient {
    private static final Log LOG = LogFactory.getLog(QueryClientImpl.class);
    private static final TajoProtos.CodecType DEFAULT_CODEC = TajoProtos.CodecType.SNAPPY;
    private final ExecutorService executor;
    private final SessionConnection conn;
    private final int defaultFetchRows;
    private int maxRows;

    public QueryClientImpl(SessionConnection conn) {
        this.conn = conn;
        this.defaultFetchRows = this.conn.getProperties().getInt(SessionVars.FETCH_ROWNUM.getConfVars().keyname(), Integer.valueOf(SessionVars.FETCH_ROWNUM.getConfVars().defaultIntVal));
        this.maxRows = 0;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public boolean isConnected() {
        return this.conn.isConnected();
    }

    @Override
    public String getSessionId() {
        return this.conn.getSessionId();
    }

    @Override
    public Map<String, String> getClientSideSessionVars() {
        return this.conn.getClientSideSessionVars();
    }

    @Override
    public String getBaseDatabase() {
        return this.conn.getBaseDatabase();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @Override
    public UserRoleInfo getUserInfo() {
        return this.conn.getUserInfo();
    }

    @Override
    public void closeQuery(QueryId queryId) {
        this.closeNonForwardQuery(queryId);
    }

    @Override
    public void closeNonForwardQuery(QueryId queryId) {
        try {
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)this.conn.getTMStub().closeNonForwardQuery(null, this.buildQueryIdRequest(queryId)));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCurrentDatabase() {
        return this.conn.getCurrentDatabase();
    }

    @Override
    public void selectDatabase(String databaseName) throws UndefinedDatabaseException {
        this.conn.selectDatabase(databaseName);
    }

    @Override
    public Map<String, String> updateSessionVariables(Map<String, String> variables) {
        return this.conn.updateSessionVariables(variables);
    }

    @Override
    public Map<String, String> unsetSessionVariables(List<String> variables) {
        return this.conn.unsetSessionVariables(variables);
    }

    @Override
    public String getSessionVariable(String varname) throws NoSuchSessionVariableException {
        return this.conn.getSessionVariable(varname);
    }

    @Override
    public boolean existSessionVariable(String varname) {
        return this.conn.existSessionVariable(varname);
    }

    @Override
    public Map<String, String> getAllSessionVariables() {
        return this.conn.getAllSessionVariables();
    }

    @Override
    public ClientProtos.SubmitQueryResponse executeQuery(String sql) {
        ClientProtos.SubmitQueryResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.QueryRequest request = this.buildQueryRequest(sql, false);
        try {
            response = stub.submitQuery(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        if (ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)response.getState())) {
            this.conn.updateSessionVarsCache(ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars()));
        }
        return response;
    }

    @Override
    public ClientProtos.SubmitQueryResponse executeQueryWithJson(String json) {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.QueryRequest request = this.buildQueryRequest(json, true);
        try {
            return stub.submitQuery(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResultSet executeQueryAndGetResult(String sql) throws TajoException {
        ClientProtos.SubmitQueryResponse response = this.executeQuery(sql);
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        QueryId queryId = new QueryId(response.getQueryId());
        switch (response.getResultType()) {
            case ENCLOSED: {
                return TajoClientUtil.createResultSet(this, response, this.defaultFetchRows);
            }
            case FETCH: {
                return this.getQueryResultAndWait(queryId);
            }
        }
        return this.createNullResultSet(queryId);
    }

    @Override
    public ResultSet executeJsonQueryAndGetResult(String json) throws TajoException {
        ClientProtos.SubmitQueryResponse response = this.executeQueryWithJson(json);
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        QueryId queryId = new QueryId(response.getQueryId());
        switch (response.getResultType()) {
            case ENCLOSED: {
                return TajoClientUtil.createResultSet(this, response, this.defaultFetchRows);
            }
            case FETCH: {
                return this.getQueryResultAndWait(queryId);
            }
        }
        return this.createNullResultSet(queryId);
    }

    public ResultSet getQueryResultAndWait(QueryId queryId) throws QueryNotFoundException, QueryKilledException, QueryFailedException {
        if (queryId.equals((Object)QueryIdFactory.NULL_QUERY_ID)) {
            return this.createNullResultSet(queryId);
        }
        QueryStatus status = TajoClientUtil.waitCompletion(this, queryId);
        if (status.getState() == TajoProtos.QueryState.QUERY_SUCCEEDED) {
            if (status.hasResult()) {
                return this.getQueryResult(queryId);
            }
            return this.createNullResultSet(queryId);
        }
        if (status.getState() == TajoProtos.QueryState.QUERY_KILLED) {
            throw new QueryKilledException();
        }
        if (status.getState() == TajoProtos.QueryState.QUERY_FAILED) {
            throw new QueryFailedException(status.getErrorMessage());
        }
        throw new TajoInternalError("Illegal query status: " + status.getState().name() + ", cause: " + status.getErrorMessage());
    }

    public ClientProtos.GetQueryStatusResponse getRawQueryStatus(QueryId queryId) {
        ClientProtos.GetQueryStatusResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetQueryStatusRequest request = ClientProtos.GetQueryStatusRequest.newBuilder().setSessionId(this.conn.sessionId).setQueryId(queryId.getProto()).build();
        try {
            res = stub.getQueryStatus(null, request);
        }
        catch (ServiceException t) {
            throw new RuntimeException(t);
        }
        return res;
    }

    @Override
    public QueryStatus getQueryStatus(QueryId queryId) throws QueryNotFoundException {
        ClientProtos.GetQueryStatusResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetQueryStatusRequest request = ClientProtos.GetQueryStatusRequest.newBuilder().setSessionId(this.conn.sessionId).setQueryId(queryId.getProto()).build();
        try {
            res = stub.getQueryStatus(null, request);
        }
        catch (ServiceException t) {
            throw new RuntimeException(t);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)res.getState(), QueryNotFoundException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return new QueryStatus(res);
    }

    @Override
    public ResultSet getQueryResult(QueryId queryId) throws QueryNotFoundException {
        if (queryId.equals((Object)QueryIdFactory.NULL_QUERY_ID)) {
            return this.createNullResultSet(queryId);
        }
        ClientProtos.GetQueryResultResponse response = this.getResultResponse(queryId);
        TableDesc tableDesc = CatalogUtil.newTableDesc((CatalogProtos.TableDescProto)response.getTableDesc());
        return new FetchResultSet(this, tableDesc.getLogicalSchema(), queryId, this.defaultFetchRows);
    }

    @Override
    public ResultSet createNullResultSet(QueryId queryId) {
        return TajoClientUtil.createNullResultSet(queryId);
    }

    @Override
    public ClientProtos.GetQueryResultResponse getResultResponse(QueryId queryId) throws QueryNotFoundException {
        ClientProtos.GetQueryResultResponse response;
        if (queryId.equals((Object)QueryIdFactory.NULL_QUERY_ID)) {
            return null;
        }
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetQueryResultRequest request = ClientProtos.GetQueryResultRequest.newBuilder().setQueryId(queryId.getProto()).setSessionId(this.conn.sessionId).build();
        try {
            response = stub.getQueryResult(null, request);
        }
        catch (ServiceException t) {
            throw new RuntimeException(t);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)response.getState(), QueryNotFoundException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response;
    }

    @Override
    public Future<TajoMemoryResultSet> fetchNextQueryResultAsync(final QueryId queryId, final int fetchRowNum) {
        final SettableFuture future = SettableFuture.create();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    future.set((Object)QueryClientImpl.this.fetchNextQueryResult(queryId, fetchRowNum));
                }
                catch (Throwable e) {
                    future.setException(e);
                }
            }
        });
        return future;
    }

    protected TajoMemoryResultSet fetchNextQueryResult(QueryId queryId, int fetchRowNum) throws TajoException {
        ClientProtos.GetQueryResultDataResponse response;
        boolean compress = this.conn.getProperties().getBool("useCompression");
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetQueryResultDataRequest.Builder request = ClientProtos.GetQueryResultDataRequest.newBuilder();
        request.setSessionId(this.conn.sessionId).setQueryId(queryId.getProto()).setFetchRowNum(fetchRowNum);
        if (compress) {
            request.setCompressCodec(DEFAULT_CODEC);
        }
        try {
            response = stub.getQueryResultData(null, request.build());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        if (response.hasResultSet()) {
            ClientProtos.SerializedResultSet resultSet = response.getResultSet();
            return new TajoMemoryResultSet(queryId, new Schema(resultSet.getSchema()), resultSet, this.getClientSideSessionVars());
        }
        return TajoClientUtil.createNullResultSet(queryId);
    }

    @Override
    public boolean updateQuery(String sql) throws TajoException {
        ClientProtos.UpdateQueryResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.QueryRequest request = this.buildQueryRequest(sql, false);
        try {
            response = stub.updateQuery(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        this.conn.updateSessionVarsCache(ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars()));
        return true;
    }

    @Override
    public boolean updateQueryWithJson(String json) throws TajoException {
        ClientProtos.UpdateQueryResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.QueryRequest request = this.buildQueryRequest(json, true);
        try {
            response = stub.updateQuery(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        return true;
    }

    @Override
    public List<ClientProtos.BriefQueryInfo> getRunningQueryList() {
        ClientProtos.GetQueryListResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stmb = this.conn.getTMStub();
        try {
            res = stmb.getRunningQueryList(null, this.conn.sessionId);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getQueryListList();
    }

    @Override
    public List<ClientProtos.BriefQueryInfo> getFinishedQueryList() {
        ClientProtos.GetQueryListResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            res = stub.getFinishedQueryList(null, this.conn.sessionId);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getQueryListList();
    }

    @Override
    public List<ClientProtos.WorkerResourceInfo> getClusterInfo() {
        ClientProtos.GetClusterInfoResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetClusterInfoRequest request = ClientProtos.GetClusterInfoRequest.newBuilder().setSessionId(this.conn.sessionId).build();
        try {
            res = stub.getClusterInfo(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getWorkerListList();
    }

    @Override
    public QueryStatus killQuery(QueryId queryId) throws QueryNotFoundException {
        long currentTimeMillis;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        QueryStatus status = this.getQueryStatus(queryId);
        ClientProtos.QueryIdRequest request = this.buildQueryIdRequest(queryId);
        try {
            stub.killQuery(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        long timeKillIssued = currentTimeMillis = System.currentTimeMillis();
        while (currentTimeMillis < timeKillIssued + 10000L && (status.getState() != TajoProtos.QueryState.QUERY_KILLED || status.getState() == TajoProtos.QueryState.QUERY_KILL_WAIT)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                break;
            }
            currentTimeMillis = System.currentTimeMillis();
            status = this.getQueryStatus(queryId);
        }
        return status;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public ClientProtos.QueryInfoProto getQueryInfo(QueryId queryId) throws QueryNotFoundException {
        ClientProtos.GetQueryInfoResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.QueryIdRequest request = this.buildQueryIdRequest(queryId);
        try {
            res = stub.getQueryInfo(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)res.getState(), QueryNotFoundException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getQueryInfo();
    }

    @Override
    public ClientProtos.QueryHistoryProto getQueryHistory(QueryId queryId) throws QueryNotFoundException {
        ClientProtos.QueryInfoProto queryInfo = this.getQueryInfo(queryId);
        if (queryInfo.getHostNameOfQM() == null || queryInfo.getQueryMasterClientPort() == 0) {
            return null;
        }
        InetSocketAddress qmAddress = new InetSocketAddress(queryInfo.getHostNameOfQM(), queryInfo.getQueryMasterClientPort());
        RpcClientManager manager = RpcClientManager.getInstance();
        try (NettyClientBase qmClient = null;){
            ClientProtos.GetQueryHistoryResponse res;
            qmClient = manager.newClient(qmAddress, QueryMasterClientProtocol.class, false, new Properties());
            this.conn.checkSessionAndGet(this.conn.getTajoMasterConnection());
            ClientProtos.QueryIdRequest request = ClientProtos.QueryIdRequest.newBuilder().setSessionId(this.conn.sessionId).setQueryId(queryId.getProto()).build();
            QueryMasterClientProtocol.QueryMasterClientProtocolService.BlockingInterface stub = (QueryMasterClientProtocol.QueryMasterClientProtocolService.BlockingInterface)qmClient.getStub();
            try {
                res = stub.getQueryHistory(null, request);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
            ClientProtos.QueryHistoryProto queryHistoryProto = res.getQueryHistory();
            return queryHistoryProto;
        }
    }

    private ClientProtos.QueryIdRequest buildQueryIdRequest(QueryId queryId) {
        return ClientProtos.QueryIdRequest.newBuilder().setSessionId(TajoIdProtos.SessionIdProto.newBuilder().setId(this.getSessionId())).setQueryId(queryId.getProto()).build();
    }

    private ClientProtos.QueryRequest buildQueryRequest(String query, boolean json) {
        return ClientProtos.QueryRequest.newBuilder().setSessionId(this.conn.sessionId).setQuery(query).setIsJson(json).build();
    }
}

