/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import org.apache.tajo.QueryId;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.ipc.ClientProtos;

public class QueryStatus {
    private QueryId queryId;
    private TajoProtos.QueryState state;
    private float progress;
    private long submitTime;
    private long finishTime;
    private boolean hasResult;
    private String errorText;
    private String errorTrace;
    private String queryMasterHost;
    private int queryMasterPort;

    public QueryStatus(ClientProtos.GetQueryStatusResponse proto) {
        this.queryId = new QueryId(proto.getQueryId());
        this.state = proto.getQueryState();
        this.progress = proto.getProgress();
        this.submitTime = proto.getSubmitTime();
        this.finishTime = proto.getFinishTime();
        this.hasResult = proto.getHasResult();
        this.errorText = proto.hasErrorMessage() ? proto.getErrorMessage() : "Internal error. Please check out log files in ${tajo_install_dir}/logs directory.";
        if (proto.hasErrorTrace()) {
            this.errorTrace = proto.getErrorTrace();
        }
        this.queryMasterHost = proto.getQueryMasterHost();
        this.queryMasterPort = proto.getQueryMasterPort();
    }

    public String getQueryMasterHost() {
        return this.queryMasterHost;
    }

    public int getQueryMasterPort() {
        return this.queryMasterPort;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public TajoProtos.QueryState getState() {
        return this.state;
    }

    public float getProgress() {
        return this.progress;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public String getErrorMessage() {
        return this.errorText;
    }

    public String getErrorTrace() {
        return this.errorTrace;
    }
}

