/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;

public class ResultSetUtil {
    public static String prettyFormat(ResultSet res) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder();
        ResultSetMetaData rsmd = res.getMetaData();
        int numOfColumns = rsmd.getColumnCount();
        for (i = 1; i <= numOfColumns; ++i) {
            if (i > 1) {
                sb.append(",  ");
            }
            String columnName = rsmd.getColumnName(i);
            sb.append(columnName);
        }
        sb.append("\n-------------------------------\n");
        while (res.next()) {
            for (i = 1; i <= numOfColumns; ++i) {
                if (i > 1) {
                    sb.append(",  ");
                }
                sb.append(String.valueOf(res.getObject(i)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toSqlType(TajoDataTypes.DataType type) {
        switch (type.getType()) {
            case BIT: {
                return "bit";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INT1: {
                return "tinyint";
            }
            case INT2: {
                return "smallint";
            }
            case INT4: {
                return "integer";
            }
            case INT8: {
                return "bigint";
            }
            case FLOAT4: {
                return "float";
            }
            case FLOAT8: {
                return "double";
            }
            case NUMERIC: {
                return "numeric";
            }
            case VARBINARY: {
                return "bytea";
            }
            case DATE: {
                return "date";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case TIME: {
                return "time";
            }
            case CHAR: 
            case VARCHAR: 
            case TEXT: {
                return "varchar";
            }
            case BLOB: {
                return "blob";
            }
            case RECORD: {
                return "struct";
            }
            case NULL_TYPE: {
                return "null";
            }
        }
        throw new TajoRuntimeException((TajoException)new UnsupportedException("unknown data type '" + type.getType().name() + "'"));
    }

    public static int tajoTypeToSqlType(TajoDataTypes.DataType type) throws SQLException {
        switch (type.getType()) {
            case BIT: {
                return -7;
            }
            case BOOLEAN: {
                return 16;
            }
            case INT1: {
                return -6;
            }
            case INT2: {
                return 5;
            }
            case INT4: {
                return 4;
            }
            case INT8: {
                return -5;
            }
            case FLOAT4: {
                return 6;
            }
            case FLOAT8: {
                return 8;
            }
            case NUMERIC: {
                return 2;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIME: {
                return 92;
            }
            case CHAR: 
            case VARCHAR: 
            case TEXT: {
                return 12;
            }
            case BLOB: {
                return 2004;
            }
            case RECORD: {
                return 2002;
            }
            case NULL_TYPE: {
                return 0;
            }
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    public static int columnDisplaySize(int columnType) throws SQLException {
        switch (columnType) {
            case -7: 
            case 1: 
            case 12: 
            case 16: {
                return ResultSetUtil.columnPrecision(columnType);
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return ResultSetUtil.columnPrecision(columnType) + 1;
            }
            case 91: 
            case 92: 
            case 93: {
                return ResultSetUtil.columnPrecision(columnType);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
            case 0: {
                return 4;
            }
        }
        return 0;
    }

    public static int columnPrecision(int columnType) throws SQLException {
        switch (columnType) {
            case -7: 
            case 16: {
                return 1;
            }
            case -2: 
            case 1: 
            case 12: 
            case 2002: 
            case 2003: 
            case 2004: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 18;
            }
            case 93: {
                return 29;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
            case 0: {
                return 0;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    public static int columnScale(int columnType) throws SQLException {
        switch (columnType) {
            case -7: 
            case -6: 
            case -5: 
            case -2: 
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: 
            case 2002: 
            case 2003: 
            case 2004: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 92: 
            case 93: {
                return 9;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }
}

