/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import com.google.protobuf.ServiceException;
import io.netty.channel.EventLoopGroup;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.SessionVars;
import org.apache.tajo.TajoIdProtos;
import org.apache.tajo.annotation.NotNull;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.auth.UserRoleInfo;
import org.apache.tajo.client.ClientParameterHelper;
import org.apache.tajo.client.v2.exception.ClientConnectionException;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.NoSuchSessionVariableException;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.ipc.TajoMasterClientProtocol;
import org.apache.tajo.rpc.NettyClientBase;
import org.apache.tajo.rpc.NettyUtils;
import org.apache.tajo.rpc.RpcClientManager;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.service.ServiceTracker;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.ProtoUtil;

public class SessionConnection
implements Closeable {
    private static final Log LOG = LogFactory.getLog(SessionConnection.class);
    final RpcClientManager manager;
    private String baseDatabase;
    private final UserRoleInfo userInfo;
    volatile TajoIdProtos.SessionIdProto sessionId;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<String, String> sessionVarsCache = new HashMap<String, String>();
    private final ServiceTracker serviceTracker;
    private final EventLoopGroup eventLoopGroup;
    private NettyClientBase client;
    private Properties clientParams;
    private final KeyValueSet properties;
    private static final SessionVars[] UPDATE_ON_RECONNECT = new SessionVars[]{SessionVars.SESSION_ID, SessionVars.SESSION_LAST_ACCESS_TIME, SessionVars.CLIENT_HOST};

    public SessionConnection(@NotNull ServiceTracker tracker, @Nullable String baseDatabase, @NotNull KeyValueSet properties) {
        this.serviceTracker = tracker;
        this.baseDatabase = baseDatabase;
        this.properties = properties;
        this.manager = RpcClientManager.getInstance();
        this.userInfo = UserRoleInfo.getCurrentUser();
        this.clientParams = ClientParameterHelper.getConnParams(properties.getAllKeyValus().entrySet());
        this.eventLoopGroup = NettyUtils.createEventLoopGroup((String)this.getClass().getSimpleName(), (int)4);
        try {
            this.client = this.getTajoMasterConnection();
        }
        catch (TajoRuntimeException e) {
            NettyUtils.shutdown((EventLoopGroup)this.eventLoopGroup);
            throw e;
        }
        this.updateSessionVariables(ClientParameterHelper.getSessionVars(properties.getAllKeyValus().entrySet()));
    }

    public Map<String, String> getClientSideSessionVars() {
        return Collections.unmodifiableMap(this.sessionVarsCache);
    }

    public synchronized NettyClientBase getTajoMasterConnection() {
        if (this.client != null && this.client.isConnected()) {
            return this.client;
        }
        try {
            RpcClientManager.cleanup((NettyClientBase[])new NettyClientBase[]{this.client});
            this.client = this.manager.newBlockingClient(this.getTajoMasterAddr(), TajoMasterClientProtocol.class, this.eventLoopGroup, this.clientParams);
        }
        catch (Throwable t) {
            throw new TajoRuntimeException((TajoException)new ClientConnectionException(t));
        }
        return this.client;
    }

    protected TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface getTMStub() {
        NettyClientBase tmClient = this.getTajoMasterConnection();
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)tmClient.getStub();
        this.checkSessionAndGet(tmClient);
        return stub;
    }

    public KeyValueSet getProperties() {
        return this.properties;
    }

    public void setSessionId(TajoIdProtos.SessionIdProto sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId.getId();
    }

    public String getBaseDatabase() {
        return this.baseDatabase;
    }

    public boolean isConnected() {
        if (!this.closed.get()) {
            try {
                return this.getTajoMasterConnection().isConnected();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public UserRoleInfo getUserInfo() {
        return this.userInfo;
    }

    public String getCurrentDatabase() {
        PrimitiveProtos.StringResponse response;
        NettyClientBase client = this.getTajoMasterConnection();
        this.checkSessionAndGet(client);
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMasterService = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
        try {
            response = tajoMasterService.getCurrentDatabase(null, this.sessionId);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getValue();
    }

    public Map<String, String> updateSessionVariables(Map<String, String> variables) {
        ClientProtos.SessionUpdateResponse response;
        NettyClientBase client = this.getTajoMasterConnection();
        this.checkSessionAndGet(client);
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMasterService = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
        KeyValueSet keyValueSet = new KeyValueSet();
        keyValueSet.putAll(variables);
        ClientProtos.UpdateSessionVariableRequest request = ClientProtos.UpdateSessionVariableRequest.newBuilder().setSessionId(this.sessionId).setSessionVars(keyValueSet.getProto()).build();
        try {
            response = tajoMasterService.updateSessionVariables(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        this.updateSessionVarsCache(ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars()));
        return Collections.unmodifiableMap(this.sessionVarsCache);
    }

    public Map<String, String> unsetSessionVariables(List<String> variables) {
        ClientProtos.SessionUpdateResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.getTMStub();
        ClientProtos.UpdateSessionVariableRequest request = ClientProtos.UpdateSessionVariableRequest.newBuilder().setSessionId(this.sessionId).addAllUnsetVariables(variables).build();
        try {
            response = stub.updateSessionVariables(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        this.updateSessionVarsCache(ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars()));
        return Collections.unmodifiableMap(this.sessionVarsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSessionVarsCache(Map<String, String> variables) {
        Map<String, String> map = this.sessionVarsCache;
        synchronized (map) {
            this.sessionVarsCache.clear();
            this.sessionVarsCache.putAll(variables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionVariable(String varname) throws NoSuchSessionVariableException {
        PrimitiveProtos.StringResponse response;
        Map<String, String> map = this.sessionVarsCache;
        synchronized (map) {
            if (this.sessionVarsCache.containsKey(varname)) {
                return this.sessionVarsCache.get(varname);
            }
        }
        NettyClientBase client = this.getTajoMasterConnection();
        this.checkSessionAndGet(client);
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
        try {
            response = stub.getSessionVariable(null, this.getSessionedString(varname));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        if (ReturnStateUtil.isThisError((PrimitiveProtos.ReturnState)response.getState(), (Errors.ResultCode)Errors.ResultCode.NO_SUCH_SESSION_VARIABLE)) {
            throw new NoSuchSessionVariableException(response.getState());
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getValue();
    }

    public boolean existSessionVariable(String varname) {
        PrimitiveProtos.ReturnState state;
        try {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.getTMStub();
            state = stub.existSessionVariable(null, this.getSessionedString(varname));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        if (ReturnStateUtil.isThisError((PrimitiveProtos.ReturnState)state, (Errors.ResultCode)Errors.ResultCode.NO_SUCH_SESSION_VARIABLE)) {
            return false;
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
        return true;
    }

    public Map<String, String> getAllSessionVariables() {
        PrimitiveProtos.KeyValueSetResponse response;
        NettyClientBase client = this.getTajoMasterConnection();
        this.checkSessionAndGet(client);
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
        try {
            response = stub.getAllSessionVariables(null, this.sessionId);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getValue());
    }

    public void selectDatabase(String dbName) throws UndefinedDatabaseException {
        try {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.getTMStub();
            PrimitiveProtos.ReturnState state = stub.selectDatabase(null, this.getSessionedString(dbName));
            ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, UndefinedDatabaseException.class);
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
            this.baseDatabase = dbName;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        NettyClientBase client = null;
        try {
            client = this.getTajoMasterConnection();
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMaster = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
            tajoMaster.removeSession(null, this.sessionId);
        }
        catch (Throwable throwable) {
            RpcClientManager.cleanup((NettyClientBase[])new NettyClientBase[]{client});
            NettyUtils.shutdown((EventLoopGroup)this.eventLoopGroup);
            catch (Throwable throwable2) {
                RpcClientManager.cleanup((NettyClientBase[])new NettyClientBase[]{client});
                NettyUtils.shutdown((EventLoopGroup)this.eventLoopGroup);
                throw throwable2;
            }
        }
        RpcClientManager.cleanup((NettyClientBase[])new NettyClientBase[]{client});
        NettyUtils.shutdown((EventLoopGroup)this.eventLoopGroup);
    }

    protected InetSocketAddress getTajoMasterAddr() {
        return this.serviceTracker.getClientServiceAddress();
    }

    protected void checkSessionAndGet(NettyClientBase client) {
        if (this.sessionId == null) {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMasterService = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
            ClientProtos.CreateSessionRequest.Builder builder = ClientProtos.CreateSessionRequest.newBuilder();
            builder.setUsername(this.userInfo.getUserName()).build();
            if (this.baseDatabase != null) {
                builder.setBaseDatabaseName(this.baseDatabase);
            }
            ClientProtos.CreateSessionResponse response = null;
            try {
                response = tajoMasterService.createSession(null, builder.build());
            }
            catch (ServiceException se) {
                throw new RuntimeException(se);
            }
            if (ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)response.getState())) {
                this.sessionId = response.getSessionId();
                this.updateSessionVarsCache(ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Got session %s as a user '%s'.", this.sessionId.getId(), this.userInfo.getUserName()));
                }
            } else {
                throw new TajoRuntimeException(response.getState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() throws Exception {
        NettyClientBase client;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMasterService;
        ClientProtos.CreateSessionResponse response;
        ClientProtos.CreateSessionRequest.Builder builder = ClientProtos.CreateSessionRequest.newBuilder();
        builder.setUsername(this.userInfo.getUserName()).build();
        if (this.baseDatabase != null) {
            builder.setBaseDatabaseName(this.baseDatabase);
        }
        if (ReturnStateUtil.isError((PrimitiveProtos.ReturnState)(response = (tajoMasterService = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)(client = this.getTajoMasterConnection()).getStub()).createSession(null, builder.build())).getState())) {
            return false;
        }
        this.sessionId = response.getSessionId();
        Map sessionVars = ProtoUtil.convertToMap((PrimitiveProtos.KeyValueSetProto)response.getSessionVars());
        Map<String, String> map = this.sessionVarsCache;
        synchronized (map) {
            for (SessionVars var : UPDATE_ON_RECONNECT) {
                String value = (String)sessionVars.get(var.keyname());
                if (value == null) continue;
                this.sessionVarsCache.put(var.keyname(), value);
            }
        }
        try {
            KeyValueSet keyValueSet = new KeyValueSet();
            keyValueSet.putAll(this.sessionVarsCache);
            ClientProtos.UpdateSessionVariableRequest request = ClientProtos.UpdateSessionVariableRequest.newBuilder().setSessionId(this.sessionId).setSessionVars(keyValueSet.getProto()).build();
            if (ReturnStateUtil.isError((PrimitiveProtos.ReturnState)tajoMasterService.updateSessionVariables(null, request).getState())) {
                tajoMasterService.removeSession(null, this.sessionId);
                return false;
            }
            LOG.info((Object)String.format("Reconnected to session %s as a user '%s'.", this.sessionId.getId(), this.userInfo.getUserName()));
            return true;
        }
        catch (ServiceException e) {
            tajoMasterService.removeSession(null, this.sessionId);
            return false;
        }
    }

    ClientProtos.SessionedStringProto getSessionedString(String str) {
        ClientProtos.SessionedStringProto.Builder builder = ClientProtos.SessionedStringProto.newBuilder();
        builder.setSessionId(this.sessionId);
        if (str != null) {
            builder.setValue(str);
        }
        return builder.build();
    }
}

