/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.QueryId;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.annotation.ThreadSafe;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.partition.PartitionMethodDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.client.CatalogAdminClient;
import org.apache.tajo.client.CatalogAdminClientImpl;
import org.apache.tajo.client.DummyServiceTracker;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.QueryClientImpl;
import org.apache.tajo.client.QueryStatus;
import org.apache.tajo.client.SessionConnection;
import org.apache.tajo.client.TajoClient;
import org.apache.tajo.client.TajoClientUtil;
import org.apache.tajo.exception.CannotDropCurrentDatabaseException;
import org.apache.tajo.exception.DuplicateDatabaseException;
import org.apache.tajo.exception.DuplicateTableException;
import org.apache.tajo.exception.InsufficientPrivilegeException;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.UnavailableTableLocationException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.exception.UndefinedPartitionMethodException;
import org.apache.tajo.exception.UndefinedTableException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.TajoMemoryResultSet;
import org.apache.tajo.service.ServiceTracker;
import org.apache.tajo.util.KeyValueSet;

@ThreadSafe
public class TajoClientImpl
extends SessionConnection
implements TajoClient,
QueryClient,
CatalogAdminClient {
    private final Log LOG = LogFactory.getLog(TajoClientImpl.class);
    QueryClient queryClient = new QueryClientImpl(this);
    CatalogAdminClient catalogClient = new CatalogAdminClientImpl(this);

    public TajoClientImpl(ServiceTracker tracker, @Nullable String baseDatabase, KeyValueSet properties) {
        super(tracker, baseDatabase, properties);
    }

    public TajoClientImpl(InetSocketAddress addr, @Nullable String baseDatabase, KeyValueSet properties) {
        this(new DummyServiceTracker(addr), baseDatabase, properties);
    }

    public TajoClientImpl(ServiceTracker serviceTracker) throws SQLException {
        this(serviceTracker, null);
    }

    public TajoClientImpl(ServiceTracker serviceTracker, @Nullable String baseDatabase) throws SQLException {
        this(serviceTracker, baseDatabase, new KeyValueSet());
    }

    @Override
    public void close() {
        this.queryClient.close();
        super.close();
    }

    @Override
    public void closeQuery(QueryId queryId) {
        this.queryClient.closeQuery(queryId);
    }

    @Override
    public void closeNonForwardQuery(QueryId queryId) {
        this.queryClient.closeNonForwardQuery(queryId);
    }

    @Override
    public ClientProtos.SubmitQueryResponse executeQuery(String sql) {
        return this.queryClient.executeQuery(sql);
    }

    @Override
    public ClientProtos.SubmitQueryResponse executeQueryWithJson(String json) {
        return this.queryClient.executeQueryWithJson(json);
    }

    @Override
    public ResultSet executeQueryAndGetResult(String sql) throws TajoException {
        return this.queryClient.executeQueryAndGetResult(sql);
    }

    @Override
    public ResultSet executeJsonQueryAndGetResult(String json) throws TajoException {
        return this.queryClient.executeJsonQueryAndGetResult(json);
    }

    @Override
    public QueryStatus getQueryStatus(QueryId queryId) throws QueryNotFoundException {
        return this.queryClient.getQueryStatus(queryId);
    }

    @Override
    public ResultSet getQueryResult(QueryId queryId) throws TajoException {
        return this.queryClient.getQueryResult(queryId);
    }

    @Override
    public ResultSet createNullResultSet(QueryId queryId) {
        return TajoClientUtil.createNullResultSet(queryId);
    }

    @Override
    public ClientProtos.GetQueryResultResponse getResultResponse(QueryId queryId) throws TajoException {
        return this.queryClient.getResultResponse(queryId);
    }

    @Override
    public Future<TajoMemoryResultSet> fetchNextQueryResultAsync(QueryId queryId, int fetchRowNum) {
        return this.queryClient.fetchNextQueryResultAsync(queryId, fetchRowNum);
    }

    @Override
    public boolean updateQuery(String sql) throws TajoException {
        return this.queryClient.updateQuery(sql);
    }

    @Override
    public boolean updateQueryWithJson(String json) throws TajoException {
        return this.queryClient.updateQueryWithJson(json);
    }

    @Override
    public QueryStatus killQuery(QueryId queryId) throws QueryNotFoundException {
        return this.queryClient.killQuery(queryId);
    }

    @Override
    public List<ClientProtos.BriefQueryInfo> getRunningQueryList() {
        return this.queryClient.getRunningQueryList();
    }

    @Override
    public List<ClientProtos.BriefQueryInfo> getFinishedQueryList() {
        return this.queryClient.getFinishedQueryList();
    }

    @Override
    public List<ClientProtos.WorkerResourceInfo> getClusterInfo() {
        return this.queryClient.getClusterInfo();
    }

    @Override
    public ClientProtos.QueryInfoProto getQueryInfo(QueryId queryId) throws QueryNotFoundException {
        return this.queryClient.getQueryInfo(queryId);
    }

    @Override
    public ClientProtos.QueryHistoryProto getQueryHistory(QueryId queryId) throws QueryNotFoundException {
        return this.queryClient.getQueryHistory(queryId);
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.queryClient.setMaxRows(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.queryClient.getMaxRows();
    }

    @Override
    public void createDatabase(String databaseName) throws DuplicateDatabaseException {
        this.catalogClient.createDatabase(databaseName);
    }

    @Override
    public boolean existDatabase(String databaseName) {
        return this.catalogClient.existDatabase(databaseName);
    }

    @Override
    public void dropDatabase(String databaseName) throws UndefinedDatabaseException, InsufficientPrivilegeException, CannotDropCurrentDatabaseException {
        this.catalogClient.dropDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabaseNames() {
        return this.catalogClient.getAllDatabaseNames();
    }

    @Override
    public boolean existTable(String tableName) {
        return this.catalogClient.existTable(tableName);
    }

    @Override
    public TableDesc createExternalTable(String tableName, Schema schema, URI path, TableMeta meta) throws DuplicateTableException, UnavailableTableLocationException, InsufficientPrivilegeException {
        return this.catalogClient.createExternalTable(tableName, schema, path, meta);
    }

    @Override
    public TableDesc createExternalTable(String tableName, Schema schema, URI path, TableMeta meta, PartitionMethodDesc partitionMethodDesc) throws DuplicateTableException, UnavailableTableLocationException, InsufficientPrivilegeException {
        return this.catalogClient.createExternalTable(tableName, schema, path, meta, partitionMethodDesc);
    }

    @Override
    public void dropTable(String tableName) throws UndefinedTableException, InsufficientPrivilegeException {
        this.dropTable(tableName, false);
    }

    @Override
    public void dropTable(String tableName, boolean purge) throws UndefinedTableException, InsufficientPrivilegeException {
        this.catalogClient.dropTable(tableName, purge);
    }

    @Override
    public List<String> getTableList(@Nullable String databaseName) {
        return this.catalogClient.getTableList(databaseName);
    }

    @Override
    public TableDesc getTableDesc(String tableName) throws UndefinedTableException {
        return this.catalogClient.getTableDesc(tableName);
    }

    @Override
    public List<CatalogProtos.FunctionDescProto> getFunctions(String functionName) {
        return this.catalogClient.getFunctions(functionName);
    }

    @Override
    public List<CatalogProtos.PartitionDescProto> getAllPartitions(String tableName) throws UndefinedDatabaseException, UndefinedTableException, UndefinedPartitionMethodException {
        return this.catalogClient.getAllPartitions(tableName);
    }

    @Override
    public CatalogProtos.IndexDescProto getIndex(String indexName) {
        return this.catalogClient.getIndex(indexName);
    }

    @Override
    public boolean existIndex(String indexName) {
        return this.catalogClient.existIndex(indexName);
    }

    @Override
    public List<CatalogProtos.IndexDescProto> getIndexes(String tableName) {
        return this.catalogClient.getIndexes(tableName);
    }

    @Override
    public boolean hasIndexes(String tableName) {
        return this.catalogClient.hasIndexes(tableName);
    }

    @Override
    public CatalogProtos.IndexDescProto getIndex(String tableName, String[] columnNames) {
        return this.catalogClient.getIndex(tableName, columnNames);
    }

    @Override
    public boolean existIndex(String tableName, String[] columnName) {
        return this.catalogClient.existIndex(tableName, columnName);
    }

    @Override
    public boolean dropIndex(String indexName) {
        return this.catalogClient.dropIndex(indexName);
    }
}

