/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import java.io.IOException;
import java.sql.ResultSet;
import org.apache.tajo.QueryId;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.SessionVars;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.QueryStatus;
import org.apache.tajo.client.TajoClient;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.FetchResultSet;
import org.apache.tajo.jdbc.TajoMemoryResultSet;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class TajoClientUtil {
    public static final ResultSet NULL_RESULT_SET = new TajoMemoryResultSet(QueryIdFactory.NULL_QUERY_ID, new Schema(), null, null);

    public static boolean isQueryWaitingForSchedule(TajoProtos.QueryState state) {
        return state == TajoProtos.QueryState.QUERY_NOT_ASSIGNED || state == TajoProtos.QueryState.QUERY_MASTER_INIT || state == TajoProtos.QueryState.QUERY_MASTER_LAUNCHED;
    }

    public static boolean isQueryInited(TajoProtos.QueryState state) {
        return state == TajoProtos.QueryState.QUERY_NEW || state == TajoProtos.QueryState.QUERY_INIT;
    }

    public static boolean isQueryRunning(TajoProtos.QueryState state) {
        return TajoClientUtil.isQueryInited(state) || state == TajoProtos.QueryState.QUERY_RUNNING;
    }

    public static boolean isQueryComplete(TajoProtos.QueryState state) {
        return !TajoClientUtil.isQueryWaitingForSchedule(state) && !TajoClientUtil.isQueryRunning(state);
    }

    public static QueryStatus waitCompletion(QueryClient client, QueryId queryId) throws QueryNotFoundException {
        QueryStatus status = client.getQueryStatus(queryId);
        while (!TajoClientUtil.isQueryComplete(status.getState())) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            status = client.getQueryStatus(queryId);
        }
        return status;
    }

    public static ResultSet createResultSet(TajoClient client, QueryId queryId, ClientProtos.GetQueryResultResponse response, int fetchRows) throws IOException {
        TableDesc desc = CatalogUtil.newTableDesc((CatalogProtos.TableDescProto)response.getTableDesc());
        return new FetchResultSet(client, desc.getLogicalSchema(), queryId, fetchRows);
    }

    public static ResultSet createResultSet(QueryClient client, ClientProtos.SubmitQueryResponse response, int fetchRows) {
        if (response.hasTableDesc()) {
            int fetchRowNum = fetchRows;
            if (response.hasSessionVars()) {
                for (PrimitiveProtos.KeyValueProto eachKeyValue : response.getSessionVars().getKeyvalList()) {
                    if (!eachKeyValue.getKey().equals(SessionVars.FETCH_ROWNUM.keyname())) continue;
                    fetchRowNum = Integer.parseInt(eachKeyValue.getValue());
                }
            }
            TableDesc tableDesc = new TableDesc(response.getTableDesc());
            return new FetchResultSet(client, tableDesc.getLogicalSchema(), new QueryId(response.getQueryId()), fetchRowNum);
        }
        ClientProtos.SerializedResultSet serializedResultSet = response.getResultSet();
        return new TajoMemoryResultSet(new QueryId(response.getQueryId()), new Schema(serializedResultSet.getSchema()), serializedResultSet, client.getClientSideSessionVars());
    }

    public static TajoMemoryResultSet createNullResultSet(QueryId queryId) {
        return new TajoMemoryResultSet(queryId, new Schema(), null, null);
    }
}

