/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client.v2;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tajo.QueryId;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.annotation.ThreadSafe;
import org.apache.tajo.auth.UserRoleInfo;
import org.apache.tajo.client.DummyServiceTracker;
import org.apache.tajo.client.QueryClientImpl;
import org.apache.tajo.client.SessionConnection;
import org.apache.tajo.client.TajoClientUtil;
import org.apache.tajo.client.v2.ClientDelegate;
import org.apache.tajo.client.v2.ClientUtil;
import org.apache.tajo.client.v2.FutureListener;
import org.apache.tajo.client.v2.QueryFuture;
import org.apache.tajo.client.v2.QueryState;
import org.apache.tajo.client.v2.ServiceDiscovery;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.NotImplementedException;
import org.apache.tajo.exception.QueryFailedException;
import org.apache.tajo.exception.QueryKilledException;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.service.ServiceTracker;
import org.apache.tajo.service.ServiceTrackerException;
import org.apache.tajo.service.TajoMasterInfo;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.NetUtils;

@ThreadSafe
public class LegacyClientDelegate
extends SessionConnection
implements ClientDelegate {
    private QueryClientImpl queryClient;
    private final ExecutorService executor = Executors.newFixedThreadPool(8);

    public LegacyClientDelegate(String host, int port, Properties clientParams) {
        super(new DummyServiceTracker(NetUtils.createSocketAddr((String)host, (int)port)), null, new KeyValueSet((Map)(clientParams == null ? new HashMap() : Maps.fromProperties((Properties)clientParams))));
        this.queryClient = new QueryClientImpl(this);
    }

    public LegacyClientDelegate(ServiceDiscovery discovery, Properties clientParams) {
        super(new DelegateServiceTracker(discovery), null, new KeyValueSet((Map)(clientParams == null ? new HashMap() : Maps.fromProperties((Properties)clientParams))));
        this.queryClient = new QueryClientImpl(this);
    }

    @Override
    public void close() {
        this.executor.shutdown();
        super.close();
    }

    @Override
    public int executeUpdate(String sql) throws TajoException {
        this.queryClient.updateQuery(sql);
        return 0;
    }

    @Override
    public ResultSet executeSQL(String sql) throws TajoException, QueryFailedException, QueryKilledException {
        try {
            return (ResultSet)this.executeSQLAsync(sql).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TajoException) {
                throw (TajoException)e.getCause();
            }
            if (e.getCause() instanceof TajoRuntimeException) {
                throw new TajoException((DefaultTajoException)((TajoRuntimeException)e.getCause()));
            }
            throw new TajoInternalError((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryFuture executeSQLAsync(String sql) throws TajoException {
        ClientProtos.SubmitQueryResponse response = this.queryClient.executeQuery(sql);
        ExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        QueryId queryId = new QueryId(response.getQueryId());
        switch (response.getResultType()) {
            case ENCLOSED: {
                return new QueryFutureForEnclosed(queryId, TajoClientUtil.createResultSet(this.queryClient, response, 200));
            }
            case FETCH: {
                AsyncQueryFuture future = new AsyncQueryFuture(queryId);
                this.executor.execute(future);
                return future;
            }
        }
        return new QueryFutureForNoFetch(queryId);
    }

    @Override
    public String currentDB() {
        return this.getCurrentDatabase();
    }

    @Override
    public void selectDB(String db) throws UndefinedDatabaseException {
        this.selectDatabase(db);
    }

    public static QueryState convert(TajoProtos.QueryState state) {
        switch (state) {
            case QUERY_NEW: 
            case QUERY_INIT: 
            case QUERY_NOT_ASSIGNED: {
                return QueryState.SCHEDULED;
            }
            case QUERY_MASTER_INIT: 
            case QUERY_MASTER_LAUNCHED: 
            case QUERY_RUNNING: {
                return QueryState.RUNNING;
            }
            case QUERY_KILL_WAIT: {
                return QueryState.KILLING;
            }
            case QUERY_KILLED: {
                return QueryState.KILLED;
            }
            case QUERY_FAILED: {
                return QueryState.FAILED;
            }
            case QUERY_ERROR: {
                return QueryState.ERROR;
            }
            case QUERY_SUCCEEDED: {
                return QueryState.COMPLETED;
            }
        }
        throw new RuntimeException("Unknown state:" + state.name());
    }

    public static class DelegateServiceTracker
    implements ServiceTracker {
        private final ServiceDiscovery discovery;

        DelegateServiceTracker(ServiceDiscovery discovery) {
            this.discovery = discovery;
        }

        public boolean isHighAvailable() {
            return false;
        }

        public InetSocketAddress getUmbilicalAddress() throws ServiceTrackerException {
            return null;
        }

        public InetSocketAddress getClientServiceAddress() throws ServiceTrackerException {
            return this.discovery.clientAddress();
        }

        public InetSocketAddress getResourceTrackerAddress() throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public InetSocketAddress getCatalogAddress() throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public InetSocketAddress getMasterHttpInfo() throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public int getState(String masterName, TajoConf conf) throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public int formatHA(TajoConf conf) throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public List<String> getMasters(TajoConf conf) throws ServiceTrackerException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public void register() throws IOException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public void delete() throws IOException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public boolean isActiveMaster() {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }

        public List<TajoMasterInfo> getMasters() throws IOException {
            throw new TajoRuntimeException((TajoException)new NotImplementedException());
        }
    }

    private class AsyncQueryFuture
    extends AbstractFuture<ResultSet>
    implements QueryFuture,
    Runnable {
        private final QueryId queryId;
        private volatile QueryState lastState;
        private volatile float progress;
        private final long submitTime = System.currentTimeMillis();
        private volatile long startTime = 0L;
        private volatile long finishTime = 0L;

        public AsyncQueryFuture(QueryId queryId) {
            this.queryId = queryId;
            this.lastState = QueryState.SCHEDULED;
        }

        @Override
        public String id() {
            return this.queryId.toString();
        }

        @Override
        public boolean isOk() {
            return ClientUtil.isOk(this.lastState);
        }

        @Override
        public boolean isSuccessful() {
            return this.lastState == QueryState.COMPLETED;
        }

        @Override
        public boolean isFailed() {
            return ClientUtil.isFailed(this.lastState);
        }

        @Override
        public boolean isKilled() {
            try {
                return LegacyClientDelegate.this.queryClient.getQueryStatus(this.queryId).getState() == TajoProtos.QueryState.QUERY_KILLED;
            }
            catch (QueryNotFoundException e) {
                throw new TajoInternalError((TajoException)e);
            }
        }

        @Override
        public QueryState state() {
            return this.lastState;
        }

        @Override
        public String queue() {
            return "default";
        }

        @Override
        public UserRoleInfo user() {
            return UserRoleInfo.getCurrentUser();
        }

        @Override
        public float progress() {
            return this.progress;
        }

        @Override
        public void kill() {
            try {
                LegacyClientDelegate.this.queryClient.killQuery(this.queryId).getState();
            }
            catch (QueryNotFoundException e) {
                throw new TajoInternalError((TajoException)e);
            }
        }

        @Override
        public long submitTime() {
            return this.submitTime;
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        @Override
        public long finishTime() {
            return this.finishTime;
        }

        @Override
        public void close() {
            LegacyClientDelegate.this.queryClient.closeQuery(this.queryId);
        }

        @Override
        public void addListener(final FutureListener<QueryFuture> listener) {
            final AsyncQueryFuture f = this;
            this.addListener(new Runnable(){

                @Override
                public void run() {
                    listener.processingCompleted(f);
                }
            }, LegacyClientDelegate.this.executor);
        }

        private void updateState(ClientProtos.GetQueryStatusResponse lastState) {
            this.startTime = lastState.getSubmitTime();
            this.finishTime = lastState.getFinishTime();
            this.progress = lastState.getProgress();
            this.lastState = LegacyClientDelegate.convert(lastState.getQueryState());
        }

        ClientProtos.GetQueryStatusResponse waitCompletion() {
            ClientProtos.GetQueryStatusResponse response = LegacyClientDelegate.this.queryClient.getRawQueryStatus(this.queryId);
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
            this.updateState(response);
            while (!TajoClientUtil.isQueryComplete(response.getQueryState())) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = LegacyClientDelegate.this.queryClient.getRawQueryStatus(this.queryId);
                this.updateState(response);
                ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
            }
            return response;
        }

        @Override
        public void run() {
            ClientProtos.GetQueryStatusResponse finalResponse;
            try {
                finalResponse = this.waitCompletion();
            }
            catch (Throwable t) {
                this.setException(t);
                return;
            }
            if (finalResponse.getQueryState() == TajoProtos.QueryState.QUERY_SUCCEEDED) {
                if (finalResponse.hasHasResult()) {
                    try {
                        this.set(LegacyClientDelegate.this.queryClient.getQueryResult(this.queryId));
                    }
                    catch (QueryNotFoundException e) {
                        this.setException(e);
                        return;
                    }
                } else {
                    this.set(TajoClientUtil.NULL_RESULT_SET);
                }
            } else if (finalResponse.getQueryState() == TajoProtos.QueryState.QUERY_KILLED) {
                this.setException((Throwable)new QueryKilledException());
            } else if (finalResponse.hasErrorMessage()) {
                this.setException((Throwable)new QueryFailedException(finalResponse.getErrorMessage()));
            } else {
                this.setException((Throwable)new QueryFailedException("internal error. See master and worker logs in ${tajo-install-dir}/logs for the cause of this error"));
            }
        }
    }

    private class QueryFutureForEnclosed
    extends QueryFutureForNoFetch {
        private final ResultSet resultSet;

        QueryFutureForEnclosed(QueryId id, ResultSet resultSet) {
            super(id);
            this.resultSet = resultSet;
        }

        @Override
        public ResultSet get() {
            return this.resultSet;
        }

        @Override
        public ResultSet get(long timeout, TimeUnit unit) {
            return this.resultSet;
        }
    }

    private class QueryFutureForNoFetch
    implements QueryFuture {
        protected final QueryId id;
        private final long now = System.currentTimeMillis();

        QueryFutureForNoFetch(QueryId id) {
            this.id = id;
        }

        @Override
        public String id() {
            return this.id.toString();
        }

        @Override
        public String queue() {
            return "default";
        }

        @Override
        public QueryState state() {
            return QueryState.COMPLETED;
        }

        @Override
        public float progress() {
            return 1.0f;
        }

        @Override
        public boolean isOk() {
            return true;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isKilled() {
            return false;
        }

        @Override
        public UserRoleInfo user() {
            return UserRoleInfo.getCurrentUser();
        }

        @Override
        public void kill() {
        }

        @Override
        public long submitTime() {
            return 0L;
        }

        @Override
        public long startTime() {
            return this.now;
        }

        @Override
        public long finishTime() {
            return this.now;
        }

        @Override
        public void close() {
            LegacyClientDelegate.this.queryClient.closeQuery(this.id);
        }

        @Override
        public void addListener(FutureListener<QueryFuture> future) {
            future.processingCompleted(this);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ResultSet get() {
            return TajoClientUtil.NULL_RESULT_SET;
        }

        @Override
        public ResultSet get(long timeout, TimeUnit unit) {
            return TajoClientUtil.NULL_RESULT_SET;
        }
    }
}

