/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client.v2;

import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.client.v2.ClientDelegate;
import org.apache.tajo.client.v2.ClientDelegateFactory;
import org.apache.tajo.client.v2.QueryFuture;
import org.apache.tajo.client.v2.ServiceDiscovery;
import org.apache.tajo.client.v2.exception.ClientUnableToConnectException;
import org.apache.tajo.exception.QueryFailedException;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.UndefinedDatabaseException;

public class TajoClient
implements Closeable {
    private static Log LOG = LogFactory.getLog(TajoClient.class);
    public static final int DEFAULT_PORT = 26002;
    private final ClientDelegate delegate;

    public TajoClient(String host) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(host, 26002, null);
    }

    public TajoClient(String host, Properties clientParams) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(host, 26002, clientParams);
    }

    public TajoClient(String host, int port) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(host, port, null);
    }

    public TajoClient(String host, int port, Properties clientParams) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(host, port, clientParams);
    }

    public TajoClient(ServiceDiscovery discovery) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(discovery, null);
    }

    public TajoClient(ServiceDiscovery discovery, Properties clientParams) throws ClientUnableToConnectException {
        this.delegate = ClientDelegateFactory.newDefaultDelegate(discovery, clientParams);
    }

    public int executeUpdate(String sql) throws TajoException {
        return this.delegate.executeUpdate(sql);
    }

    public ResultSet executeQuery(String sql) throws TajoException, QueryFailedException {
        return this.delegate.executeSQL(sql);
    }

    public QueryFuture executeQueryAsync(String sql) throws TajoException {
        return this.delegate.executeSQLAsync(sql);
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    public void selectDB(String database) throws UndefinedDatabaseException {
        this.delegate.selectDB(database);
    }

    public String currentDB() {
        return this.delegate.currentDB();
    }
}

