/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.tajo.QueryId;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.SQLExceptionUtil;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.jdbc.TajoMemoryResultSet;
import org.apache.tajo.jdbc.TajoResultSetBase;
import org.apache.tajo.jdbc.TajoSQLException;
import org.apache.tajo.storage.Tuple;

public class FetchResultSet
extends TajoResultSetBase {
    protected QueryClient tajoClient;
    private int fetchRowNum;
    private TajoMemoryResultSet currentResultSet;
    private Future<TajoMemoryResultSet> nextResultSet;
    private boolean finished;
    private int maxRows;

    public FetchResultSet(QueryClient tajoClient, Schema schema, QueryId queryId, int fetchRowNum) {
        super(queryId, schema, tajoClient.getClientSideSessionVars());
        this.tajoClient = tajoClient;
        this.maxRows = tajoClient.getMaxRows();
        this.fetchRowNum = fetchRowNum;
        this.totalRow = Integer.MAX_VALUE;
    }

    @Override
    protected Tuple nextTuple() throws IOException {
        if (this.finished || this.maxRows > 0 && this.curRow >= this.maxRows) {
            return null;
        }
        try {
            while (!this.finished) {
                if (this.currentResultSet != null) {
                    this.currentResultSet.next();
                    Tuple tuple = this.currentResultSet.cur;
                    if (tuple == null) {
                        this.currentResultSet.close();
                        this.currentResultSet = null;
                        continue;
                    }
                    return tuple;
                }
                if (this.nextResultSet == null) {
                    this.nextResultSet = this.tajoClient.fetchNextQueryResultAsync(this.queryId, this.fetchRowNum);
                    continue;
                }
                this.currentResultSet = this.nextResultSet.get();
                if (this.currentResultSet.totalRow == 0L) {
                    this.currentResultSet.close();
                    this.currentResultSet = null;
                    this.nextResultSet = null;
                    this.finished = true;
                    continue;
                }
                this.nextResultSet = this.tajoClient.fetchNextQueryResultAsync(this.queryId, this.fetchRowNum);
            }
            return null;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            throw new IOException(t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new TajoInternalError(t);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        if (this.nextResultSet != null) {
            try {
                this.nextResultSet.get(1L, TimeUnit.SECONDS).close();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof DefaultTajoException) {
                    throw SQLExceptionUtil.toSQLException((DefaultTajoException)((DefaultTajoException)t));
                }
                throw new TajoSQLException(Errors.ResultCode.INTERNAL_ERROR, t, t.getMessage());
            }
            catch (Throwable t) {
                throw new TajoSQLException(Errors.ResultCode.INTERNAL_ERROR, t, t.getMessage());
            }
        }
        this.tajoClient.closeQuery(this.queryId);
    }
}

