/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.datetime.TimeMeta;

public class MetaDataTuple
implements Tuple {
    List<Datum> values = new ArrayList<Datum>();

    public MetaDataTuple(int size) {
        this.values = new ArrayList<Datum>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add((Datum)NullDatum.get());
        }
    }

    public int size() {
        return this.values.size();
    }

    public boolean contains(int fieldid) {
        return false;
    }

    public boolean isBlank(int fieldid) {
        return this.values.get(fieldid) == null;
    }

    public boolean isBlankOrNull(int fieldid) {
        return this.values.get(fieldid) == null || this.values.get(fieldid).isNull();
    }

    public void put(int fieldId, Tuple tuple) {
        this.put(fieldId, tuple.asDatum(fieldId));
    }

    public void clear() {
        this.values.clear();
    }

    public void put(int fieldId, Datum value) {
        this.values.set(fieldId, value);
    }

    public void put(Datum[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.values.set(i, values[i]);
        }
    }

    public TajoDataTypes.Type type(int fieldId) {
        return this.values.get(fieldId).type();
    }

    public int size(int fieldId) {
        return this.values.get(fieldId).size();
    }

    public void clearOffset() {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public Datum asDatum(int fieldId) {
        return this.values.get(fieldId);
    }

    public void setOffset(long offset) {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public long getOffset() {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public boolean getBool(int fieldId) {
        return this.values.get(fieldId).asBool();
    }

    public byte getByte(int fieldId) {
        return this.values.get(fieldId).asByte();
    }

    public char getChar(int fieldId) {
        return this.values.get(fieldId).asChar();
    }

    public byte[] getBytes(int fieldId) {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public byte[] getTextBytes(int fieldId) {
        return this.values.get(fieldId).asTextBytes();
    }

    public short getInt2(int fieldId) {
        return this.values.get(fieldId).asInt2();
    }

    public int getInt4(int fieldId) {
        return this.values.get(fieldId).asInt4();
    }

    public long getInt8(int fieldId) {
        return this.values.get(fieldId).asInt8();
    }

    public float getFloat4(int fieldId) {
        return this.values.get(fieldId).asFloat4();
    }

    public double getFloat8(int fieldId) {
        return this.values.get(fieldId).asFloat8();
    }

    public String getText(int fieldId) {
        return this.values.get(fieldId).asChars();
    }

    public TimeMeta getTimeDate(int fieldId) {
        return this.values.get(fieldId).asTimeMeta();
    }

    public ProtobufDatum getProtobufDatum(int fieldId) {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public IntervalDatum getInterval(int fieldId) {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public char[] getUnicodeChars(int fieldId) {
        return this.values.get(fieldId).asUnicodeChars();
    }

    public Tuple clone() throws CloneNotSupportedException {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }

    public Datum[] getValues() {
        throw new TajoRuntimeException((TajoException)new UnsupportedException());
    }
}

