/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.tajo.QueryId;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.TajoResultSetBase;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.HeapRowBlockReader;
import org.apache.tajo.tuple.memory.HeapTuple;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.ResizableMemoryBlock;
import org.apache.tajo.util.CompressionUtil;

public class TajoMemoryResultSet
extends TajoResultSetBase {
    private MemoryBlock memory;
    private RowBlockReader reader;
    private volatile boolean closed;

    public TajoMemoryResultSet(QueryId queryId, Schema schema, ClientProtos.SerializedResultSet resultSet, Map<String, String> clientSideSessionVars) {
        super(queryId, schema, clientSideSessionVars);
        if (resultSet != null && resultSet.getRows() > 0) {
            this.totalRow = resultSet.getRows();
            try {
                if (resultSet.hasDecompressCodec()) {
                    byte[] compressed = resultSet.getSerializedTuples().toByteArray();
                    byte[] uncompressed = CompressionUtil.decompress((TajoProtos.CodecType)resultSet.getDecompressCodec(), (byte[])compressed);
                    this.memory = new ResizableMemoryBlock(Unpooled.wrappedBuffer((byte[])uncompressed));
                } else {
                    this.memory = new ResizableMemoryBlock(resultSet.getSerializedTuples().asReadOnlyByteBuffer());
                }
            }
            catch (IOException e) {
                throw new TajoInternalError((Throwable)e);
            }
            this.reader = new HeapRowBlockReader(this.memory, SchemaUtil.toDataTypes((Schema)schema), resultSet.getRows());
        } else {
            this.totalRow = 0L;
            this.curRow = 0;
        }
    }

    @Override
    protected void init() {
        this.cur = null;
        this.curRow = 0;
        this.wasNull = false;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cur = null;
        this.curRow = -1;
        this.totalRow = 0L;
        this.reader = null;
        if (this.memory != null) {
            this.memory.release();
            this.memory = null;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.curRow = 0;
    }

    @Override
    protected Tuple nextTuple() throws IOException {
        if ((long)this.curRow < this.totalRow) {
            HeapTuple heapTuple = new HeapTuple();
            this.cur = this.reader.next((Tuple)heapTuple) ? heapTuple : null;
            return this.cur;
        }
        return null;
    }

    public boolean hasResult() {
        return this.totalRow > 0L;
    }
}

