/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.jdbc.MetaDataTuple;
import org.apache.tajo.jdbc.TajoResultSetBase;
import org.apache.tajo.storage.Tuple;

public class TajoMetaDataResultSet
extends TajoResultSetBase {
    private List<MetaDataTuple> values;

    public TajoMetaDataResultSet(Schema schema, List<MetaDataTuple> values) {
        super(null, schema, null);
        this.setDataTuples(values);
    }

    public TajoMetaDataResultSet(List<String> columns, List<TajoDataTypes.Type> types, List<MetaDataTuple> values) {
        super(null, new Schema(), null);
        int index = 0;
        if (columns != null) {
            for (String columnName : columns) {
                this.schema.addColumn(columnName, types.get(index++));
            }
        }
        this.setDataTuples(values);
    }

    protected void setDataTuples(List<MetaDataTuple> values) {
        this.values = values;
        this.totalRow = values == null ? 0L : (long)values.size();
    }

    @Override
    protected Tuple nextTuple() throws IOException {
        if ((long)this.curRow >= this.totalRow) {
            return null;
        }
        return this.values.get(this.curRow);
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public String getString(int fieldId) throws SQLException {
        return this.cur.getText(fieldId - 1);
    }

    @Override
    public String getString(String name) throws SQLException {
        return this.cur.getText(this.findColumn(name));
    }
}

