/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.tajo.QueryId;
import org.apache.tajo.SessionVars;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.jdbc.TajoResultSetMetaData;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public abstract class TajoResultSetBase
implements ResultSet {
    protected final Map<String, String> clientSideSessionVars;
    protected TimeZone timezone;
    protected int curRow;
    protected long totalRow;
    protected boolean wasNull;
    protected Schema schema;
    protected Tuple cur;
    protected final QueryId queryId;

    public TajoResultSetBase(QueryId queryId, Schema schema, @Nullable Map<String, String> clientSideSessionVars) {
        this.queryId = queryId;
        this.schema = schema;
        this.clientSideSessionVars = clientSideSessionVars;
        if (clientSideSessionVars != null) {
            if (clientSideSessionVars.containsKey(SessionVars.TIMEZONE.name())) {
                String timezoneId = clientSideSessionVars.get(SessionVars.TIMEZONE.name());
                this.timezone = TimeZone.getTimeZone(timezoneId);
            } else {
                this.timezone = TimeZone.getDefault();
            }
        }
    }

    protected void init() {
        this.cur = null;
        this.curRow = 0;
        this.totalRow = 0L;
        this.wasNull = false;
    }

    private boolean handleNull(Tuple tuple, int index) {
        this.wasNull = tuple.isBlankOrNull(index);
        return this.wasNull;
    }

    protected Schema getSchema() throws SQLException {
        return this.schema;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Tuple getCurrentTuple() {
        return this.cur;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.init();
    }

    @Override
    public boolean getBoolean(int fieldId) throws SQLException {
        return this.getBoolean(this.cur, fieldId - 1);
    }

    @Override
    public boolean getBoolean(String colName) throws SQLException {
        return this.getBoolean(this.cur, this.findColumn(colName));
    }

    private boolean getBoolean(Tuple tuple, int index) {
        return this.handleNull(tuple, index) ? false : tuple.asDatum(index).asBool();
    }

    @Override
    public byte getByte(int fieldId) throws SQLException {
        return this.getByte(this.cur, fieldId - 1);
    }

    @Override
    public byte getByte(String name) throws SQLException {
        return this.getByte(this.cur, this.findColumn(name));
    }

    private byte getByte(Tuple tuple, int index) {
        return this.handleNull(tuple, index) ? (byte)0 : tuple.asDatum(index).asByte();
    }

    @Override
    public byte[] getBytes(int fieldId) throws SQLException {
        return this.getBytes(this.cur, fieldId - 1);
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        return this.getBytes(this.cur, this.findColumn(name));
    }

    private byte[] getBytes(Tuple tuple, int index) {
        return this.handleNull(tuple, index) ? null : tuple.asDatum(index).asByteArray();
    }

    @Override
    public double getDouble(int fieldId) throws SQLException {
        return this.getDouble(this.cur, fieldId - 1);
    }

    @Override
    public double getDouble(String name) throws SQLException {
        return this.getDouble(this.cur, this.findColumn(name));
    }

    private double getDouble(Tuple tuple, int index) {
        return this.handleNull(tuple, index) ? 0.0 : tuple.asDatum(index).asFloat8();
    }

    @Override
    public float getFloat(int fieldId) throws SQLException {
        return this.getFloat(this.cur, fieldId - 1);
    }

    @Override
    public float getFloat(String name) throws SQLException {
        return this.getFloat(this.cur, this.findColumn(name));
    }

    private float getFloat(Tuple tuple, int index) throws SQLException {
        return this.handleNull(tuple, index) ? 0.0f : tuple.asDatum(index).asFloat4();
    }

    @Override
    public int getInt(int fieldId) throws SQLException {
        return this.getInt(this.cur, fieldId - 1);
    }

    @Override
    public int getInt(String name) throws SQLException {
        return this.getInt(this.cur, this.findColumn(name));
    }

    private int getInt(Tuple tuple, int index) throws SQLException {
        return this.handleNull(tuple, index) ? 0 : tuple.asDatum(index).asInt4();
    }

    @Override
    public long getLong(int fieldId) throws SQLException {
        return this.getLong(this.cur, fieldId - 1);
    }

    @Override
    public long getLong(String name) throws SQLException {
        return this.getLong(this.cur, this.findColumn(name));
    }

    private long getLong(Tuple tuple, int index) throws SQLException {
        return this.handleNull(tuple, index) ? 0L : tuple.asDatum(index).asInt8();
    }

    @Override
    public Object getObject(int fieldId) throws SQLException {
        return this.getObject(this.cur, fieldId - 1);
    }

    @Override
    public Object getObject(String name) throws SQLException {
        return this.getObject(this.cur, this.findColumn(name));
    }

    private Object getObject(Tuple tuple, int index) {
        if (this.handleNull(tuple, index)) {
            return null;
        }
        TajoDataTypes.Type dataType = this.schema.getColumn(index).getDataType().getType();
        switch (dataType) {
            case BOOLEAN: {
                return tuple.getBool(index);
            }
            case INT1: 
            case INT2: {
                return tuple.getInt2(index);
            }
            case INT4: {
                return tuple.getInt4(index);
            }
            case INT8: {
                return tuple.getInt8(index);
            }
            case TEXT: 
            case CHAR: 
            case VARCHAR: {
                return tuple.getText(index);
            }
            case FLOAT4: {
                return Float.valueOf(tuple.getFloat4(index));
            }
            case FLOAT8: {
                return tuple.getFloat8(index);
            }
            case NUMERIC: {
                return tuple.getFloat8(index);
            }
            case DATE: {
                return this.toDate(tuple.getTimeDate(index), this.timezone);
            }
            case TIME: {
                return this.toTime(tuple.getTimeDate(index), this.timezone);
            }
            case TIMESTAMP: {
                return this.toTimestamp(tuple.getTimeDate(index), this.timezone);
            }
        }
        return tuple.asDatum(index).asChars();
    }

    @Override
    public short getShort(int fieldId) throws SQLException {
        return this.getShort(this.cur, fieldId - 1);
    }

    @Override
    public short getShort(String name) throws SQLException {
        return this.getShort(this.cur, this.findColumn(name));
    }

    private short getShort(Tuple tuple, int index) throws SQLException {
        return this.handleNull(tuple, index) ? (short)0 : tuple.asDatum(index).asInt2();
    }

    @Override
    public String getString(int fieldId) throws SQLException {
        return this.getString(this.cur, fieldId - 1);
    }

    @Override
    public String getString(String name) throws SQLException {
        return this.getString(this.cur, this.findColumn(name));
    }

    private String getString(Tuple tuple, int index) throws SQLException {
        if (this.handleNull(tuple, index)) {
            return null;
        }
        switch (tuple.type(index)) {
            case BOOLEAN: {
                return String.valueOf(tuple.getBool(index));
            }
            case TIME: {
                return TimeDatum.asChars((TimeMeta)tuple.getTimeDate(index), (TimeZone)this.timezone, (boolean)false);
            }
            case TIMESTAMP: {
                return TimestampDatum.asChars((TimeMeta)tuple.getTimeDate(index), (TimeZone)this.timezone, (boolean)false);
            }
        }
        return tuple.asDatum(index).asChars();
    }

    @Override
    public Date getDate(int fieldId) throws SQLException {
        return this.getDate(this.cur, null, fieldId - 1);
    }

    @Override
    public Date getDate(String name) throws SQLException {
        return this.getDate(this.cur, null, this.findColumn(name));
    }

    @Override
    public Date getDate(int fieldId, Calendar x) throws SQLException {
        return this.getDate(this.cur, x.getTimeZone(), fieldId - 1);
    }

    @Override
    public Date getDate(String name, Calendar x) throws SQLException {
        return this.getDate(this.cur, x.getTimeZone(), this.findColumn(name));
    }

    private Date getDate(Tuple tuple, TimeZone tz, int index) throws SQLException {
        return this.handleNull(tuple, index) ? null : this.toDate(tuple.asDatum(index).asTimeMeta(), tz);
    }

    private Date toDate(TimeMeta tm, TimeZone tz) {
        if (tz != null) {
            DateTimeUtil.toUserTimezone((TimeMeta)tm, (TimeZone)tz);
        }
        return new Date(DateTimeUtil.julianTimeToJavaTime((long)DateTimeUtil.toJulianTimestamp((TimeMeta)tm)));
    }

    @Override
    public Time getTime(int fieldId) throws SQLException {
        return this.getTime(this.cur, null, fieldId - 1);
    }

    @Override
    public Time getTime(String name) throws SQLException {
        return this.getTime(this.cur, null, this.findColumn(name));
    }

    @Override
    public Time getTime(int fieldId, Calendar x) throws SQLException {
        return this.getTime(this.cur, x.getTimeZone(), fieldId - 1);
    }

    @Override
    public Time getTime(String name, Calendar x) throws SQLException {
        return this.getTime(this.cur, x.getTimeZone(), this.findColumn(name));
    }

    private Time getTime(Tuple tuple, TimeZone tz, int index) throws SQLException {
        return this.handleNull(tuple, index) ? null : this.toTime(tuple.asDatum(index).asTimeMeta(), tz);
    }

    private Time toTime(TimeMeta tm, TimeZone tz) {
        if (tz != null) {
            DateTimeUtil.toUserTimezone((TimeMeta)tm, (TimeZone)tz);
        }
        return new Time(DateTimeUtil.toJavaTime((int)tm.hours, (int)tm.minutes, (int)tm.secs, (int)tm.fsecs));
    }

    @Override
    public Timestamp getTimestamp(int fieldId) throws SQLException {
        return this.getTimestamp(this.cur, null, fieldId - 1);
    }

    @Override
    public Timestamp getTimestamp(String name) throws SQLException {
        return this.getTimestamp(this.cur, null, this.findColumn(name));
    }

    @Override
    public Timestamp getTimestamp(int fieldId, Calendar x) throws SQLException {
        return this.getTimestamp(this.cur, x.getTimeZone(), fieldId - 1);
    }

    @Override
    public Timestamp getTimestamp(String name, Calendar x) throws SQLException {
        return this.getTimestamp(this.cur, x.getTimeZone(), this.findColumn(name));
    }

    private Timestamp getTimestamp(Tuple tuple, TimeZone tz, int index) throws SQLException {
        return this.handleNull(tuple, index) ? null : this.toTimestamp(tuple.asDatum(index).asTimeMeta(), tz);
    }

    private Timestamp toTimestamp(TimeMeta tm, TimeZone tz) {
        if (tz != null) {
            DateTimeUtil.toUserTimezone((TimeMeta)tm, (TimeZone)tz);
        }
        return new Timestamp(DateTimeUtil.julianTimeToJavaTime((long)DateTimeUtil.toJulianTimestamp((TimeMeta)tm)));
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("isWrapperFor not supported");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("unwrap not supported");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("absolute not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        while (this.next()) {
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("clearWarnings not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("deleteRow not supported");
    }

    @Override
    public int findColumn(String colName) throws SQLException {
        return this.getSchema().getColumnIdByName(colName);
    }

    @Override
    public boolean first() throws SQLException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public Array getArray(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public Array getArray(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public InputStream getAsciiStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream not supported");
    }

    @Override
    public InputStream getAsciiStream(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int index, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String name, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal not supported");
    }

    @Override
    public InputStream getBinaryStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream not supported");
    }

    @Override
    public InputStream getBinaryStream(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream not supported");
    }

    @Override
    public Blob getBlob(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBlob not supported");
    }

    @Override
    public Blob getBlob(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBlob not supported");
    }

    @Override
    public Reader getCharacterStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream not supported");
    }

    @Override
    public Reader getCharacterStream(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream not supported");
    }

    @Override
    public Clob getClob(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob not supported");
    }

    @Override
    public Clob getClob(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob not supported");
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("getCursorName not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("getFetchSize not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TajoResultSetMetaData(this.getSchema());
    }

    @Override
    public Reader getNCharacterStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream not supported");
    }

    @Override
    public Reader getNCharacterStream(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream not supported");
    }

    @Override
    public NClob getNClob(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob not supported");
    }

    @Override
    public NClob getNClob(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob not supported");
    }

    @Override
    public String getNString(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString not supported");
    }

    @Override
    public String getNString(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString not supported");
    }

    @Override
    public Object getObject(int index, Map<String, Class<?>> x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject not supported");
    }

    @Override
    public Object getObject(String name, Map<String, Class<?>> x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject not supported");
    }

    @Override
    public <T> T getObject(String name, Class<T> x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject not supported");
    }

    @Override
    public <T> T getObject(int index, Class<T> x) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject not supported");
    }

    @Override
    public Ref getRef(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef not supported");
    }

    @Override
    public Ref getRef(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef not supported");
    }

    @Override
    public int getRow() throws SQLException {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId not supported");
    }

    @Override
    public RowId getRowId(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId not supported");
    }

    @Override
    public SQLXML getSQLXML(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHistoryStatement not supported");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL not supported");
    }

    @Override
    public URL getURL(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL not supported");
    }

    @Override
    public InputStream getUnicodeStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream not supported");
    }

    @Override
    public InputStream getUnicodeStream(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("getWarnings not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("insertRow not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return (long)this.curRow > this.totalRow;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.curRow == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return (long)this.curRow == this.totalRow;
    }

    @Override
    public boolean last() throws SQLException {
        Tuple last = null;
        while (this.next()) {
            last = this.cur;
        }
        this.cur = last;
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToCurrentRow not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow not supported");
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this.totalRow <= 0L) {
                return false;
            }
            this.cur = this.nextTuple();
            ++this.curRow;
            if (this.cur != null) {
                return true;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return false;
    }

    protected abstract Tuple nextTuple() throws IOException;

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("previous not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("refreshRow not supported");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("relative not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowDeleted not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowInserted not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowUpdated not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("setFetchDirection not supported");
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        throw new SQLFeatureNotSupportedException("setFetchSize not supported");
    }

    @Override
    public void updateArray(int index, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray not supported");
    }

    @Override
    public void updateArray(String name, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray not supported");
    }

    @Override
    public void updateAsciiStream(int index, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateAsciiStream(String name, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateAsciiStream(int index, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateAsciiStream(String name, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateAsciiStream(int index, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateAsciiStream(String name, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream not supported");
    }

    @Override
    public void updateBigDecimal(int index, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal not supported");
    }

    @Override
    public void updateBigDecimal(String name, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal not supported");
    }

    @Override
    public void updateBinaryStream(int index, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBinaryStream(String name, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBinaryStream(int index, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBinaryStream(String name, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBinaryStream(int index, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBinaryStream(String name, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream not supported");
    }

    @Override
    public void updateBlob(int index, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBlob(String name, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBlob(int index, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBlob(String name, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBlob(int index, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBlob(String name, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob not supported");
    }

    @Override
    public void updateBoolean(int index, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean not supported");
    }

    @Override
    public void updateBoolean(String name, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean not supported");
    }

    @Override
    public void updateByte(int index, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte not supported");
    }

    @Override
    public void updateByte(String name, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte not supported");
    }

    @Override
    public void updateBytes(int index, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte not supported");
    }

    @Override
    public void updateBytes(String name, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte not supported");
    }

    @Override
    public void updateCharacterStream(int index, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateCharacterStream(String name, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateCharacterStream(int index, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateCharacterStream(String name, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateCharacterStream(int index, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateCharacterStream(String name, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream not supported");
    }

    @Override
    public void updateClob(int index, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateClob(String name, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateClob(int index, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateClob(String name, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateClob(int index, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateClob(String name, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob not supported");
    }

    @Override
    public void updateDate(int index, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate not supported");
    }

    @Override
    public void updateDate(String name, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate not supported");
    }

    @Override
    public void updateDouble(int index, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble not supported");
    }

    @Override
    public void updateDouble(String name, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble not supported");
    }

    @Override
    public void updateFloat(int index, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat not supported");
    }

    @Override
    public void updateFloat(String name, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat not supported");
    }

    @Override
    public void updateInt(int index, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt not supported");
    }

    @Override
    public void updateInt(String name, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt not supported");
    }

    @Override
    public void updateLong(int index, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong not supported");
    }

    @Override
    public void updateLong(String name, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong not supported");
    }

    @Override
    public void updateNCharacterStream(int index, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream not supported");
    }

    @Override
    public void updateNCharacterStream(String name, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream not supported");
    }

    @Override
    public void updateNCharacterStream(int index, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream not supported");
    }

    @Override
    public void updateNCharacterStream(String name, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream not supported");
    }

    @Override
    public void updateNClob(int index, NClob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNClob(String name, NClob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNClob(int index, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNClob(String name, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNClob(int index, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNClob(String name, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob not supported");
    }

    @Override
    public void updateNString(int arg0, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString not supported");
    }

    @Override
    public void updateNString(String name, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString not supported");
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull not supported");
    }

    @Override
    public void updateNull(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull not supported");
    }

    @Override
    public void updateObject(int index, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject not supported");
    }

    @Override
    public void updateObject(String name, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject not supported");
    }

    @Override
    public void updateObject(int index, Object x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject not supported");
    }

    @Override
    public void updateObject(String name, Object x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject not supported");
    }

    @Override
    public void updateRef(int index, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef not supported");
    }

    @Override
    public void updateRef(String name, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRow not supported");
    }

    @Override
    public void updateRowId(int index, RowId arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId not supported");
    }

    @Override
    public void updateRowId(String name, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId not supported");
    }

    @Override
    public void updateSQLXML(int index, SQLXML arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML not supported");
    }

    @Override
    public void updateSQLXML(String name, SQLXML x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML not supported");
    }

    @Override
    public void updateShort(int index, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort not supported");
    }

    @Override
    public void updateShort(String name, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort not supported");
    }

    @Override
    public void updateString(int index, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString not supported");
    }

    @Override
    public void updateString(String name, String arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString not supported");
    }

    @Override
    public void updateTime(int index, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime not supported");
    }

    @Override
    public void updateTime(String name, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime not supported");
    }

    @Override
    public void updateTimestamp(int index, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp not supported");
    }

    @Override
    public void updateTimestamp(String name, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

