/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.client.ResultSetUtil;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.common.type.TajoTypeUtil;

public class TajoResultSetMetaData
implements ResultSetMetaData {
    Schema schema;

    public TajoResultSetMetaData(Schema schema) {
        this.schema = schema;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("isWrapperFor not supported");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("unwrap not supported");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        Column c = this.schema.getColumn(column - 1);
        if (CatalogUtil.isFQColumnName((String)c.getQualifiedName())) {
            return CatalogUtil.splitFQTableName((String)c.getQualifier())[0];
        }
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.schema.getColumn(column - 1).getClass().getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.schema == null) {
            return 0;
        }
        return this.schema.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return ResultSetUtil.columnDisplaySize(this.getColumnType(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.schema.getColumn(column - 1).getQualifiedName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.schema.getColumn(column - 1).getSimpleName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        TajoDataTypes.DataType type = this.schema.getColumn(column - 1).getDataType();
        return ResultSetUtil.tajoTypeToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        TajoDataTypes.DataType type = this.schema.getColumn(column - 1).getDataType();
        return ResultSetUtil.toSqlType(type);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return ResultSetUtil.columnDisplaySize(this.getColumnType(column));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return ResultSetUtil.columnScale(this.getColumnType(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.schema.getColumn(column - 1).getQualifier();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        TajoDataTypes.DataType type = this.schema.getColumn(column - 1).getDataType();
        return TajoTypeUtil.isSigned((TajoDataTypes.Type)type.getType());
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }
}

