/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.sql.SQLException;
import org.apache.tajo.QueryId;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.QueryStatus;
import org.apache.tajo.client.TajoClientUtil;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.SQLExceptionUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.FetchResultSet;

public class WaitingResultSet
extends FetchResultSet {
    public WaitingResultSet(QueryClient tajoClient, QueryId queryId, int fetchRowNum) throws SQLException {
        super(tajoClient, null, queryId, fetchRowNum);
    }

    @Override
    public boolean next() throws SQLException {
        this.getSchema();
        return super.next();
    }

    @Override
    protected Schema getSchema() throws SQLException {
        return this.schema == null ? (this.schema = this.waitOnResult()) : this.schema;
    }

    private Schema waitOnResult() throws SQLException {
        try {
            QueryStatus status = TajoClientUtil.waitCompletion(this.tajoClient, this.queryId);
            if (status.getState() != TajoProtos.QueryState.QUERY_SUCCEEDED) {
                throw new SQLException(status.getErrorMessage(), SQLExceptionUtil.toSQLState((Errors.ResultCode)Errors.ResultCode.INTERNAL_ERROR), Errors.ResultCode.INTERNAL_ERROR.getNumber());
            }
            ClientProtos.GetQueryResultResponse response = this.tajoClient.getResultResponse(this.queryId);
            TableDesc tableDesc = CatalogUtil.newTableDesc((CatalogProtos.TableDescProto)response.getTableDesc());
            return tableDesc.getLogicalSchema();
        }
        catch (TajoException e) {
            throw SQLExceptionUtil.toSQLException((DefaultTajoException)e);
        }
    }
}

