/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.nio.ByteBuffer;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.exception.ValueTooLongForTypeCharactersException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.util.BitArray;

public class RowStoreUtil {
    public static int[] getTargetIds(Schema inSchema, Schema outSchema) {
        int[] targetIds = new int[outSchema.size()];
        int i = 0;
        for (Column target : outSchema.getRootColumns()) {
            targetIds[i] = inSchema.getColumnId(target.getQualifiedName());
            ++i;
        }
        return targetIds;
    }

    public static Tuple project(Tuple in, Tuple out, int[] targetIds) {
        for (int idx = 0; idx < targetIds.length; ++idx) {
            out.put(idx, in.asDatum(targetIds[idx]));
        }
        return out;
    }

    public static RowStoreEncoder createEncoder(Schema schema) {
        return new RowStoreEncoder(schema);
    }

    public static RowStoreDecoder createDecoder(Schema schema) {
        return new RowStoreDecoder(schema);
    }

    public static class RowStoreEncoder {
        private Schema schema;
        private BitArray nullFlags;
        private int headerSize;

        private RowStoreEncoder(Schema schema) {
            this.schema = schema;
            this.nullFlags = new BitArray(schema.size());
            this.headerSize = this.nullFlags.bytesLength();
        }

        public byte[] toBytes(Tuple tuple) {
            this.nullFlags.clear();
            int size = this.estimateTupleDataSize(tuple);
            ByteBuffer bb = ByteBuffer.allocate(size + this.headerSize);
            bb.position(this.headerSize);
            block18: for (int i = 0; i < this.schema.size(); ++i) {
                if (tuple.isBlankOrNull(i)) {
                    this.nullFlags.set(i);
                    continue;
                }
                Column col = this.schema.getColumn(i);
                switch (col.getDataType().getType()) {
                    case NULL_TYPE: {
                        this.nullFlags.set(i);
                        continue block18;
                    }
                    case BOOLEAN: {
                        bb.put(tuple.getByte(i));
                        continue block18;
                    }
                    case BIT: {
                        bb.put(tuple.getByte(i));
                        continue block18;
                    }
                    case CHAR: {
                        int charSize = col.getDataType().getLength();
                        byte[] _char = new byte[charSize];
                        byte[] src = tuple.getBytes(i);
                        if (charSize < src.length) {
                            throw new ValueTooLongForTypeCharactersException(charSize);
                        }
                        System.arraycopy(src, 0, _char, 0, src.length);
                        bb.put(_char);
                        continue block18;
                    }
                    case INT2: {
                        bb.putShort(tuple.getInt2(i));
                        continue block18;
                    }
                    case INT4: {
                        bb.putInt(tuple.getInt4(i));
                        continue block18;
                    }
                    case INT8: {
                        bb.putLong(tuple.getInt8(i));
                        continue block18;
                    }
                    case FLOAT4: {
                        bb.putFloat(tuple.getFloat4(i));
                        continue block18;
                    }
                    case FLOAT8: {
                        bb.putDouble(tuple.getFloat8(i));
                        continue block18;
                    }
                    case TEXT: {
                        byte[] _string = tuple.getBytes(i);
                        bb.putInt(_string.length);
                        bb.put(_string);
                        continue block18;
                    }
                    case DATE: {
                        bb.putInt(tuple.getInt4(i));
                        continue block18;
                    }
                    case TIME: 
                    case TIMESTAMP: {
                        bb.putLong(tuple.getInt8(i));
                        continue block18;
                    }
                    case INTERVAL: {
                        IntervalDatum interval = (IntervalDatum)tuple.getInterval(i);
                        bb.putInt(interval.getMonths());
                        bb.putLong(interval.getMilliSeconds());
                        continue block18;
                    }
                    case BLOB: {
                        byte[] bytes = tuple.getBytes(i);
                        bb.putInt(bytes.length);
                        bb.put(bytes);
                        continue block18;
                    }
                    case INET4: {
                        byte[] ipBytes = tuple.getBytes(i);
                        bb.put(ipBytes);
                        continue block18;
                    }
                    case INET6: {
                        bb.put(tuple.getBytes(i));
                        continue block18;
                    }
                    default: {
                        throw new TajoRuntimeException((TajoException)new UnsupportedException("data type '" + col.getDataType().getType().name() + "'"));
                    }
                }
            }
            byte[] flags = this.nullFlags.toArray();
            int finalPosition = bb.position();
            bb.position(0);
            bb.put(flags);
            bb.position(finalPosition);
            bb.flip();
            byte[] buf = new byte[bb.limit()];
            bb.get(buf);
            return buf;
        }

        private int estimateTupleDataSize(Tuple tuple) {
            int size = 0;
            block10: for (int i = 0; i < this.schema.size(); ++i) {
                if (tuple.isBlankOrNull(i)) continue;
                Column col = this.schema.getColumn(i);
                switch (col.getDataType().getType()) {
                    case BOOLEAN: 
                    case BIT: {
                        ++size;
                        continue block10;
                    }
                    case CHAR: {
                        size += col.getDataType().getLength();
                        continue block10;
                    }
                    case INT2: {
                        size += 2;
                        continue block10;
                    }
                    case INT4: 
                    case DATE: 
                    case FLOAT4: {
                        size += 4;
                        continue block10;
                    }
                    case INT8: 
                    case TIME: 
                    case TIMESTAMP: 
                    case FLOAT8: {
                        size += 8;
                        continue block10;
                    }
                    case INTERVAL: {
                        size += 12;
                        continue block10;
                    }
                    case TEXT: 
                    case BLOB: {
                        size += 4 + tuple.getBytes(i).length;
                        continue block10;
                    }
                    case INET4: 
                    case INET6: {
                        size += tuple.getBytes(i).length;
                        continue block10;
                    }
                    default: {
                        throw new TajoRuntimeException((TajoException)new UnsupportedException("data type '" + col.getDataType().getType().name() + "'"));
                    }
                }
            }
            return size += 100;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }

    public static class RowStoreDecoder {
        private Schema schema;
        private BitArray nullFlags;
        private int headerSize;

        private RowStoreDecoder(Schema schema) {
            this.schema = schema;
            this.nullFlags = new BitArray(schema.size());
            this.headerSize = this.nullFlags.bytesLength();
        }

        public Tuple toTuple(byte[] bytes) {
            this.nullFlags.clear();
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            VTuple tuple = new VTuple(this.schema.size());
            bb.limit(this.headerSize);
            this.nullFlags.fromByteBuffer(bb);
            bb.limit(bytes.length);
            block14: for (int i = 0; i < this.schema.size(); ++i) {
                if (this.nullFlags.get(i)) {
                    tuple.put(i, (Datum)DatumFactory.createNullDatum());
                    continue;
                }
                Column col = this.schema.getColumn(i);
                TajoDataTypes.DataType type = col.getDataType();
                switch (type.getType()) {
                    case BOOLEAN: {
                        tuple.put(i, DatumFactory.createBool((byte)bb.get()));
                        continue block14;
                    }
                    case BIT: {
                        byte b = bb.get();
                        tuple.put(i, (Datum)DatumFactory.createBit((byte)b));
                        continue block14;
                    }
                    case CHAR: {
                        byte[] _str = new byte[type.getLength()];
                        bb.get(_str);
                        tuple.put(i, (Datum)DatumFactory.createChar((byte[])_str));
                        continue block14;
                    }
                    case INT2: {
                        short s = bb.getShort();
                        tuple.put(i, (Datum)DatumFactory.createInt2((short)s));
                        continue block14;
                    }
                    case INT4: 
                    case DATE: {
                        int i_ = bb.getInt();
                        tuple.put(i, DatumFactory.createFromInt4((TajoDataTypes.DataType)type, (int)i_));
                        continue block14;
                    }
                    case INT8: 
                    case TIME: 
                    case TIMESTAMP: {
                        long l = bb.getLong();
                        tuple.put(i, DatumFactory.createFromInt8((TajoDataTypes.DataType)type, (long)l));
                        continue block14;
                    }
                    case INTERVAL: {
                        int month = bb.getInt();
                        long milliseconds = bb.getLong();
                        tuple.put(i, (Datum)new IntervalDatum(month, milliseconds));
                        continue block14;
                    }
                    case FLOAT4: {
                        float f = bb.getFloat();
                        tuple.put(i, (Datum)DatumFactory.createFloat4((float)f));
                        continue block14;
                    }
                    case FLOAT8: {
                        double d = bb.getDouble();
                        tuple.put(i, (Datum)DatumFactory.createFloat8((double)d));
                        continue block14;
                    }
                    case TEXT: {
                        byte[] _string = new byte[bb.getInt()];
                        bb.get(_string);
                        tuple.put(i, (Datum)DatumFactory.createText((byte[])_string));
                        continue block14;
                    }
                    case BLOB: {
                        byte[] _bytes = new byte[bb.getInt()];
                        bb.get(_bytes);
                        tuple.put(i, (Datum)DatumFactory.createBlob((byte[])_bytes));
                        continue block14;
                    }
                    case INET4: {
                        byte[] _ipv4 = new byte[4];
                        bb.get(_ipv4);
                        tuple.put(i, (Datum)DatumFactory.createInet4((byte[])_ipv4));
                        continue block14;
                    }
                    default: {
                        throw new TajoRuntimeException((TajoException)new UnsupportedException("data type '" + col.getDataType().getType().name() + "'"));
                    }
                }
            }
            return tuple;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

