/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.validation.Validator;
import org.apache.tajo.validation.Validators;

public enum SessionVars implements ConfigKey
{
    SESSION_ID(TajoConf.ConfVars.$EMPTY, "session variable", VariableMode.SERVER_SIDE_VAR, String.class, Validators.notNull()),
    SESSION_LAST_ACCESS_TIME(TajoConf.ConfVars.$EMPTY, "last access time", VariableMode.SERVER_SIDE_VAR, Long.class, Validators.min("0")),
    USERNAME(TajoConf.ConfVars.USERNAME, "username", VariableMode.SERVER_SIDE_VAR),
    CLIENT_HOST(TajoConf.ConfVars.$EMPTY, "client hostname", VariableMode.SERVER_SIDE_VAR),
    CURRENT_DATABASE(TajoConf.ConfVars.$EMPTY, "current database", VariableMode.SERVER_SIDE_VAR),
    SESSION_EXPIRY_TIME(TajoConf.ConfVars.$CLIENT_SESSION_EXPIRY_TIME, "session expiry time (secs)", VariableMode.DEFAULT, Integer.class, Validators.min("0")),
    CLI_COLUMNS(TajoConf.ConfVars.$CLI_MAX_COLUMN, "Sets the width for the wrapped format", VariableMode.CLI_SIDE_VAR),
    CLI_FORMATTER_CLASS(TajoConf.ConfVars.$CLI_OUTPUT_FORMATTER_CLASS, "Sets the output format class to display results", VariableMode.CLI_SIDE_VAR),
    CLI_NULL_CHAR(TajoConf.ConfVars.$CLI_NULL_CHAR, "Sets the string to be printed in place of a null value.", VariableMode.CLI_SIDE_VAR),
    CLI_PAGE_ROWS(TajoConf.ConfVars.$CLI_PRINT_PAUSE_NUM_RECORDS, "Sets the number of rows for paging", VariableMode.CLI_SIDE_VAR),
    CLI_PAGING_ENABLED(TajoConf.ConfVars.$CLI_PRINT_PAUSE, "Enable paging of result display", VariableMode.CLI_SIDE_VAR),
    CLI_DISPLAY_ERROR_TRACE(TajoConf.ConfVars.$CLI_PRINT_ERROR_TRACE, "Enable display of error trace", VariableMode.CLI_SIDE_VAR),
    ON_ERROR_STOP(TajoConf.ConfVars.$CLI_ERROR_STOP, "tsql will exit if an error occurs.", VariableMode.CLI_SIDE_VAR),
    TIMEZONE(TajoConf.ConfVars.$TIMEZONE, "Sets timezone", VariableMode.DEFAULT),
    DATE_ORDER(TajoConf.ConfVars.$DATE_ORDER, "date order (default is YMD)", VariableMode.CLI_SIDE_VAR),
    LANG(TajoConf.ConfVars.$EMPTY, "Language", VariableMode.FROM_SHELL_ENV),
    LC_ALL(TajoConf.ConfVars.$EMPTY, "String sort order", VariableMode.FROM_SHELL_ENV),
    LC_COLLATE(TajoConf.ConfVars.$EMPTY, "String sort order", VariableMode.FROM_SHELL_ENV),
    LC_CTYPE(TajoConf.ConfVars.$EMPTY, "Character classification (What is a letter? Its upper-case equivalent?)", VariableMode.FROM_SHELL_ENV),
    LC_MESSAGES(TajoConf.ConfVars.$EMPTY, "Language of messages", VariableMode.FROM_SHELL_ENV),
    LC_MONETARY(TajoConf.ConfVars.$EMPTY, "Formatting of currency amounts", VariableMode.FROM_SHELL_ENV),
    LC_NUMERIC(TajoConf.ConfVars.$EMPTY, "Formatting of numbers", VariableMode.FROM_SHELL_ENV),
    LC_TIME(TajoConf.ConfVars.$EMPTY, "Formatting of dates and times", VariableMode.FROM_SHELL_ENV),
    USE_TABLE_VOLUME(TajoConf.ConfVars.$USE_TABLE_VOLUME, "Enable optimizer to get and use the table volume via storage handlers", VariableMode.DEFAULT, Boolean.class, Validators.bool()),
    BROADCAST_NON_CROSS_JOIN_THRESHOLD(TajoConf.ConfVars.$DIST_QUERY_BROADCAST_NON_CROSS_JOIN_THRESHOLD, "restriction for the total size of broadcasted table for non-cross join (kb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    BROADCAST_CROSS_JOIN_THRESHOLD(TajoConf.ConfVars.$DIST_QUERY_BROADCAST_CROSS_JOIN_THRESHOLD, "restriction for the total size of broadcasted table for cross join (kb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    JOIN_TASK_INPUT_SIZE(TajoConf.ConfVars.$DIST_QUERY_JOIN_TASK_VOLUME, "join task input size (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    SORT_TASK_INPUT_SIZE(TajoConf.ConfVars.$DIST_QUERY_SORT_TASK_VOLUME, "sort task input size (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    GROUPBY_TASK_INPUT_SIZE(TajoConf.ConfVars.$DIST_QUERY_GROUPBY_TASK_VOLUME, "group by task input size (mb)", VariableMode.DEFAULT),
    JOIN_PER_SHUFFLE_SIZE(TajoConf.ConfVars.$DIST_QUERY_JOIN_PARTITION_VOLUME, "shuffle output size for join (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    GROUPBY_PER_SHUFFLE_SIZE(TajoConf.ConfVars.$DIST_QUERY_GROUPBY_PARTITION_VOLUME, "shuffle output size for sort (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    TABLE_PARTITION_PER_SHUFFLE_SIZE(TajoConf.ConfVars.$DIST_QUERY_TABLE_PARTITION_VOLUME, "shuffle output size for partition table write (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    GROUPBY_MULTI_LEVEL_ENABLED(TajoConf.ConfVars.$GROUPBY_MULTI_LEVEL_ENABLED, "Multiple level groupby enabled", VariableMode.DEFAULT, Boolean.class, Validators.bool()),
    QUERY_EXECUTE_PARALLEL(TajoConf.ConfVars.$QUERY_EXECUTE_PARALLEL_MAX, "Maximum parallel running of execution blocks for a query", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    EXTSORT_BUFFER_SIZE(TajoConf.ConfVars.$EXECUTOR_EXTERNAL_SORT_BUFFER_SIZE, "sort buffer size for external sort (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("0")),
    HASH_SHUFFLE_BUFFER_SIZE(TajoConf.ConfVars.$EXECUTOR_HASH_SHUFFLE_BUFFER_SIZE, "hash-shuffle buffer size for local disk I/O (mb)", VariableMode.DEFAULT, Integer.class, Validators.min("1")),
    HASH_JOIN_SIZE_LIMIT(TajoConf.ConfVars.$EXECUTOR_HASH_JOIN_SIZE_THRESHOLD, "limited size for hash join (mb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    INNER_HASH_JOIN_SIZE_LIMIT(TajoConf.ConfVars.$EXECUTOR_INNER_HASH_JOIN_SIZE_THRESHOLD, "limited size for hash inner join (mb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    OUTER_HASH_JOIN_SIZE_LIMIT(TajoConf.ConfVars.$EXECUTOR_OUTER_HASH_JOIN_SIZE_THRESHOLD, "limited size for hash outer join (mb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    HASH_GROUPBY_SIZE_LIMIT(TajoConf.ConfVars.$EXECUTOR_GROUPBY_INMEMORY_HASH_THRESHOLD, "limited size for hash groupby (mb)", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    MAX_OUTPUT_FILE_SIZE(TajoConf.ConfVars.$MAX_OUTPUT_FILE_SIZE, "Maximum per-output file size (mb). 0 means infinite.", VariableMode.DEFAULT, Long.class, Validators.min("0")),
    NULL_CHAR(TajoConf.ConfVars.$TEXT_NULL, "Null char of text file output. This value is used when the table property 'text.null' is not specified.", VariableMode.DEFAULT),
    CODEGEN(TajoConf.ConfVars.$CODEGEN, "Runtime code generation enabled (experiment)", VariableMode.DEFAULT),
    AGG_HASH_TABLE_SIZE(TajoConf.ConfVars.$AGG_HASH_TABLE_SIZE, "The initial size of list for in-memory aggregation", VariableMode.DEFAULT),
    SORT_LIST_SIZE(TajoConf.ConfVars.$SORT_LIST_SIZE, "The initial size of list for in-memory sort", VariableMode.DEFAULT),
    JOIN_HASH_TABLE_SIZE(TajoConf.ConfVars.$JOIN_HASH_TABLE_SIZE, "The initial size of hash table for in-memory hash join", VariableMode.DEFAULT),
    INDEX_ENABLED(TajoConf.ConfVars.$INDEX_ENABLED, "index scan enabled", VariableMode.DEFAULT),
    INDEX_SELECTIVITY_THRESHOLD(TajoConf.ConfVars.$INDEX_SELECTIVITY_THRESHOLD, "the selectivity threshold for index scan", VariableMode.DEFAULT),
    PARTITION_NO_RESULT_OVERWRITE_ENABLED(TajoConf.ConfVars.$PARTITION_NO_RESULT_OVERWRITE_ENABLED, "If true, a partitioned table is overwritten even if a sub query leads to no result. Otherwise, the table data will be kept if there is no result", VariableMode.DEFAULT),
    ARITHABORT(TajoConf.ConfVars.$BEHAVIOR_ARITHMETIC_ABORT, "If true, a running query will be terminated when an overflow or divide-by-zero occurs.", VariableMode.DEFAULT),
    FETCH_ROWNUM(TajoConf.ConfVars.$RESULT_SET_FETCH_ROWNUM, "The number of rows to be fetched from Master at a time", VariableMode.DEFAULT, Integer.class, Validators.min("0")),
    BLOCK_ON_RESULT(TajoConf.ConfVars.$RESULT_SET_BLOCK_WAIT, "Whether to block result set on query execution", VariableMode.DEFAULT, Boolean.class, Validators.bool()),
    COMPRESSED_RESULT_TRANSFER(TajoConf.ConfVars.$COMPRESSED_RESULT_TRANSFER, "Use compression to optimize result transmission.", VariableMode.CLI_SIDE_VAR, Boolean.class, Validators.bool()),
    DEBUG_ENABLED(TajoConf.ConfVars.$DEBUG_ENABLED, "(debug only) debug mode enabled", VariableMode.DEFAULT),
    TEST_BROADCAST_JOIN_ENABLED(TajoConf.ConfVars.$TEST_BROADCAST_JOIN_ENABLED, "(test only) broadcast enabled", VariableMode.TEST_VAR),
    TEST_JOIN_OPT_ENABLED(TajoConf.ConfVars.$TEST_JOIN_OPT_ENABLED, "(test only) join optimization enabled", VariableMode.TEST_VAR),
    TEST_FILTER_PUSHDOWN_ENABLED(TajoConf.ConfVars.$TEST_FILTER_PUSHDOWN_ENABLED, "filter push down enabled", VariableMode.TEST_VAR),
    TEST_MIN_TASK_NUM(TajoConf.ConfVars.$TEST_MIN_TASK_NUM, "(test only) min task num", VariableMode.TEST_VAR),
    TEST_PLAN_SHAPE_FIX_ENABLED(TajoConf.ConfVars.$TEST_PLAN_SHAPE_FIX_ENABLED, "(test only) plan shape fix enabled", VariableMode.TEST_VAR);

    public static final Map<String, SessionVars> SESSION_VARS;
    public static final Map<String, SessionVars> DEPRECATED_SESSION_VARS;
    private final TajoConf.ConfVars key;
    private final String description;
    private final VariableMode mode;
    private Class<?> valClass;
    private Validator validator;

    private SessionVars(TajoConf.ConfVars key, String description, VariableMode mode) {
        this.key = key;
        this.description = description;
        this.mode = mode;
    }

    private SessionVars(TajoConf.ConfVars key, String description, VariableMode mode, Class<?> valueClass, Validator validator) {
        this(key, description, mode);
        this.valClass = valueClass;
        this.validator = validator;
    }

    @Override
    public String keyname() {
        return this.name();
    }

    @Override
    public ConfigKey.ConfigType type() {
        return ConfigKey.ConfigType.SESSION;
    }

    public TajoConf.ConfVars getConfVars() {
        return this.key;
    }

    public Class<?> getVarType() {
        return this.key.valClass;
    }

    public String getDescription() {
        return this.description;
    }

    public VariableMode getMode() {
        return this.mode;
    }

    public static boolean exists(String keyname) {
        return SESSION_VARS.containsKey(keyname) || DEPRECATED_SESSION_VARS.containsKey(keyname);
    }

    public static boolean isDeprecated(String keyname) {
        return DEPRECATED_SESSION_VARS.containsKey(keyname);
    }

    public static boolean isPublic(SessionVars var) {
        return var.getMode() != VariableMode.SERVER_SIDE_VAR;
    }

    public static SessionVars get(String keyname) {
        if (SESSION_VARS.containsKey(keyname)) {
            return SESSION_VARS.get(keyname);
        }
        if (DEPRECATED_SESSION_VARS.containsKey(keyname)) {
            return DEPRECATED_SESSION_VARS.get(keyname);
        }
        return null;
    }

    public static String handleDeprecatedName(String keyname) {
        return SessionVars.exists(keyname) ? SessionVars.get(keyname).keyname() : keyname;
    }

    @Override
    public Class<?> valueClass() {
        return this.valClass;
    }

    @Override
    public Validator validator() {
        return this.validator;
    }

    static {
        SESSION_VARS = Maps.newHashMap();
        DEPRECATED_SESSION_VARS = Maps.newHashMap();
        for (SessionVars var : SessionVars.values()) {
            SESSION_VARS.put(var.keyname(), var);
            DEPRECATED_SESSION_VARS.put(var.getConfVars().keyname(), var);
        }
    }

    public static enum VariableMode {
        DEFAULT,
        FROM_SHELL_ENV,
        SERVER_SIDE_VAR,
        CLI_SIDE_VAR,
        TEST_VAR;

    }
}

