/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.auth;

import java.lang.reflect.Method;
import org.apache.tajo.util.PlatformUtil;

public class UserRoleInfo {
    private final String username;

    public UserRoleInfo(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public String toString() {
        return "user=" + this.username;
    }

    public static synchronized UserRoleInfo getCurrentUser() {
        String userName;
        Object o = null;
        Method method = null;
        PlatformUtil.OsType osType = PlatformUtil.getOsType();
        try {
            switch (osType) {
                case WINDOWS: {
                    Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
                    o = Class.forName("com.sun.security.auth.module.NTSystem").newInstance();
                    method = c.getDeclaredMethod("getName", new Class[0]);
                    break;
                }
                case LINUX_OR_UNIX: 
                case MAC: {
                    Class<?> c = Class.forName("com.sun.security.auth.module.UnixSystem");
                    o = Class.forName("com.sun.security.auth.module.UnixSystem").newInstance();
                    method = c.getDeclaredMethod("getUsername", new Class[0]);
                    break;
                }
                case SOLARIS: {
                    Class<?> c = Class.forName("com.sun.security.auth.module.SolarisSystem");
                    o = Class.forName("com.sun.security.auth.module.SolarisSystem").newInstance();
                    method = c.getDeclaredMethod("getUsername", new Class[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Operating System: " + PlatformUtil.getOsName());
                }
            }
            userName = (String)method.invoke(o, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return new UserRoleInfo(userName);
    }
}

