/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.common.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.io.Writable;
import org.apache.tajo.exception.InvalidAddressException;

public class IPv4
implements Writable,
Comparable<IPv4> {
    private byte[] ipBytes = new byte[4];

    public static IPv4 getSubnetMask(int len) {
        byte[] bytes = new byte[4];
        int index = 0;
        while (len > 7) {
            len -= 8;
            bytes[index++] = -1;
        }
        bytes[index] = (byte)(255 >> 8 - len << 8 - len);
        return new IPv4(bytes);
    }

    public IPv4() {
    }

    public IPv4(byte[] bytes) {
        this.set(bytes);
    }

    public IPv4(String ipAddress) throws InvalidAddressException {
        this.set(ipAddress);
    }

    public void set(String ipAddress) throws InvalidAddressException {
        StringTokenizer tokenizer = new StringTokenizer(ipAddress);
        for (int i = 0; i < 4; ++i) {
            String token = tokenizer.nextToken(".");
            if (token == null) {
                throw new InvalidAddressException();
            }
            if (Integer.parseInt(token) < 0 || Integer.parseInt(token) > 255) {
                throw new InvalidAddressException();
            }
            this.ipBytes[i] = (byte)(Integer.parseInt(token) << 24 >> 24 & 0xFF);
        }
    }

    public void set(byte[] bytes) {
        if (this.ipBytes == null) {
            this.ipBytes = new byte[4];
        }
        System.arraycopy(bytes, 0, this.ipBytes, 0, 4);
    }

    public byte[] getBytes() {
        return this.ipBytes;
    }

    public boolean matchSubnet(String addr) throws InvalidAddressException {
        int maskIndex = addr.indexOf(47);
        if (maskIndex != -1) {
            IPv4 other = new IPv4(addr.substring(0, maskIndex));
            int maskLen = Integer.parseInt(addr.substring(maskIndex + 1));
            IPv4 subnetMask = IPv4.getSubnetMask(maskLen);
            return this.and(subnetMask).equals(other.and(subnetMask));
        }
        throw new InvalidAddressException();
    }

    public boolean matchGeoIP() {
        return false;
    }

    public IPv4 and(IPv4 other) {
        byte[] res = new byte[4];
        byte[] obytes = other.getBytes();
        for (int i = 0; i < 4; ++i) {
            res[i] = (byte)(this.ipBytes[i] & obytes[i]);
        }
        return new IPv4(res);
    }

    public boolean equals(Object o) {
        if (o instanceof IPv4) {
            byte[] obytes = ((IPv4)o).getBytes();
            for (int i = 0; i < 4; ++i) {
                if (this.ipBytes[i] == obytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IPv4 o) {
        byte[] obytes = o.getBytes();
        for (int i = 0; i < 4; ++i) {
            if (this.ipBytes[i] > obytes[i]) {
                return 1;
            }
            if (this.ipBytes[i] >= obytes[i]) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 3; ++i) {
            sb.append(this.ipBytes[i] << 24 >> 24 & 0xFF).append(".");
        }
        sb.append(this.ipBytes[i] << 24 >> 24 & 0xFF);
        return sb.toString();
    }

    public int hashCode() {
        return 0;
    }

    public void readFields(DataInput in) throws IOException {
        in.readFully(this.ipBytes, 0, 4);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.ipBytes, 0, 4);
    }
}

