/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.gson.annotations.Expose;
import org.apache.tajo.SessionVars;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.json.CommonGsonHelper;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.util.datetime.TimeMeta;

public abstract class Datum
implements Comparable<Datum>,
GsonObject {
    static boolean abortWhenDivideByZero;
    @Expose
    private final TajoDataTypes.Type type;

    public Datum(TajoDataTypes.Type type) {
        this.type = type;
    }

    public TajoDataTypes.Type type() {
        return this.type;
    }

    public boolean isTrue() {
        return this.type == TajoDataTypes.Type.BOOLEAN && this.asBool();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNotNull() {
        return true;
    }

    public boolean asBool() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.BOOLEAN));
    }

    public byte asByte() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.BIT));
    }

    public char asChar() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.CHAR));
    }

    public short asInt2() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.INT2));
    }

    public int asInt4() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.INT4));
    }

    public long asInt8() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.INT8));
    }

    public byte[] asByteArray() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.BLOB));
    }

    public float asFloat4() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.FLOAT4));
    }

    public double asFloat8() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.FLOAT8));
    }

    public String asChars() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.TEXT));
    }

    public char[] asUnicodeChars() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.TEXT));
    }

    public byte[] asTextBytes() {
        return this.asChars().getBytes(TextDatum.DEFAULT_CHARSET);
    }

    public TimeMeta asTimeMeta() {
        throw new TajoRuntimeException(new InvalidValueForCastException(this.type, TajoDataTypes.Type.INT8));
    }

    public boolean isNumeric() {
        return this.isNumber() || this.isReal();
    }

    public boolean isNumber() {
        return this.type == TajoDataTypes.Type.INT2 || this.type == TajoDataTypes.Type.INT4 || this.type == TajoDataTypes.Type.INT8;
    }

    public boolean isReal() {
        return this.type == TajoDataTypes.Type.FLOAT4 || this.type == TajoDataTypes.Type.FLOAT8;
    }

    protected static void initAbortWhenDivideByZero(TajoConf tajoConf) {
        abortWhenDivideByZero = tajoConf.getBoolVar(TajoConf.ConfVars.$BEHAVIOR_ARITHMETIC_ABORT);
    }

    public abstract int size();

    public Datum and(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum or(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum plus(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum minus(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum multiply(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum divide(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum modular(Datum datum) {
        throw new InvalidOperationException(datum.type);
    }

    public Datum equalsTo(Datum datum) {
        if (this instanceof NullDatum || datum instanceof NullDatum) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) == 0);
    }

    public Datum notEqualsTo(Datum datum) {
        if (this instanceof NullDatum || datum instanceof NullDatum) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) != 0);
    }

    public Datum lessThan(Datum datum) {
        if (this.type() == TajoDataTypes.Type.NULL_TYPE || datum.type() == TajoDataTypes.Type.NULL_TYPE) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) < 0);
    }

    public Datum lessThanEqual(Datum datum) {
        if (this.type() == TajoDataTypes.Type.NULL_TYPE || datum.type() == TajoDataTypes.Type.NULL_TYPE) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) <= 0);
    }

    public Datum greaterThan(Datum datum) {
        if (this.type() == TajoDataTypes.Type.NULL_TYPE || datum.type() == TajoDataTypes.Type.NULL_TYPE) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) > 0);
    }

    public Datum greaterThanEqual(Datum datum) {
        if (this.type() == TajoDataTypes.Type.NULL_TYPE || datum.type() == TajoDataTypes.Type.NULL_TYPE) {
            return NullDatum.get();
        }
        return DatumFactory.createBool(this.compareTo(datum) >= 0);
    }

    @Override
    public abstract int compareTo(Datum var1);

    @Override
    public String toJson() {
        return CommonGsonHelper.toJson(this, Datum.class);
    }

    public String toString() {
        return this.asChars();
    }

    protected boolean validateDivideZero(short value) {
        if (value == 0) {
            if (abortWhenDivideByZero) {
                throw new ArithmeticException("/ by zero");
            }
            return false;
        }
        return true;
    }

    protected boolean validateDivideZero(int value) {
        if (value == 0) {
            if (abortWhenDivideByZero) {
                throw new ArithmeticException("/ by zero");
            }
            return false;
        }
        return true;
    }

    protected boolean validateDivideZero(long value) {
        if (value == 0L) {
            if (abortWhenDivideByZero) {
                throw new ArithmeticException("/ by zero");
            }
            return false;
        }
        return true;
    }

    protected boolean validateDivideZero(float value) {
        if (value == 0.0f) {
            if (abortWhenDivideByZero) {
                throw new ArithmeticException("/ by zero");
            }
            return false;
        }
        return true;
    }

    protected boolean validateDivideZero(double value) {
        if (value == 0.0) {
            if (abortWhenDivideByZero) {
                throw new ArithmeticException("/ by zero");
            }
            return false;
        }
        return true;
    }

    static {
        try {
            Datum.initAbortWhenDivideByZero(new TajoConf());
        }
        catch (NoClassDefFoundError error) {
            abortWhenDivideByZero = Boolean.valueOf(System.getProperty(SessionVars.ARITHABORT.getConfVars().keyname(), SessionVars.ARITHABORT.getConfVars().defaultVal));
        }
    }
}

