/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.annotations.Expose;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.util.Bytes;

public class Inet4Datum
extends Datum {
    private static final int size = 4;
    @Expose
    private final int address;

    Inet4Datum(int encoded) {
        super(TajoDataTypes.Type.INET4);
        this.address = encoded;
    }

    public Inet4Datum(String addr) {
        super(TajoDataTypes.Type.INET4);
        String[] elems = addr.split("\\.");
        this.address = Integer.parseInt(elems[3]) & 0xFF | Integer.parseInt(elems[2]) << 8 & 0xFF00 | Integer.parseInt(elems[1]) << 16 & 0xFF0000 | Integer.parseInt(elems[0]) << 24 & 0xFF000000;
    }

    public Inet4Datum(byte[] addr) {
        super(TajoDataTypes.Type.INET4);
        Preconditions.checkArgument((addr.length == 4 ? 1 : 0) != 0);
        this.address = addr[3] & 0xFF | addr[2] << 8 & 0xFF00 | addr[1] << 16 & 0xFF0000 | addr[0] << 24 & 0xFF000000;
    }

    public Inet4Datum(byte[] addr, int offset, int length) {
        super(TajoDataTypes.Type.INET4);
        Preconditions.checkArgument((length == 4 ? 1 : 0) != 0);
        this.address = addr[offset + 3] & 0xFF | addr[offset + 2] << 8 & 0xFF00 | addr[offset + 1] << 16 & 0xFF0000 | addr[offset] << 24 & 0xFF000000;
    }

    @Override
    public int asInt4() {
        return this.address;
    }

    @Override
    public long asInt8() {
        return UnsignedInteger.asUnsigned((int)this.address).longValue();
    }

    @Override
    public byte[] asByteArray() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return addr;
    }

    @Override
    public String asChars() {
        return Inet4Datum.numericToTextFormat(this.asByteArray());
    }

    @Override
    public int size() {
        return 4;
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Inet4Datum) {
            Inet4Datum other = (Inet4Datum)obj;
            return this.address == other.address;
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case INET4: {
                return DatumFactory.createBool(this.address == ((Inet4Datum)datum).address);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case INET4: {
                byte[] bytes = this.asByteArray();
                byte[] other = datum.asByteArray();
                return Bytes.compareTo(bytes, 0, 4, other, 0, 4);
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    static String numericToTextFormat(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }
}

