/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.util.Pair;
import org.apache.tajo.util.StringUtils;

public class ErrorMessages {
    public static final Map<Errors.ResultCode, Pair<String, Integer>> MESSAGES = Maps.newHashMap();

    private static void ADD_MESSAGE(Errors.ResultCode code, String msgFormat) {
        ErrorMessages.ADD_MESSAGE(code, msgFormat, 0);
    }

    private static void ADD_MESSAGE(Errors.ResultCode code, String msgFormat, int argNum) {
        MESSAGES.put(code, new Pair<String, Integer>(msgFormat, argNum));
    }

    public static String getInternalErrorMessage() {
        return MESSAGES.get((Object)Errors.ResultCode.INTERNAL_ERROR).getFirst();
    }

    public static String getInternalErrorMessage(Throwable t) {
        if (t != null) {
            String message = t.getMessage();
            if (StringUtils.isEmpty(message)) {
                message = ExceptionUtils.getMessage((Throwable)t);
            }
            return String.format(MESSAGES.get((Object)Errors.ResultCode.INTERNAL_ERROR).getFirst(), message);
        }
        return ErrorMessages.getInternalErrorMessage();
    }

    public static String concat(String[] args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : args) {
            if (!first) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getMessage(Errors.ResultCode code, String ... args) {
        if (!MESSAGES.containsKey((Object)code)) {
            throw new TajoInternalError("no error message for " + (Object)((Object)code));
        }
        Pair<String, Integer> messageFormat = MESSAGES.get((Object)code);
        if (messageFormat.getSecond() == args.length) {
            if (args.length == 0) {
                return MESSAGES.get((Object)code).getFirst();
            }
            return String.format(MESSAGES.get((Object)code).getFirst(), args);
        }
        throw new TajoInternalError("Error message arguments are invalid: code=" + code.name() + ", args=" + ErrorMessages.concat(args) + ". Please report this bug to https://issues.apache.org/jira/browse/TAJO.");
    }

    static {
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INTERNAL_ERROR, "internal error: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.NOT_IMPLEMENTED, "not implemented feature: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.FEATURE_NOT_SUPPORTED, "unsupported feature: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_RPC_CALL, "invalid RPC Call: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.QUERY_FAILED, "query has been failed due to %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.QUERY_KILLED, "query has been killed");
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.QUERY_NOT_FOUND, "query %s does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.NO_DATA, "no data for %s due to query failure or error", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INCOMPLETE_QUERY, "query %s is stilling running", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_SESSION, "invalid Session '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.NO_SUCH_SESSION_VARIABLE, "no such session variable '%s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_SESSION_VARIABLE, "invalid session variable '%s': %s", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.SYNTAX_ERROR, "%s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INSUFFICIENT_PRIVILEGE, "Insufficient privilege to %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CANNOT_DROP_CURRENT_DATABASE, "Cannot drop the current database", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_TABLESPACE, "tablespace '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_DATABASE, "database '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_SCHEMA, "schema '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_TABLE, "relation '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_COLUMN, "column '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_FUNCTION, "function does not exist: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_PARTITION_METHOD, "table '%s' is not a partitioned table", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_PARTITION, "partition '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_PARTITION_KEY, "'%s' column is not a partition key", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_OPERATOR, "operator does not exist: '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_INDEX_FOR_TABLE, "index ''%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_INDEX_FOR_COLUMNS, "index does not exist for '%s' columns of '%s' table", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_INDEX_NAME, "index name '%s' does not exist", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNDEFINED_TABLESPACE_HANDLER, "No tablespace handler for URI scheme '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_TABLESPACE, "tablespace '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_DATABASE, "database '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_SCHEMA, "schema '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_TABLE, "table '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_COLUMN, "column '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_ALIAS, "table name '%s' specified more than once", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_INDEX, "index '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DUPLICATE_PARTITION, "partition for '%s' already exists", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.AMBIGUOUS_TABLE, "table name '%s' is ambiguous", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.AMBIGUOUS_COLUMN, "column name '%s' is ambiguous", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.AMBIGUOUS_FUNCTION, "function '%s' is ambiguous", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_NAME, "Invalid name '%s'");
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_VALUE_FOR_CAST, "%s value cannot be casted to %s", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DIVISION_BY_ZERO, "Division by zero: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.DATATYPE_MISMATCH, "column '%s' is of type %s but expression %s is of type %s", 4);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.SET_OPERATION_SCHEMA_MISMATCH, "each %s query must have the same number of columns", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.SET_OPERATION_DATATYPE_MISMATCH, "%s types %s and %s cannot be matched");
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CAT_UPGRADE_REQUIRED, "catalog must be upgraded");
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CAT_CANNOT_CONNECT, "cannot connect metadata store '%s': %s", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CAT_UNSUPPORTED_CATALOG_STORE, "unsupported catalog store: %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.LMD_NO_MATCHED_DATATYPE, "no matched type for %s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNAVAILABLE_TABLE_LOCATION, "unavailable table location '%s', cause: %s", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNKNOWN_DATAFORMAT, "unknown data format: '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.UNSUPPORTED_DATATYPE, "unsupported data type: '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_TABLE_PROPERTY, "invalid table property '%s': '%s'", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.MISSING_TABLE_PROPERTY, "table property '%s' required for '%s'", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.AMBIGUOUS_PARTITION_DIRECTORY, "There is a directory which is assumed to be a partitioned directory : '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.TOO_LARGE_INPUT_FOR_CROSS_JOIN, "Cross join of large tables is not allowed: (%s). To execute cross join, please increase BROADCAST_CROSS_JOIN_THRESHOLD which is currently set to %s.", 2);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.INVALID_INPUTS_FOR_CROSS_JOIN, "At least one of both inputs for the cross join must be a simple relation.");
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CLIENT_CONNECTION_EXCEPTION, "%s", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CLIENT_UNABLE_TO_ESTABLISH_CONNECTION, "Client is unable to establish connection to '%s'", 1);
        ErrorMessages.ADD_MESSAGE(Errors.ResultCode.CLIENT_CONNECTION_DOES_NOT_EXIST, "This connection has been closed.");
    }
}

