/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tajo.error.Errors;
import org.apache.tajo.error.Stacktrace;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.ErrorMessages;
import org.apache.tajo.exception.ExceptionUtil;

public class ErrorUtil {
    public static boolean isOk(Errors.ResultCode code) {
        return code == Errors.ResultCode.OK;
    }

    public static boolean isFailed(Errors.ResultCode code) {
        return code != Errors.ResultCode.OK;
    }

    public static Stacktrace.StackTrace convertStacktrace(Throwable t) {
        Stacktrace.StackTrace.Builder builder = Stacktrace.StackTrace.newBuilder();
        for (StackTraceElement element : t.getStackTrace()) {
            builder.addElement(Stacktrace.StackTrace.Element.newBuilder().setFilename(element.getFileName() == null ? "(Unknown Source)" : element.getFileName()).setFunction(element.getClassName() + "::" + element.getMethodName()).setLine(element.getLineNumber()));
        }
        return builder.build();
    }

    public static Errors.SerializedException convertException(Throwable t) {
        Errors.SerializedException.Builder builder = Errors.SerializedException.newBuilder();
        if (ExceptionUtil.isExceptionWithResultCode(t)) {
            DefaultTajoException tajoException = (DefaultTajoException)((Object)t);
            builder.setReturnCode(tajoException.getErrorCode());
            builder.setMessage(tajoException.getMessage());
        } else {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            if (rootCause != null) {
                t = rootCause;
            }
            builder.setReturnCode(Errors.ResultCode.INTERNAL_ERROR);
            builder.setMessage(ErrorMessages.getInternalErrorMessage(t));
        }
        builder.setStackTrace(ErrorUtil.convertStacktrace(t));
        builder.setTimestamp(System.currentTimeMillis());
        return builder.build();
    }
}

