/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Map;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.ErrorMessages;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class SQLExceptionUtil {
    private static final Map<Errors.ResultCode, String> SQLSTATES = Maps.newHashMap();

    public static boolean isThisError(SQLException e, Errors.ResultCode code) {
        if (SQLSTATES.containsKey((Object)code)) {
            return e.getSQLState().equals(SQLSTATES.get((Object)code));
        }
        throw new TajoInternalError("Unknown error code: " + code.name());
    }

    public static void throwIfError(PrimitiveProtos.ReturnState state) throws SQLException {
        if (ReturnStateUtil.isError(state)) {
            throw SQLExceptionUtil.toSQLException(state);
        }
    }

    private static SQLException toSQLException(Errors.ResultCode code, String message) throws SQLException {
        if (SQLSTATES.containsKey((Object)code)) {
            return new SQLException(message, SQLSTATES.get((Object)code), code.getNumber());
        }
        return new SQLException(message, "42000", 501);
    }

    public static String toSQLState(Errors.ResultCode code) {
        if (SQLSTATES.containsKey((Object)code)) {
            return SQLSTATES.get((Object)code);
        }
        return "42000";
    }

    public static SQLException toSQLException(DefaultTajoException e) throws SQLException {
        if (e instanceof TajoRuntimeException) {
            return SQLExceptionUtil.toSQLException(e.getErrorCode(), ((TajoRuntimeException)e).getCause().getMessage());
        }
        return SQLExceptionUtil.toSQLException(e.getErrorCode(), e.getMessage());
    }

    public static SQLException toSQLException(PrimitiveProtos.ReturnState state) throws SQLException {
        return SQLExceptionUtil.toSQLException(state.getReturnCode(), state.getMessage());
    }

    public static SQLException makeSQLException(Errors.ResultCode code, String ... args) {
        if (SQLSTATES.containsKey((Object)code)) {
            return new SQLException(ErrorMessages.getMessage(code, args), SQLSTATES.get((Object)code), code.getNumber());
        }
        return new SQLException(code.name(), "42000", code.getNumber());
    }

    public static SQLException makeUnableToEstablishConnection(Throwable t) {
        return SQLExceptionUtil.makeSQLException(Errors.ResultCode.CLIENT_UNABLE_TO_ESTABLISH_CONNECTION, t.getMessage());
    }

    static {
        SQLSTATES.put(Errors.ResultCode.INTERNAL_ERROR, "XX000");
        SQLSTATES.put(Errors.ResultCode.NOT_IMPLEMENTED, "0A000");
        SQLSTATES.put(Errors.ResultCode.FEATURE_NOT_SUPPORTED, "0A000");
        SQLSTATES.put(Errors.ResultCode.INVALID_RPC_CALL, "08P01");
        SQLSTATES.put(Errors.ResultCode.QUERY_FAILED, "61T01");
        SQLSTATES.put(Errors.ResultCode.QUERY_KILLED, "61T02");
        SQLSTATES.put(Errors.ResultCode.QUERY_TIMEOUT, "61T03");
        SQLSTATES.put(Errors.ResultCode.QUERY_NOT_FOUND, "61T04");
        SQLSTATES.put(Errors.ResultCode.NO_DATA, "61T05");
        SQLSTATES.put(Errors.ResultCode.INCOMPLETE_QUERY, "61T06");
        SQLSTATES.put(Errors.ResultCode.INVALID_SESSION, "62T01");
        SQLSTATES.put(Errors.ResultCode.NO_SUCH_SESSION_VARIABLE, "62T02");
        SQLSTATES.put(Errors.ResultCode.INVALID_SESSION_VARIABLE, "62T03");
        SQLSTATES.put(Errors.ResultCode.DIVISION_BY_ZERO, "22012");
        SQLSTATES.put(Errors.ResultCode.INVALID_VALUE_FOR_CAST, "22T01");
        SQLSTATES.put(Errors.ResultCode.SYNTAX_ERROR, "42601");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_DATABASE, "42T01");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_SCHEMA, "42T02");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_TABLE, "42P01");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_COLUMN, "42703");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_FUNCTION, "42883");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_INDEX_FOR_TABLE, "42T03");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_INDEX_FOR_COLUMNS, "42T04");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_PARTITION, "42T05");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_PARTITION_METHOD, "42T06");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_OPERATOR, "42883");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_PARTITION_KEY, "42T07");
        SQLSTATES.put(Errors.ResultCode.UNDEFINED_TABLESPACE_HANDLER, "42T11");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_TABLESPACE, "42T08");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_DATABASE, "42P04");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_SCHEMA, "42P06");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_TABLE, "42P07");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_COLUMN, "42701");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_ALIAS, "42712");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_FUNCTION, "42723");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_INDEX, "42710");
        SQLSTATES.put(Errors.ResultCode.DUPLICATE_PARTITION, "42T09");
        SQLSTATES.put(Errors.ResultCode.AMBIGUOUS_TABLE, "42723");
        SQLSTATES.put(Errors.ResultCode.AMBIGUOUS_COLUMN, "42723");
        SQLSTATES.put(Errors.ResultCode.AMBIGUOUS_FUNCTION, "42723");
        SQLSTATES.put(Errors.ResultCode.AMBIGUOUS_PARTITION_DIRECTORY, "42T10");
        SQLSTATES.put(Errors.ResultCode.CANNOT_CAST, "42846");
        SQLSTATES.put(Errors.ResultCode.GROUPING_ERROR, "42803");
        SQLSTATES.put(Errors.ResultCode.WINDOWING_ERROR, "42P20");
        SQLSTATES.put(Errors.ResultCode.INVALID_RECURSION, "42P19");
        SQLSTATES.put(Errors.ResultCode.SET_OPERATION_SCHEMA_MISMATCH, "42601");
        SQLSTATES.put(Errors.ResultCode.SET_OPERATION_DATATYPE_MISMATCH, "42601");
        SQLSTATES.put(Errors.ResultCode.INVALID_FOREIGN_KEY, "42830");
        SQLSTATES.put(Errors.ResultCode.INVALID_NAME, "42602");
        SQLSTATES.put(Errors.ResultCode.INVALID_COLUMN_DEFINITION, "42611");
        SQLSTATES.put(Errors.ResultCode.NAME_TOO_LONG, "42622");
        SQLSTATES.put(Errors.ResultCode.RESERVED_NAME, "42939");
        SQLSTATES.put(Errors.ResultCode.DATATYPE_MISMATCH, "42804");
        SQLSTATES.put(Errors.ResultCode.INDETERMINATE_DATATYPE, "42P18");
        SQLSTATES.put(Errors.ResultCode.CLIENT_CONNECTION_EXCEPTION, "08000");
        SQLSTATES.put(Errors.ResultCode.CLIENT_CONNECTION_DOES_NOT_EXIST, "08003");
        SQLSTATES.put(Errors.ResultCode.CLIENT_UNABLE_TO_ESTABLISH_CONNECTION, "08006");
    }
}

