/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.util.Arrays;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.datetime.TimeMeta;

public class NullTuple
implements Tuple,
Cloneable {
    private static final byte[] NULL_TEXT_BYTES = new byte[0];
    private final int size;

    public static Tuple create(int size) {
        return new NullTuple(size);
    }

    NullTuple(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(int fieldId) {
        return fieldId < this.size;
    }

    @Override
    public boolean isBlank(int fieldid) {
        return false;
    }

    @Override
    public boolean isBlankOrNull(int fieldid) {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public void put(int fieldId, Datum value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datum asDatum(int fieldId) {
        return NullDatum.get();
    }

    @Override
    public TajoDataTypes.Type type(int fieldId) {
        return null;
    }

    @Override
    public int size(int fieldId) {
        return 0;
    }

    @Override
    public void clearOffset() {
    }

    @Override
    public void put(int fieldId, Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(Datum[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOffset(long offset) {
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public boolean getBool(int fieldId) {
        return NullDatum.get().asBool();
    }

    @Override
    public byte getByte(int fieldId) {
        return NullDatum.get().asByte();
    }

    @Override
    public char getChar(int fieldId) {
        return NullDatum.get().asChar();
    }

    @Override
    public byte[] getBytes(int fieldId) {
        return NullDatum.get().asByteArray();
    }

    @Override
    public byte[] getTextBytes(int fieldId) {
        return NULL_TEXT_BYTES;
    }

    @Override
    public short getInt2(int fieldId) {
        return NullDatum.get().asInt2();
    }

    @Override
    public int getInt4(int fieldId) {
        return NullDatum.get().asInt4();
    }

    @Override
    public long getInt8(int fieldId) {
        return NullDatum.get().asInt8();
    }

    @Override
    public float getFloat4(int fieldId) {
        return NullDatum.get().asFloat4();
    }

    @Override
    public double getFloat8(int fieldId) {
        return NullDatum.get().asFloat8();
    }

    @Override
    public String getText(int fieldId) {
        return NullDatum.get().asChars();
    }

    @Override
    public TimeMeta getTimeDate(int fieldId) {
        return null;
    }

    @Override
    public ProtobufDatum getProtobufDatum(int fieldId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datum getInterval(int fieldId) {
        return NullDatum.get();
    }

    @Override
    public char[] getUnicodeChars(int fieldId) {
        return NullDatum.get().asUnicodeChars();
    }

    @Override
    public Tuple clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    public Datum[] getValues() {
        Object[] datum = new Datum[this.size];
        Arrays.fill(datum, NullDatum.get());
        return datum;
    }
}

