/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import io.netty.util.internal.PlatformDependent;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.exception.ValueOutOfRangeException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.memory.OffHeapRowBlockUtils;
import org.apache.tajo.tuple.memory.RowBlock;
import org.apache.tajo.tuple.memory.RowWriter;
import org.apache.tajo.util.BitArray;
import org.apache.tajo.util.UnsafeUtil;

public class CompactRowBlockWriter
implements RowWriter {
    private static final int RECORD_FIELD_SIZE = 4;
    private static final short MAXIMUM_VARIANT_INT32 = 5;
    private static final short MAXIMUM_VARIANT_INT64 = 10;
    private final RowBlock rowBlock;
    private final BitArray nullFlags;
    private final int headerSize;
    private final TajoDataTypes.DataType[] dataTypes;
    private int curFieldIdx;
    private int curOffset;

    public CompactRowBlockWriter(RowBlock rowBlock) {
        this.dataTypes = rowBlock.getDataTypes();
        this.rowBlock = rowBlock;
        this.nullFlags = new BitArray(this.dataTypes.length);
        this.headerSize = 6 + this.nullFlags.bytesLength();
        if (!rowBlock.getMemory().hasAddress()) {
            throw new TajoInternalError(rowBlock.getMemory().getClass().getSimpleName() + " does not support to direct memory access");
        }
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static short writeRawVarint32(long address, int value) {
        short length = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                PlatformDependent.putByte((long)(address + (long)length), (byte)((byte)value));
                length = (short)(length + 1);
                return length;
            }
            PlatformDependent.putByte((long)(address + (long)length), (byte)((byte)(value & 0x7F | 0x80)));
            value >>>= 7;
            length = (short)(length + 1);
        }
    }

    public static short writeRawVarint64(long address, long value) {
        short length = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                PlatformDependent.putByte((long)(address + (long)length), (byte)((byte)value));
                length = (short)(length + 1);
                return length;
            }
            PlatformDependent.putByte((long)(address + (long)length), (byte)((byte)(value & 0x7FL | 0x80L)));
            value >>>= 7;
            length = (short)(length + 1);
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public long address() {
        return this.rowBlock.getMemory().address();
    }

    public int position() {
        return this.rowBlock.getMemory().writerPosition();
    }

    public void forward(int length) {
        this.rowBlock.getMemory().writerPosition(this.rowBlock.getMemory().writerPosition() + length);
    }

    public void backward(int length) {
        this.rowBlock.getMemory().writerPosition(this.rowBlock.getMemory().writerPosition() - length);
    }

    public void ensureSize(int size) {
        this.rowBlock.getMemory().ensureSize(size);
    }

    @Override
    public TajoDataTypes.DataType[] dataTypes() {
        return this.rowBlock.getDataTypes();
    }

    public long recordStartAddr() {
        return this.currentAddr() - (long)this.curOffset;
    }

    private long currentAddr() {
        return this.address() + (long)this.position();
    }

    public int offset() {
        return this.position();
    }

    @Override
    public void clear() {
        this.curOffset = 0;
        this.curFieldIdx = 0;
        this.nullFlags.clear();
    }

    @Override
    public boolean startRow() {
        this.ensureSize(this.headerSize);
        this.nullFlags.clear();
        this.curOffset = this.headerSize;
        this.curFieldIdx = 0;
        this.forward(this.headerSize);
        return true;
    }

    @Override
    public void endRow() {
        long rowHeaderPos = this.recordStartAddr();
        PlatformDependent.putInt((long)rowHeaderPos, (int)this.curOffset);
        byte[] flags = this.nullFlags.toArray();
        PlatformDependent.putShort((long)(rowHeaderPos += 4L), (short)((short)flags.length));
        PlatformDependent.copyMemory((byte[])flags, (int)0, (long)(rowHeaderPos += 2L), (long)flags.length);
        this.rowBlock.setRows(this.rowBlock.rows() + 1);
    }

    @Override
    public void cancelRow() {
        this.backward(this.curOffset);
        this.curOffset = 0;
        this.nullFlags.clear();
        this.curFieldIdx = 0;
    }

    @Override
    public void skipField() {
        this.nullFlags.set(this.curFieldIdx);
        ++this.curFieldIdx;
    }

    private void forwardField(int fieldLength) {
        this.forward(fieldLength);
        this.curOffset += fieldLength;
    }

    @Override
    public void putByte(byte val) {
        this.ensureSize(1);
        long addr = this.currentAddr();
        PlatformDependent.putByte((long)addr, (byte)val);
        ++this.curFieldIdx;
        this.forwardField(1);
    }

    @Override
    public void putBool(boolean val) {
        this.putByte(val ? (byte)1 : 2);
    }

    @Override
    public void putInt2(short val) {
        this.ensureSize(2);
        long addr = this.currentAddr();
        PlatformDependent.putShort((long)addr, (short)val);
        ++this.curFieldIdx;
        this.forwardField(2);
    }

    @Override
    public void putInt4(int val) {
        this.ensureSize(5);
        ++this.curFieldIdx;
        this.forwardField(CompactRowBlockWriter.writeRawVarint32(this.currentAddr(), CompactRowBlockWriter.encodeZigZag32(val)));
    }

    @Override
    public void putInt8(long val) {
        this.ensureSize(10);
        ++this.curFieldIdx;
        this.forwardField(CompactRowBlockWriter.writeRawVarint64(this.currentAddr(), CompactRowBlockWriter.encodeZigZag64(val)));
    }

    @Override
    public void putFloat4(float val) {
        this.ensureSize(4);
        long addr = this.currentAddr();
        UnsafeUtil.unsafe.putFloat(addr, val);
        ++this.curFieldIdx;
        this.forwardField(4);
    }

    @Override
    public void putFloat8(double val) {
        this.ensureSize(8);
        long addr = this.currentAddr();
        UnsafeUtil.unsafe.putDouble(addr, val);
        ++this.curFieldIdx;
        this.forwardField(8);
    }

    @Override
    public void putText(String val) {
        this.putText(val.getBytes(TextDatum.DEFAULT_CHARSET));
    }

    @Override
    public void putText(byte[] val) {
        this.putBlob(val);
    }

    @Override
    public void putBlob(byte[] val) {
        int bytesLen = val.length;
        this.ensureSize(5 + bytesLen);
        long addr = this.currentAddr();
        short length = CompactRowBlockWriter.writeRawVarint32(addr, bytesLen);
        PlatformDependent.copyMemory((byte[])val, (int)0, (long)(addr + (long)length), (long)bytesLen);
        ++this.curFieldIdx;
        this.forwardField(length + bytesLen);
    }

    @Override
    public void putDate(int val) {
        this.ensureSize(4);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)val);
        ++this.curFieldIdx;
        this.forwardField(4);
    }

    @Override
    public void putTime(long val) {
        this.ensureSize(8);
        long addr = this.currentAddr();
        PlatformDependent.putLong((long)addr, (long)val);
        ++this.curFieldIdx;
        this.forwardField(8);
    }

    @Override
    public void putTimestamp(long val) {
        this.putTime(val);
    }

    @Override
    public void putInterval(IntervalDatum val) {
        this.ensureSize(15);
        long addr = this.currentAddr();
        short length = CompactRowBlockWriter.writeRawVarint32(addr, CompactRowBlockWriter.encodeZigZag32(val.getMonths()));
        length = (short)(length + CompactRowBlockWriter.writeRawVarint64(addr, CompactRowBlockWriter.encodeZigZag64(val.getMilliSeconds())));
        ++this.curFieldIdx;
        this.forwardField(length);
    }

    @Override
    public void putInet4(int val) {
        this.ensureSize(4);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)val);
        ++this.curFieldIdx;
        this.forwardField(4);
    }

    @Override
    public void putProtoDatum(ProtobufDatum val) {
        this.putBlob(val.asByteArray());
    }

    @Override
    public boolean addTuple(Tuple tuple) {
        try {
            OffHeapRowBlockUtils.convert(tuple, this);
        }
        catch (ValueOutOfRangeException e) {
            return false;
        }
        return true;
    }
}

