/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.exception.ValueOutOfRangeException;
import org.apache.tajo.storage.BufferPool;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.ResizableLimitSpec;
import org.apache.tajo.util.FileUtil;
import org.apache.tajo.util.UnsafeUtil;

public class ResizableMemoryBlock
implements MemoryBlock {
    private static final Log LOG = LogFactory.getLog(ResizableMemoryBlock.class);
    protected ByteBuf buffer;
    protected ResizableLimitSpec limitSpec;
    private long memoryAddress;

    public ResizableMemoryBlock(ByteBuf buffer, ResizableLimitSpec limitSpec) {
        this.buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.limitSpec = limitSpec;
        this.memoryAddress = this.buffer.hasMemoryAddress() ? this.buffer.memoryAddress() : 0L;
    }

    public ResizableMemoryBlock(ByteBuf buffer) {
        this(buffer, new ResizableLimitSpec(buffer.capacity()));
    }

    public ResizableMemoryBlock(ByteBuffer buffer) {
        this(Unpooled.wrappedBuffer((ByteBuffer)buffer), new ResizableLimitSpec(buffer.capacity(), buffer.capacity()));
    }

    public ResizableMemoryBlock(ResizableLimitSpec limitSpec, boolean isDirect) {
        if (isDirect) {
            this.buffer = BufferPool.directBuffer((int)limitSpec.initialSize(), (int)limitSpec.limit());
            this.memoryAddress = this.buffer.memoryAddress();
        } else {
            this.buffer = BufferPool.heapBuffer((int)limitSpec.initialSize(), (int)limitSpec.limit());
        }
        this.limitSpec = limitSpec;
    }

    @Override
    public long address() {
        return this.memoryAddress;
    }

    @Override
    public boolean hasAddress() {
        return this.buffer.hasMemoryAddress();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public boolean isReadable() {
        return this.buffer.isReadable();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public int readerPosition() {
        return this.buffer.readerIndex();
    }

    @Override
    public void readerPosition(int pos) {
        this.buffer.readerIndex(pos);
    }

    @Override
    public boolean isWritable() {
        return this.buffer.isWritable();
    }

    @Override
    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    @Override
    public void writerPosition(int pos) {
        this.buffer.writerIndex(pos);
    }

    @Override
    public int writerPosition() {
        return this.buffer.writerIndex();
    }

    @Override
    public void ensureSize(int size) {
        if (!this.buffer.isWritable(size)) {
            int newBlockSize = this.limitSpec.increasedSize(size);
            if (!this.limitSpec.canIncrease(this.buffer.writableBytes() + newBlockSize)) {
                throw new ValueOutOfRangeException("Cannot increase RowBlock anymore.");
            }
            this.resize(newBlockSize);
            LOG.info((Object)("Increase DirectRowBlock to " + FileUtil.humanReadableByteCount(newBlockSize, false)));
        }
    }

    private void resize(int newSize) {
        Preconditions.checkArgument((newSize > 0 ? 1 : 0) != 0, (Object)"Size must be greater than 0 bytes");
        if ((long)newSize > this.limitSpec.limit()) {
            throw new ValueOutOfRangeException("Resize cannot exceed the capacity limit");
        }
        if (newSize < this.buffer.writableBytes()) {
            LOG.warn((Object)"The capacity reduction is ignored.");
        }
        int newBlockSize = UnsafeUtil.alignedSize(newSize);
        this.buffer = BufferPool.ensureWritable(this.buffer, newBlockSize);
        this.memoryAddress = this.buffer.memoryAddress();
    }

    @Override
    public void release() {
        if (this.buffer.refCnt() > 0) {
            this.buffer.release();
        }
    }

    @Override
    public MemoryBlock duplicate() {
        return new ResizableMemoryBlock(this.buffer.duplicate().readerIndex(0), this.limitSpec);
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public int writeBytes(ScatteringByteChannel channel) throws IOException {
        int localReadBytes;
        if (this.buffer.readableBytes() > 0) {
            this.buffer.markReaderIndex();
            this.buffer.discardReadBytes();
        } else {
            this.buffer.clear();
        }
        int readBytes = 0;
        while (this.buffer.writableBytes() > 0 && (localReadBytes = this.buffer.writeBytes(channel, this.buffer.writableBytes())) >= 0) {
            readBytes += localReadBytes;
        }
        return readBytes;
    }

    @Override
    public int getBytes(byte[] bytes, int dstIndex, int length) throws IOException {
        int readableBytes = this.buffer.readableBytes();
        this.buffer.readBytes(bytes, dstIndex, length);
        return readableBytes - this.buffer.readableBytes();
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public int writeTo(GatheringByteChannel channel, int length) throws IOException {
        return this.buffer.readBytes(channel, length);
    }

    @Override
    public int writeTo(GatheringByteChannel channel) throws IOException {
        return this.buffer.readBytes(channel, this.buffer.readableBytes());
    }

    @Override
    public int writeTo(OutputStream outputStream, int length) throws IOException {
        this.buffer.readBytes(outputStream, length);
        return length;
    }

    @Override
    public int writeTo(OutputStream outputStream) throws IOException {
        int readableBytes = this.buffer.readableBytes();
        this.buffer.readBytes(outputStream, readableBytes);
        return readableBytes - this.buffer.readableBytes();
    }

    public String toString() {
        return "memory=" + FileUtil.humanReadableByteCount(this.capacity(), false) + "," + this.limitSpec;
    }
}

