/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.memory.FixedSizeLimitSpec;
import org.apache.tajo.tuple.memory.MemoryRowBlock;
import org.apache.tajo.tuple.memory.UnSafeTuple;

public class UnSafeTupleList
extends ArrayList<UnSafeTuple> {
    private final TajoDataTypes.DataType[] dataTypes;
    private List<MemoryRowBlock> rowBlocks;
    private MemoryRowBlock currentRowBlock;
    private int totalUsedMem;
    private int pageSize;

    public UnSafeTupleList(TajoDataTypes.DataType[] dataTypes, int initialArraySize) {
        this(dataTypes, initialArraySize, 0x100000);
    }

    public UnSafeTupleList(TajoDataTypes.DataType[] dataTypes, int initialArraySize, int pageSize) {
        super(initialArraySize);
        this.dataTypes = dataTypes;
        this.pageSize = pageSize;
        this.rowBlocks = Lists.newArrayList();
        this.currentRowBlock = new MemoryRowBlock(dataTypes, new FixedSizeLimitSpec(pageSize), true);
        this.rowBlocks.add(this.currentRowBlock);
    }

    @Override
    public boolean add(UnSafeTuple tuple) {
        return this.addTuple(tuple);
    }

    public boolean addTuple(Tuple tuple) {
        int prevPos = this.currentRowBlock.getMemory().writerPosition();
        if (this.currentRowBlock.getWriter().addTuple(tuple)) {
            UnSafeTuple unSafeTuple = new UnSafeTuple();
            unSafeTuple.set(this.currentRowBlock.getMemory(), prevPos, this.dataTypes);
            return super.add(unSafeTuple);
        }
        this.totalUsedMem += this.currentRowBlock.usedMem();
        this.currentRowBlock = new MemoryRowBlock(this.dataTypes, new FixedSizeLimitSpec(this.pageSize), true);
        this.rowBlocks.add(this.currentRowBlock);
        return this.addTuple(tuple);
    }

    public void release() {
        for (MemoryRowBlock rowBlock : this.rowBlocks) {
            rowBlock.release();
        }
        super.clear();
        this.rowBlocks.clear();
        this.totalUsedMem = 0;
    }

    public int usedMem() {
        return this.totalUsedMem + this.currentRowBlock.usedMem();
    }

    @Override
    public void clear() {
        this.release();
        this.currentRowBlock = new MemoryRowBlock(this.dataTypes, new FixedSizeLimitSpec(this.pageSize), true);
        this.rowBlocks.add(this.currentRowBlock);
    }
}

