/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class BitArray {
    private byte[] data;
    private int length;

    public BitArray(int numBits) {
        this.data = new byte[(int)Math.ceil((double)numBits / 8.0)];
        this.length = numBits;
    }

    public BitArray(byte[] bytes) {
        this.data = bytes;
        this.length = bytes.length * 8;
    }

    public void set(int idx) {
        if (idx >= this.length) {
            throw new IllegalArgumentException("length is " + this.length + ", but a given index is " + idx + ".");
        }
        int offset = idx % 8;
        int dummy = 1;
        dummy = (byte)(dummy << 7 - offset);
        int n = idx / 8;
        this.data[n] = (byte)(this.data[n] | dummy);
    }

    public boolean get(int idx) {
        if (idx >= this.length) {
            throw new IllegalArgumentException("length is " + this.length + ", but a given index is " + idx + ".");
        }
        int offset = idx % 8;
        return (this.data[idx / 8] >>> 7 - offset & 1) == 1;
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
    }

    public int bytesLength() {
        return this.data.length;
    }

    public int bitsLength() {
        return this.length;
    }

    public byte[] toArray() {
        return this.data;
    }

    public void fromByteBuffer(ByteBuffer byteBuffer) {
        this.clear();
        for (int i = 0; i < this.data.length && byteBuffer.hasRemaining(); ++i) {
            this.data[i] = byteBuffer.get();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i)) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if (i <= 0 || i % 8 != 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

