/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.tajo.conf.TajoConf;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        try {
            int numRead;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{reader});
        return fileData.toString();
    }

    public static void writeTextToFile(String text, Path path) throws IOException {
        FileSystem fs = path.getFileSystem((Configuration)new TajoConf());
        if (!fs.exists(path.getParent())) {
            fs.mkdirs(path.getParent());
        }
        FSDataOutputStream out = fs.create(path);
        out.write(text.getBytes());
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFromStream(InputStream inputStream) throws IOException {
        try {
            int numRead;
            StringBuilder fileData = new StringBuilder(1000);
            byte[] buf = new byte[1024];
            while ((numRead = inputStream.read(buf)) != -1) {
                String readData = new String(buf, 0, numRead, Charset.defaultCharset());
                fileData.append(readData);
            }
            String string = fileData.toString();
            return string;
        }
        finally {
            IOUtils.closeStream((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextToStream(String text, OutputStream outputStream) throws IOException {
        try {
            outputStream.write(text.getBytes());
        }
        finally {
            IOUtils.closeStream((Closeable)outputStream);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void cleanup(Log log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug((Object)("Exception in closing " + c), (Throwable)e);
            }
        }
    }

    public static void cleanupAndthrowIfFailed(Closeable ... closeables) throws IOException {
        IOException ioe = null;
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

