/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.SessionVars;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.json.CommonGsonHelper;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.util.TUtil;

public class KeyValueSet
implements ProtoObject<PrimitiveProtos.KeyValueSetProto>,
Cloneable,
GsonObject {
    public static final String TRUE_STR = "true";
    public static final String FALSE_STR = "false";
    @Expose
    private Map<String, String> keyVals = TUtil.newHashMap();

    public KeyValueSet() {
    }

    public KeyValueSet(Map<String, String> keyVals) {
        this();
        this.putAll(keyVals);
    }

    public KeyValueSet(PrimitiveProtos.KeyValueSetProto proto) {
        for (PrimitiveProtos.KeyValueProto keyval : proto.getKeyvalList()) {
            this.keyVals.put(keyval.getKey(), keyval.getValue());
        }
    }

    public KeyValueSet(KeyValueSet keyValueSet) {
        this();
        this.keyVals.putAll(keyValueSet.keyVals);
    }

    public static KeyValueSet create() {
        return new KeyValueSet();
    }

    public static KeyValueSet create(KeyValueSet keyValueSet) {
        return new KeyValueSet(keyValueSet);
    }

    public int size() {
        return this.keyVals.size();
    }

    public void putAll(Map<String, String> keyValues) {
        if (keyValues != null) {
            this.keyVals.putAll(keyValues);
        }
    }

    public void putAll(KeyValueSet keyValueSet) {
        if (keyValueSet != null) {
            this.keyVals.putAll(keyValueSet.keyVals);
        }
    }

    public Map<String, String> getAllKeyValus() {
        return this.keyVals;
    }

    public boolean containsKey(String key) {
        return this.keyVals.containsKey(key);
    }

    public void set(String key, String val) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)val);
        this.keyVals.put(key, val);
    }

    public String get(String key, String defaultVal) {
        if (this.keyVals.containsKey(key)) {
            return this.keyVals.get(key);
        }
        if (defaultVal != null) {
            return defaultVal;
        }
        throw new IllegalArgumentException("No such config key: " + key);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public boolean isTrue(String key) {
        return this.getBool(key, false);
    }

    public void setBool(String key, boolean val) {
        this.set(key, val ? TRUE_STR : FALSE_STR);
    }

    public boolean getBool(String key, Boolean defaultVal) {
        if (this.containsKey(key)) {
            String strVal = this.get(key, null);
            return strVal != null && strVal.equalsIgnoreCase(TRUE_STR);
        }
        if (defaultVal != null) {
            return defaultVal;
        }
        return false;
    }

    public boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public boolean getBool(ConfigKey key) {
        String keyName = key.keyname();
        if (key instanceof SessionVars) {
            return this.getBool(keyName, ((SessionVars)key).getConfVars().defaultBoolVal);
        }
        if (key instanceof TajoConf.ConfVars) {
            return this.getBool(keyName, ((TajoConf.ConfVars)key).defaultBoolVal);
        }
        return this.getBool(keyName);
    }

    public void setInt(String key, int val) {
        this.set(key, String.valueOf(val));
    }

    public int getInt(String key, Integer defaultVal) {
        if (this.containsKey(key)) {
            String strVal = this.get(key, null);
            return Integer.parseInt(strVal);
        }
        if (defaultVal != null) {
            return defaultVal;
        }
        throw new IllegalArgumentException("No such a config key: " + key);
    }

    public int getInt(String key) {
        return this.getInt(key, null);
    }

    public int getInt(ConfigKey key) {
        String keyName = key.keyname();
        if (key instanceof SessionVars) {
            return this.getInt(keyName, ((SessionVars)key).getConfVars().defaultIntVal);
        }
        if (key instanceof TajoConf.ConfVars) {
            return this.getInt(keyName, ((TajoConf.ConfVars)key).defaultIntVal);
        }
        return this.getInt(keyName);
    }

    public void setLong(String key, long val) {
        this.set(key, String.valueOf(val));
    }

    public long getLong(String key, Long defaultVal) {
        if (this.containsKey(key)) {
            String strVal = this.get(key, null);
            return Long.parseLong(strVal);
        }
        if (defaultVal != null) {
            return defaultVal;
        }
        throw new IllegalArgumentException("No such a config key: " + key);
    }

    public long getLong(String key) {
        return this.getLong(key, null);
    }

    public long getLong(ConfigKey key) {
        String keyName = key.keyname();
        if (key instanceof SessionVars) {
            return this.getLong(keyName, ((SessionVars)key).getConfVars().defaultLongVal);
        }
        if (key instanceof TajoConf.ConfVars) {
            return this.getLong(keyName, ((TajoConf.ConfVars)key).defaultLongVal);
        }
        return this.getLong(keyName);
    }

    public void setFloat(String key, float val) {
        this.set(key, String.valueOf(val));
    }

    public float getFloat(String key, Float defaultVal) {
        if (this.containsKey(key)) {
            String strVal = this.get(key, null);
            try {
                if (3.4028234663852886E38 < Double.parseDouble(strVal)) {
                    throw new IllegalStateException("Parsed value is overflow in float type");
                }
                return Float.parseFloat(strVal);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("No such a config key: " + key);
            }
        }
        if (defaultVal != null) {
            return defaultVal.floatValue();
        }
        throw new IllegalArgumentException("No such a config key: " + key);
    }

    public float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public float getFloat(ConfigKey key) {
        String keyName = key.keyname();
        if (key instanceof SessionVars) {
            return this.getFloat(keyName, Float.valueOf(((SessionVars)key).getConfVars().defaultFloatVal));
        }
        if (key instanceof TajoConf.ConfVars) {
            return this.getFloat(keyName, Float.valueOf(((TajoConf.ConfVars)key).defaultFloatVal));
        }
        return this.getFloat(keyName);
    }

    public String remove(String key) {
        return this.keyVals.remove(key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyVals});
    }

    public boolean equals(Object object) {
        if (object instanceof KeyValueSet) {
            KeyValueSet other = (KeyValueSet)object;
            for (Map.Entry<String, String> entry : other.keyVals.entrySet()) {
                if (this.keyVals.containsKey(entry.getKey()) && this.keyVals.get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        KeyValueSet keyValueSet = (KeyValueSet)super.clone();
        keyValueSet.keyVals = this.keyVals != null ? new HashMap<String, String>(this.keyVals) : null;
        return keyValueSet;
    }

    @Override
    public PrimitiveProtos.KeyValueSetProto getProto() {
        PrimitiveProtos.KeyValueSetProto.Builder builder = PrimitiveProtos.KeyValueSetProto.newBuilder();
        PrimitiveProtos.KeyValueProto.Builder kvBuilder = PrimitiveProtos.KeyValueProto.newBuilder();
        if (this.keyVals != null) {
            for (Map.Entry<String, String> kv : this.keyVals.entrySet()) {
                kvBuilder.setKey(kv.getKey());
                kvBuilder.setValue(kv.getValue());
                builder.addKeyval(kvBuilder.build());
                kvBuilder.clear();
            }
        }
        return builder.build();
    }

    @Override
    public String toJson() {
        return CommonGsonHelper.toJson(this, KeyValueSet.class);
    }
}

