/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.base.Function;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.SignalLogger;
import org.apache.tajo.util.VersionInfo;

public class StringUtils {
    public static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private static final String REGEX_SPECIAL_CHARACTERS = "([.*${}?|\\^\\-\\[\\]])";
    private static final String LIKE_SPECIAL_CHARACTERS = "([_%])";
    static BitSet charToEscape;

    public static String formatTime(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append(" hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append(" mins, ");
        }
        if (seconds != 0L) {
            buf.append(seconds);
            buf.append(" sec");
        }
        if (timeDiff < 1000L) {
            buf.append(timeDiff);
            buf.append(" msec");
        }
        return buf.toString();
    }

    public static boolean isPureAscii(String v) {
        CharsetEncoder asciiEncoder = CharsetUtil.getEncoder((Charset)CharsetUtil.US_ASCII);
        return asciiEncoder.canEncode(v);
    }

    public static String quote(String str) {
        return "'" + str + "'";
    }

    public static String doubleQuote(String str) {
        return "\"" + str + "\"";
    }

    public static boolean isPartOfAnsiSQLIdentifier(char character) {
        return StringUtils.isLowerCaseAlphabet(character) || StringUtils.isUpperCaseAlphabet(character) || StringUtils.isDigit(character) || StringUtils.isUndersscore(character);
    }

    public static boolean isUndersscore(char character) {
        return character == '_';
    }

    public static boolean isLowerCaseAlphabet(char character) {
        return 'a' <= character && character <= 'z';
    }

    public static boolean isUpperCaseAlphabet(char character) {
        return 'A' <= character && character <= 'Z';
    }

    public static boolean isDigit(char character) {
        return '0' <= character && character <= '9';
    }

    public static String escapeRegexp(String literal) {
        return literal.replaceAll(REGEX_SPECIAL_CHARACTERS, "\\\\$1");
    }

    public static String escapeLike(String literal) {
        return literal.replaceAll(LIKE_SPECIAL_CHARACTERS, "\\\\$1");
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n" + prefix + s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(Class<?> clazz, String[] args, final Log LOG) {
        final String hostname = NetUtils.getHostname();
        final String classname = clazz.getSimpleName();
        LOG.info((Object)StringUtils.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + VersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision() + "; compiled by '" + VersionInfo.getUser() + "' on " + VersionInfo.getDate(), "  java = " + System.getProperty("java.version")}));
        if (SystemUtils.IS_OS_UNIX) {
            try {
                SignalLogger.INSTANCE.register(LOG);
            }
            catch (Throwable t) {
                LOG.warn((Object)"failed to register any UNIX signal loggers: ", t);
            }
        }
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                LOG.info((Object)StringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", new String[]{"Shutting down " + classname + " at " + hostname}));
            }
        }, 0);
    }

    public static String unicodeEscapedDelimiter(String value) {
        try {
            String delimiter = StringEscapeUtils.unescapeJava((String)value);
            StringBuilder builder = new StringBuilder();
            for (char achar : delimiter.toCharArray()) {
                builder.append(StringUtils.unicodeEscapedDelimiter(achar));
            }
            return builder.toString();
        }
        catch (Throwable throwable) {
            return value;
        }
    }

    public static String unicodeEscapedDelimiter(char c) {
        return CharUtils.unicodeEscaped((char)c);
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return StringUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__TAJO_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (StringUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static char[][] padChars(char[] ... bytes) {
        int i;
        char[] startChars = bytes[0];
        char[] endChars = bytes[1];
        char[][] padded = new char[2][];
        int max = Math.max(startChars.length, endChars.length);
        padded[0] = new char[max];
        padded[1] = new char[max];
        System.arraycopy(startChars, 0, padded[0], 0, startChars.length);
        for (i = startChars.length; i < max; ++i) {
            padded[0][i] = '\u0000';
        }
        System.arraycopy(endChars, 0, padded[1], 0, endChars.length);
        for (i = endChars.length; i < max; ++i) {
            padded[1][i] = '\u0000';
        }
        return padded;
    }

    public static char[] convertBytesToChars(byte[] src, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        char[] resultArray = new char[(int)((float)src.length * decoder.maxCharsPerByte())];
        if (src.length != 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(src);
            CharBuffer charBuffer = CharBuffer.wrap(resultArray);
            decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.reset();
            CoderResult coderResult = decoder.decode(byteBuffer, charBuffer, true);
            if (coderResult.isUnderflow() && (coderResult = decoder.flush(charBuffer)).isUnderflow() && resultArray.length != charBuffer.position()) {
                resultArray = Arrays.copyOf(resultArray, charBuffer.position());
            }
        }
        return resultArray;
    }

    public static byte[] convertCharsToBytes(char[] src, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        byte[] resultArray = new byte[(int)((float)src.length * encoder.maxBytesPerChar())];
        if (src.length != 0) {
            CharBuffer charBuffer = CharBuffer.wrap(src);
            ByteBuffer byteBuffer = ByteBuffer.wrap(resultArray);
            encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            encoder.reset();
            CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
            if (coderResult.isUnderflow() && (coderResult = encoder.flush(byteBuffer)).isUnderflow() && resultArray.length != byteBuffer.position()) {
                resultArray = Arrays.copyOf(resultArray, byteBuffer.position());
            }
        }
        return resultArray;
    }

    public static String join(Iterable objects, String delimiter) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(object.toString());
        }
        return sb.toString();
    }

    public static String join(Object[] objects) {
        return StringUtils.join(objects, ", ");
    }

    public static String join(Object[] objects, String delimiter) {
        return StringUtils.join(objects, delimiter, 0, objects.length);
    }

    public static String join(Object[] objects, String delimiter, int startIndex) {
        return StringUtils.join(objects, delimiter, startIndex, objects.length);
    }

    public static String join(Object[] objects, String delimiter, int startIndex, int length) {
        return StringUtils.join(objects, delimiter, startIndex, length, new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }

    public static <T> String join(T[] objects, String delimiter, Function<T, String> f) {
        return StringUtils.join(objects, delimiter, 0, objects.length, f);
    }

    public static <T> String join(T[] objects, String delimiter, int startIndex, int length, Function<T, String> f) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        int endIndex = startIndex + length;
        int i = startIndex;
        while (i + startIndex < endIndex) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append((String)f.apply(objects[i]));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static {
        char[] clist;
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        if (Shell.WINDOWS) {
            char[] winClist;
            for (char c : winClist = new char[]{' ', '<', '>', '|'}) {
                charToEscape.set(c);
            }
        }
    }
}

