/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.datetime;

import java.util.HashMap;
import java.util.Map;

public class DateTimeConstants {
    public static final int[][] DAY_OF_MONTH = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};
    public static final double DAYS_PER_YEAR = 365.25;
    public static final int MONTHS_PER_YEAR = 12;
    public static final int DAYS_PER_MONTH = 30;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECS_PER_YEAR = 31557600;
    public static final int SECS_PER_DAY = 86400;
    public static final int SECS_PER_HOUR = 3600;
    public static final int SECS_PER_MINUTE = 60;
    public static final int MINS_PER_HOUR = 60;
    public static final long MSECS_PER_DAY = 86400000L;
    public static final long MSECS_PER_SEC = 1000L;
    public static final long USECS_PER_DAY = 86400000000L;
    public static final long USECS_PER_HOUR = 3600000000L;
    public static final long USECS_PER_MINUTE = 60000000L;
    public static final long USECS_PER_SEC = 1000000L;
    public static final long USECS_PER_MSEC = 1000L;
    public static final int JULIAN_MINYEAR = -4713;
    public static final int JULIAN_MINMONTH = 11;
    public static final int JULIAN_MINDAY = 24;
    public static final int JULIAN_MAXYEAR = 5874898;
    public static final int JULIAN_MAX = 0x7FFFFF66;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 7;
    public static final int UNIX_EPOCH_JDATE = 2440588;
    public static final int POSTGRES_EPOCH_JDATE = 2451545;
    public static final long SECS_DIFFERENCE_BETWEEN_JULIAN_AND_UNIXTIME = 946684800L;
    public static final int MAX_TZDISP_HOUR = 15;
    public static final int TZDISP_LIMIT = 57600;
    public static final int INTERVAL_FULL_RANGE = Short.MAX_VALUE;
    public static final String DAGO = "ago";
    public static final String DCURRENT = "current";
    public static final String EPOCH = "epoch";
    public static final String INVALID = "invalid";
    public static final String EARLY = "-infinity";
    public static final String LATE = "infinity";
    public static final String NOW = "now";
    public static final String TODAY = "today";
    public static final String TOMORROW = "tomorrow";
    public static final String YESTERDAY = "yesterday";
    public static final String ZULU = "zulu";
    public static final String DMICROSEC = "usecond";
    public static final String DMILLISEC = "msecond";
    public static final String DSECOND = "second";
    public static final String DMINUTE = "minute";
    public static final String DHOUR = "hour";
    public static final String DDAY = "day";
    public static final String DWEEK = "week";
    public static final String DMONTH = "month";
    public static final String DQUARTER = "quarter";
    public static final String DYEAR = "year";
    public static final String DDECADE = "decade";
    public static final String DCENTURY = "century";
    public static final String DMILLENNIUM = "millennium";
    public static final String DA_D = "ad";
    public static final String DB_C = "bc";
    public static final String DTIMEZONE = "timezone";
    public static final int DATEORDER_YMD = 0;
    public static final int DATEORDER_DMY = 1;
    public static final int DATEORDER_MDY = 2;
    static Object[][] datetktbl = new Object[][]{{"-infinity", TokenField.RESERV, TokenField.DTK_EARLY}, {"acsst", TokenField.DTZ, 42}, {"acst", TokenField.DTZ, -16}, {"act", TokenField.TZ, -20}, {"ad", TokenField.ADBC, TokenField.AD}, {"adt", TokenField.DTZ, -12}, {"aesst", TokenField.DTZ, 44}, {"aest", TokenField.TZ, 40}, {"aft", TokenField.TZ, 18}, {"ahst", TokenField.TZ, -40}, {"akdt", TokenField.DTZ, -32}, {"akst", TokenField.DTZ, -36}, {"allballs", TokenField.RESERV, TokenField.DTK_ZULU}, {"almst", TokenField.TZ, 28}, {"almt", TokenField.TZ, 24}, {"am", TokenField.AMPM, TokenField.AM}, {"amst", TokenField.DTZ, 20}, {"amt", TokenField.TZ, 16}, {"anast", TokenField.DTZ, 52}, {"anat", TokenField.TZ, 48}, {"apr", TokenField.MONTH, 4}, {"april", TokenField.MONTH, 4}, {"art", TokenField.TZ, -12}, {"ast", TokenField.TZ, -16}, {"at", TokenField.IGNORE_DTF, 0}, {"aug", TokenField.MONTH, 8}, {"august", TokenField.MONTH, 8}, {"awsst", TokenField.DTZ, 36}, {"awst", TokenField.TZ, 32}, {"awt", TokenField.DTZ, -12}, {"azost", TokenField.DTZ, 0}, {"azot", TokenField.TZ, -4}, {"azst", TokenField.DTZ, 20}, {"azt", TokenField.TZ, 16}, {"bc", TokenField.ADBC, TokenField.BC}, {"bdst", TokenField.TZ, 8}, {"bdt", TokenField.TZ, 24}, {"bnt", TokenField.TZ, 32}, {"bort", TokenField.TZ, 32}, {"bot", TokenField.TZ, -16}, {"bra", TokenField.TZ, -12}, {"bst", TokenField.DTZ, 4}, {"bt", TokenField.TZ, 12}, {"btt", TokenField.TZ, 24}, {"cadt", TokenField.DTZ, 42}, {"cast", TokenField.TZ, 38}, {"cat", TokenField.TZ, -40}, {"cct", TokenField.TZ, 32}, {"cdt", TokenField.DTZ, -20}, {"cest", TokenField.DTZ, 8}, {"cet", TokenField.TZ, 4}, {"cetdst", TokenField.DTZ, 8}, {"chadt", TokenField.DTZ, 55}, {"chast", TokenField.TZ, 51}, {"ckt", TokenField.TZ, 48}, {"clst", TokenField.DTZ, -12}, {"clt", TokenField.TZ, -16}, {"cot", TokenField.TZ, -20}, {"cst", TokenField.TZ, -24}, {"current", TokenField.RESERV, TokenField.DTK_CURRENT}, {"cvt", TokenField.TZ, 28}, {"cxt", TokenField.TZ, 28}, {"d", TokenField.UNITS, TokenField.DTK_DAY}, {"davt", TokenField.TZ, 28}, {"ddut", TokenField.TZ, 40}, {"dec", TokenField.MONTH, 12}, {"december", TokenField.MONTH, 12}, {"dnt", TokenField.TZ, 4}, {"dow", TokenField.RESERV, TokenField.DTK_DOW}, {"doy", TokenField.RESERV, TokenField.DTK_DOY}, {"dst", TokenField.DTZMOD, 6}, {"easst", TokenField.DTZ, -20}, {"east", TokenField.TZ, -24}, {"eat", TokenField.TZ, 12}, {"edt", TokenField.DTZ, -16}, {"eest", TokenField.DTZ, 12}, {"eet", TokenField.TZ, 8}, {"eetdst", TokenField.DTZ, 12}, {"egst", TokenField.DTZ, 0}, {"egt", TokenField.TZ, -4}, {"epoch", TokenField.RESERV, TokenField.DTK_EPOCH}, {"est", TokenField.TZ, -20}, {"feb", TokenField.MONTH, 2}, {"february", TokenField.MONTH, 2}, {"fjst", TokenField.DTZ, -52}, {"fjt", TokenField.TZ, -48}, {"fkst", TokenField.DTZ, -12}, {"fkt", TokenField.TZ, -8}, {"fri", TokenField.DOW, 5}, {"friday", TokenField.DOW, 5}, {"fst", TokenField.TZ, 4}, {"fwt", TokenField.DTZ, 8}, {"galt", TokenField.TZ, -24}, {"gamt", TokenField.TZ, -36}, {"gest", TokenField.DTZ, 20}, {"get", TokenField.TZ, 16}, {"gft", TokenField.TZ, -12}, {"gilt", TokenField.TZ, 48}, {"gmt", TokenField.TZ, 0}, {"gst", TokenField.TZ, 40}, {"gyt", TokenField.TZ, -16}, {"h", TokenField.UNITS, TokenField.DTK_HOUR}, {"hdt", TokenField.DTZ, -36}, {"hkt", TokenField.TZ, 32}, {"hst", TokenField.TZ, -40}, {"ict", TokenField.TZ, 28}, {"idle", TokenField.TZ, 48}, {"idlw", TokenField.TZ, -48}, {"infinity", TokenField.RESERV, TokenField.DTK_LATE}, {"invalid", TokenField.RESERV, TokenField.DTK_INVALID}, {"iot", TokenField.TZ, 20}, {"irkst", TokenField.DTZ, 36}, {"irkt", TokenField.TZ, 32}, {"irt", TokenField.TZ, 14}, {"isodow", TokenField.RESERV, TokenField.DTK_ISODOW}, {"ist", TokenField.TZ, 8}, {"it", TokenField.TZ, 14}, {"j", TokenField.UNITS, TokenField.DTK_JULIAN}, {"jan", TokenField.MONTH, 1}, {"january", TokenField.MONTH, 1}, {"javt", TokenField.TZ, 28}, {"jayt", TokenField.TZ, 36}, {"jd", TokenField.UNITS, TokenField.DTK_JULIAN}, {"jst", TokenField.TZ, 36}, {"jt", TokenField.TZ, 30}, {"jul", TokenField.MONTH, 7}, {"julian", TokenField.UNITS, TokenField.DTK_JULIAN}, {"july", TokenField.MONTH, 7}, {"jun", TokenField.MONTH, 6}, {"june", TokenField.MONTH, 6}, {"kdt", TokenField.DTZ, 40}, {"kgst", TokenField.DTZ, 24}, {"kgt", TokenField.TZ, 20}, {"kost", TokenField.TZ, 48}, {"krast", TokenField.DTZ, 28}, {"krat", TokenField.TZ, 32}, {"kst", TokenField.TZ, 36}, {"lhdt", TokenField.DTZ, 44}, {"lhst", TokenField.TZ, 42}, {"ligt", TokenField.TZ, 40}, {"lint", TokenField.TZ, 56}, {"lkt", TokenField.TZ, 24}, {"m", TokenField.UNITS, TokenField.DTK_MONTH}, {"magst", TokenField.DTZ, 48}, {"magt", TokenField.TZ, 44}, {"mar", TokenField.MONTH, 3}, {"march", TokenField.MONTH, 3}, {"mart", TokenField.TZ, -38}, {"mawt", TokenField.TZ, 24}, {"may", TokenField.MONTH, 5}, {"mdt", TokenField.DTZ, -24}, {"mest", TokenField.DTZ, 8}, {"met", TokenField.TZ, 4}, {"metdst", TokenField.DTZ, 8}, {"mewt", TokenField.TZ, 4}, {"mez", TokenField.TZ, 4}, {"mht", TokenField.TZ, 48}, {"mm", TokenField.UNITS, TokenField.DTK_MINUTE}, {"mmt", TokenField.TZ, 26}, {"mon", TokenField.DOW, 1}, {"monday", TokenField.DOW, 1}, {"mpt", TokenField.TZ, 40}, {"msd", TokenField.DTZ, 16}, {"msk", TokenField.TZ, 12}, {"mst", TokenField.TZ, -28}, {"mt", TokenField.TZ, 34}, {"mut", TokenField.TZ, 16}, {"mvt", TokenField.TZ, 20}, {"myt", TokenField.TZ, 32}, {"nct", TokenField.TZ, 44}, {"ndt", TokenField.DTZ, -10}, {"nft", TokenField.TZ, -14}, {"nor", TokenField.TZ, 4}, {"nov", TokenField.MONTH, 11}, {"november", TokenField.MONTH, 11}, {"novst", TokenField.DTZ, 28}, {"novt", TokenField.TZ, 24}, {"now", TokenField.RESERV, TokenField.DTK_NOW}, {"npt", TokenField.TZ, 23}, {"nst", TokenField.TZ, -14}, {"nt", TokenField.TZ, -44}, {"nut", TokenField.TZ, -44}, {"nzdt", TokenField.DTZ, 52}, {"nzst", TokenField.TZ, 48}, {"nzt", TokenField.TZ, 48}, {"oct", TokenField.MONTH, 10}, {"october", TokenField.MONTH, 10}, {"omsst", TokenField.DTZ, 28}, {"omst", TokenField.TZ, 24}, {"on", TokenField.IGNORE_DTF, 0}, {"pdt", TokenField.DTZ, -28}, {"pet", TokenField.TZ, -20}, {"petst", TokenField.DTZ, 52}, {"pett", TokenField.TZ, 48}, {"pgt", TokenField.TZ, 40}, {"phot", TokenField.TZ, 52}, {"pht", TokenField.TZ, 32}, {"pkt", TokenField.TZ, 20}, {"pm", TokenField.AMPM, TokenField.PM}, {"pmdt", TokenField.DTZ, -8}, {"pont", TokenField.TZ, 44}, {"pst", TokenField.TZ, -32}, {"pwt", TokenField.TZ, 36}, {"pyst", TokenField.DTZ, -12}, {"pyt", TokenField.TZ, -16}, {"ret", TokenField.DTZ, 16}, {"s", TokenField.UNITS, TokenField.DTK_SECOND}, {"sadt", TokenField.DTZ, 42}, {"sast", TokenField.TZ, 38}, {"sat", TokenField.DOW, 6}, {"saturday", TokenField.DOW, 6}, {"sct", TokenField.DTZ, 16}, {"sep", TokenField.MONTH, 9}, {"sept", TokenField.MONTH, 9}, {"september", TokenField.MONTH, 9}, {"set", TokenField.TZ, -4}, {"sst", TokenField.DTZ, 8}, {"sun", TokenField.DOW, 0}, {"sunday", TokenField.DOW, 0}, {"swt", TokenField.TZ, 4}, {"t", TokenField.ISOTIME, TokenField.DTK_TIME}, {"tft", TokenField.TZ, 20}, {"that", TokenField.TZ, -40}, {"thu", TokenField.DOW, 4}, {"thur", TokenField.DOW, 4}, {"thurs", TokenField.DOW, 4}, {"thursday", TokenField.DOW, 4}, {"tjt", TokenField.TZ, 20}, {"tkt", TokenField.TZ, -40}, {"tmt", TokenField.TZ, 20}, {"today", TokenField.RESERV, TokenField.DTK_TODAY}, {"tomorrow", TokenField.RESERV, TokenField.DTK_TOMORROW}, {"truk", TokenField.TZ, 40}, {"tue", TokenField.DOW, 2}, {"tues", TokenField.DOW, 2}, {"tuesday", TokenField.DOW, 2}, {"tvt", TokenField.TZ, 48}, {"ulast", TokenField.DTZ, 36}, {"ulat", TokenField.TZ, 32}, {"undefined", TokenField.RESERV, TokenField.DTK_INVALID}, {"ut", TokenField.TZ, 0}, {"utc", TokenField.TZ, 0}, {"uyst", TokenField.DTZ, -8}, {"uyt", TokenField.TZ, -12}, {"uzst", TokenField.DTZ, 24}, {"uzt", TokenField.TZ, 20}, {"vet", TokenField.TZ, -16}, {"vlast", TokenField.DTZ, 44}, {"vlat", TokenField.TZ, 40}, {"vut", TokenField.TZ, 44}, {"wadt", TokenField.DTZ, 32}, {"wakt", TokenField.TZ, 48}, {"wast", TokenField.TZ, 28}, {"wat", TokenField.TZ, -4}, {"wdt", TokenField.DTZ, 36}, {"wed", TokenField.DOW, 3}, {"wednesday", TokenField.DOW, 3}, {"weds", TokenField.DOW, 3}, {"west", TokenField.DTZ, 4}, {"wet", TokenField.TZ, 0}, {"wetdst", TokenField.DTZ, 4}, {"wft", TokenField.TZ, 48}, {"wgst", TokenField.DTZ, -8}, {"wgt", TokenField.TZ, -12}, {"wst", TokenField.TZ, 32}, {"y", TokenField.UNITS, TokenField.DTK_YEAR}, {"yakst", TokenField.DTZ, 40}, {"yakt", TokenField.TZ, 36}, {"yapt", TokenField.TZ, 40}, {"ydt", TokenField.DTZ, -32}, {"yekst", TokenField.DTZ, 24}, {"yekt", TokenField.TZ, 20}, {"yesterday", TokenField.RESERV, TokenField.DTK_YESTERDAY}, {"yst", TokenField.TZ, -36}, {"z", TokenField.TZ, 0}, {"zp4", TokenField.TZ, -16}, {"zp5", TokenField.TZ, -20}, {"zp6", TokenField.TZ, -24}, {"zulu", TokenField.TZ, 0}};
    static Object[][] deltatktbl = new Object[][]{{"@", TokenField.IGNORE_DTF, 0}, {"ago", TokenField.AGO, 0}, {"c", TokenField.UNITS, TokenField.DTK_CENTURY}, {"cent", TokenField.UNITS, TokenField.DTK_CENTURY}, {"centuries", TokenField.UNITS, TokenField.DTK_CENTURY}, {"century", TokenField.UNITS, TokenField.DTK_CENTURY}, {"d", TokenField.UNITS, TokenField.DTK_DAY}, {"day", TokenField.UNITS, TokenField.DTK_DAY}, {"days_full", TokenField.UNITS, TokenField.DTK_DAY}, {"dec", TokenField.UNITS, TokenField.DTK_DECADE}, {"decade", TokenField.UNITS, TokenField.DTK_DECADE}, {"decades", TokenField.UNITS, TokenField.DTK_DECADE}, {"decs", TokenField.UNITS, TokenField.DTK_DECADE}, {"h", TokenField.UNITS, TokenField.DTK_HOUR}, {"hour", TokenField.UNITS, TokenField.DTK_HOUR}, {"hours", TokenField.UNITS, TokenField.DTK_HOUR}, {"hr", TokenField.UNITS, TokenField.DTK_HOUR}, {"hrs", TokenField.UNITS, TokenField.DTK_HOUR}, {"invalid", TokenField.RESERV, TokenField.DTK_INVALID}, {"m", TokenField.UNITS, TokenField.DTK_MINUTE}, {"microsecon", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"mil", TokenField.UNITS, TokenField.DTK_MILLENNIUM}, {"millennia", TokenField.UNITS, TokenField.DTK_MILLENNIUM}, {"millennium", TokenField.UNITS, TokenField.DTK_MILLENNIUM}, {"millisecon", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"mils", TokenField.UNITS, TokenField.DTK_MILLENNIUM}, {"min", TokenField.UNITS, TokenField.DTK_MINUTE}, {"mins", TokenField.UNITS, TokenField.DTK_MINUTE}, {"minute", TokenField.UNITS, TokenField.DTK_MINUTE}, {"minutes", TokenField.UNITS, TokenField.DTK_MINUTE}, {"mon", TokenField.UNITS, TokenField.DTK_MONTH}, {"mons", TokenField.UNITS, TokenField.DTK_MONTH}, {"month", TokenField.UNITS, TokenField.DTK_MONTH}, {"months_short", TokenField.UNITS, TokenField.DTK_MONTH}, {"ms", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"msec", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"msecond", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"mseconds", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"msecs", TokenField.UNITS, TokenField.DTK_MILLISEC}, {"qtr", TokenField.UNITS, TokenField.DTK_QUARTER}, {"quarter", TokenField.UNITS, TokenField.DTK_QUARTER}, {"s", TokenField.UNITS, TokenField.DTK_SECOND}, {"sec", TokenField.UNITS, TokenField.DTK_SECOND}, {"second", TokenField.UNITS, TokenField.DTK_SECOND}, {"seconds", TokenField.UNITS, TokenField.DTK_SECOND}, {"secs", TokenField.UNITS, TokenField.DTK_SECOND}, {"timezone", TokenField.UNITS, TokenField.DTK_TZ}, {"timezone_h", TokenField.UNITS, TokenField.DTK_TZ_HOUR}, {"timezone_m", TokenField.UNITS, TokenField.DTK_TZ_MINUTE}, {"undefined", TokenField.RESERV, TokenField.DTK_INVALID}, {"us", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"usec", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"usecond", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"useconds", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"usecs", TokenField.UNITS, TokenField.DTK_MICROSEC}, {"w", TokenField.UNITS, TokenField.DTK_WEEK}, {"week", TokenField.UNITS, TokenField.DTK_WEEK}, {"weeks", TokenField.UNITS, TokenField.DTK_WEEK}, {"y", TokenField.UNITS, TokenField.DTK_YEAR}, {"year", TokenField.UNITS, TokenField.DTK_YEAR}, {"years", TokenField.UNITS, TokenField.DTK_YEAR}, {"yr", TokenField.UNITS, TokenField.DTK_YEAR}, {"yrs", TokenField.UNITS, TokenField.DTK_YEAR}};
    public static final Map<String, DateToken> dateTokenMap = new HashMap<String, DateToken>();
    public static final int DTK_ALL_SECS_M;
    public static final int DTK_DATE_M;
    public static final int DTK_TIME_M;

    public static int INTERVAL_MASK(TokenField t) {
        return 1 << t.getValue();
    }

    public static int DTK_M(TokenField t) {
        return 1 << t.getValue();
    }

    static {
        for (Object[] eachToken : datetktbl) {
            DateToken dateToken = new DateToken();
            dateToken.key = eachToken[0].toString();
            dateToken.type = (TokenField)((Object)eachToken[1]);
            if (eachToken[2] instanceof TokenField) {
                dateToken.valueType = (TokenField)((Object)eachToken[2]);
                dateToken.value = dateToken.valueType.getValue();
            } else {
                dateToken.valueType = TokenField.DECIMAL;
                dateToken.value = (Integer)eachToken[2];
            }
            dateTokenMap.put(dateToken.key, dateToken);
        }
        DTK_ALL_SECS_M = DateTimeConstants.DTK_M(TokenField.SECOND) | DateTimeConstants.DTK_M(TokenField.MILLISECOND) | DateTimeConstants.DTK_M(TokenField.MICROSECOND);
        DTK_DATE_M = DateTimeConstants.DTK_M(TokenField.YEAR) | DateTimeConstants.DTK_M(TokenField.MONTH) | DateTimeConstants.DTK_M(TokenField.DAY);
        DTK_TIME_M = DateTimeConstants.DTK_M(TokenField.HOUR) | DateTimeConstants.DTK_M(TokenField.MINUTE) | DateTimeConstants.DTK_M(TokenField.SECOND);
    }

    public static class DateToken {
        String key;
        TokenField type;
        int value;
        TokenField valueType;

        public String getKey() {
            return this.key;
        }

        public TokenField getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }

        public TokenField getValueType() {
            return this.valueType;
        }
    }

    public static enum TokenField {
        DECIMAL(0),
        AM(0),
        PM(1),
        HR24(2),
        AD(0),
        BC(1),
        DTK_NUMBER(0),
        DTK_STRING(1),
        DTK_DATE(2),
        DTK_TIME(3),
        DTK_TZ(4),
        DTK_AGO(5),
        DTK_SPECIAL(6),
        DTK_INVALID(7),
        DTK_CURRENT(8),
        DTK_EARLY(9),
        DTK_LATE(10),
        DTK_EPOCH(11),
        DTK_NOW(12),
        DTK_YESTERDAY(13),
        DTK_TODAY(14),
        DTK_TOMORROW(15),
        DTK_ZULU(16),
        DTK_DELTA(17),
        DTK_SECOND(18),
        DTK_MINUTE(19),
        DTK_HOUR(20),
        DTK_DAY(21),
        DTK_WEEK(22),
        DTK_MONTH(23),
        DTK_QUARTER(24),
        DTK_YEAR(25),
        DTK_DECADE(26),
        DTK_CENTURY(27),
        DTK_MILLENNIUM(28),
        DTK_MILLISEC(29),
        DTK_MICROSEC(30),
        DTK_JULIAN(31),
        DTK_DOW(32),
        DTK_DOY(33),
        DTK_TZ_HOUR(34),
        DTK_TZ_MINUTE(35),
        DTK_ISOYEAR(36),
        DTK_ISODOW(37),
        RESERV(0),
        MONTH(1),
        YEAR(2),
        DAY(3),
        JULIAN(4),
        TZ(5),
        DTZ(6),
        DTZMOD(7),
        IGNORE_DTF(8),
        AMPM(9),
        HOUR(10),
        MINUTE(11),
        SECOND(12),
        MILLISECOND(13),
        MICROSECOND(14),
        DOY(15),
        DOW(16),
        UNITS(17),
        ADBC(18),
        AGO(19),
        ABS_BEFORE(20),
        ABS_AFTER(21),
        ISODATE(22),
        ISOTIME(23),
        WEEK(24),
        DECADE(25),
        CENTURY(26),
        MILLENNIUM(27),
        UNKNOWN_FIELD(28);

        int value;

        private TokenField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DateStyle {
        XSO_DATES,
        ISO_DATES,
        SQL_DATES;

    }
}

