/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.graph;

import java.util.ArrayList;
import org.apache.tajo.util.graph.DirectedGraph;

public class DirectedGraphCursor<V, E> {
    private DirectedGraph<V, E> graph;
    private ArrayList<V> orderedVertices = new ArrayList();
    private int cursor = 0;

    public DirectedGraphCursor(DirectedGraph<V, E> graph, V startVertex) {
        this.graph = graph;
        this.buildOrder(startVertex);
    }

    public int size() {
        return this.orderedVertices.size();
    }

    private void buildOrder(V current) {
        if (!this.graph.isLeaf(current)) {
            for (V child : this.graph.getChilds(current)) {
                this.buildOrder(child);
            }
        }
        this.orderedVertices.add(current);
    }

    public boolean hasNext() {
        return this.cursor < this.orderedVertices.size();
    }

    public V nextBlock() {
        return this.orderedVertices.get(this.cursor++);
    }

    public V peek() {
        return this.orderedVertices.get(this.cursor);
    }

    public V peek(int skip) {
        return this.orderedVertices.get(this.cursor + skip);
    }

    public void reset() {
        this.cursor = 0;
    }
}

