/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class NetworkAddressValidator
extends AbstractValidator {
    private final Pattern hostnamePattern = Pattern.compile("^\\w[\\w-]*(\\.\\w[\\w-]*)*\\.[a-zA-Z][\\w-]*.?$|[a-zA-Z][\\w-]*.?$");
    private final Pattern portNumberPattern = Pattern.compile("^[1-6]?[0-9]{1,4}$");

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " is not a valid network address representation.";
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof CharSequence) {
                String valueString = object.toString();
                if (valueString.isEmpty()) {
                    result = true;
                } else {
                    int separatorIdx = valueString.indexOf(58);
                    String hostOrIpAddress = null;
                    if (separatorIdx > -1) {
                        if (valueString.indexOf(58, separatorIdx + 1) > -1) {
                            int leftBracketsIdx = valueString.indexOf(91);
                            int rightBracketsIdx = valueString.indexOf(93);
                            int periodIdx = valueString.indexOf(46);
                            if (leftBracketsIdx > -1 && rightBracketsIdx > -1 && valueString.length() > rightBracketsIdx + 1 && valueString.charAt(rightBracketsIdx + 1) == ':') {
                                hostOrIpAddress = valueString.substring(leftBracketsIdx + 1, rightBracketsIdx);
                                separatorIdx = rightBracketsIdx + 1;
                            } else if (periodIdx > -1) {
                                hostOrIpAddress = valueString.substring(0, periodIdx);
                                separatorIdx = periodIdx;
                            } else {
                                separatorIdx = valueString.lastIndexOf(58);
                                hostOrIpAddress = valueString.substring(0, separatorIdx);
                            }
                        } else {
                            hostOrIpAddress = valueString.substring(0, separatorIdx);
                        }
                    } else {
                        hostOrIpAddress = valueString;
                    }
                    result = this.hostnamePattern.matcher(hostOrIpAddress).find() | InetAddressUtils.isIPv4Address((String)hostOrIpAddress) | InetAddressUtils.isIPv6Address((String)hostOrIpAddress);
                    if (separatorIdx > -1) {
                        result &= this.portNumberPattern.matcher(valueString.substring(separatorIdx + 1)).find();
                    }
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

