/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class PatternValidator
extends AbstractValidator {
    private final Pattern pattern;

    public PatternValidator(String patternString) {
        this.pattern = Pattern.compile(patternString);
    }

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " does not match to the " + this.pattern.pattern();
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof CharSequence) {
                String valueString = object.toString();
                result = valueString.isEmpty() ? true : this.pattern.matcher((CharSequence)object).find();
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

