/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.client.CatalogAdminClient;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.TajoClient;
import org.apache.tajo.client.TajoClientImpl;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.SQLExceptionUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.jdbc.TajoDatabaseMetaData;
import org.apache.tajo.jdbc.TajoPreparedStatement;
import org.apache.tajo.jdbc.TajoSQLException;
import org.apache.tajo.jdbc.TajoStatement;
import org.apache.tajo.jdbc.util.QueryStringDecoder;
import org.apache.tajo.rpc.RpcUtils;
import org.apache.tajo.util.KeyValueSet;

public class JdbcConnection
implements Connection {
    private static Log LOG = LogFactory.getLog(JdbcConnection.class);
    private final TajoClient tajoClient;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private final String rawURI;
    private final Properties properties;
    private final URI uri;
    private final String hostName;
    private final int port;
    private final String databaseName;
    private final Map<String, List<String>> params;
    private final KeyValueSet clientProperties;

    public JdbcConnection(String rawURI, Properties properties) throws SQLException {
        this.rawURI = rawURI;
        this.properties = properties;
        try {
            if (!rawURI.startsWith("jdbc:tajo:")) {
                throw new TajoInternalError("Invalid URL: " + rawURI);
            }
            int startIdx = rawURI.indexOf(":");
            if (startIdx < 0) {
                throw new TajoInternalError("Invalid URL: " + rawURI);
            }
            String uri = rawURI.substring(startIdx + 1, rawURI.length());
            try {
                this.uri = URI.create(uri);
            }
            catch (IllegalArgumentException iae) {
                throw new SQLException("Invalid URL: " + rawURI, "TAJO-001");
            }
            this.hostName = this.uri.getHost();
            if (this.hostName == null) {
                throw new SQLException("Invalid JDBC URI: " + rawURI, "TAJO-001");
            }
            this.port = this.uri.getPort() < 1 ? 26002 : this.uri.getPort();
            this.databaseName = this.uri.getPath() == null || this.uri.getPath().equalsIgnoreCase("") ? "default" : this.uri.getPath().split("/")[1];
            this.params = new QueryStringDecoder(rawURI).getParameters();
            properties.putAll(this.params);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SQLException("Invalid JDBC URI: " + rawURI, "TAJO-001");
        }
        this.clientProperties = new KeyValueSet();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    this.clientProperties.set(entry.getKey().toString(), StringUtils.join((Collection)((Collection)entry.getValue()), (String)","));
                    continue;
                }
                this.clientProperties.set(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        try {
            this.tajoClient = new TajoClientImpl(RpcUtils.createSocketAddr((String)this.hostName, (int)this.port), this.databaseName, this.clientProperties);
        }
        catch (Throwable t) {
            if (t instanceof DefaultTajoException) {
                throw SQLExceptionUtil.toSQLException((DefaultTajoException)((DefaultTajoException)t));
            }
            throw new TajoSQLException(Errors.ResultCode.INTERNAL_ERROR, t, new String[]{t.getMessage()});
        }
        this.closed.set(false);
    }

    public String getUri() {
        return this.rawURI;
    }

    public QueryClient getQueryClient() {
        return this.tajoClient;
    }

    public CatalogAdminClient getCatalogAdminClient() {
        return this.tajoClient;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed.get()) {
            if (this.tajoClient != null) {
                this.tajoClient.close();
            }
            this.closed.set(true);
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("commit");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new TajoSQLException(Errors.ResultCode.CLIENT_CONNECTION_DOES_NOT_EXIST, new String[0]);
        }
        return new TajoStatement(this, this.tajoClient);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005) {
            throw new SQLException("TYPE_SCROLL_SENSITIVE is not supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("CONCUR_READ_ONLY mode is not supported.");
        }
        return new TajoStatement(this, this.tajoClient);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStatement");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.tajoClient.getCurrentDatabase();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new TajoDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("getTypeMap");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("getWarnings");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            if (this.tajoClient.isConnected()) {
                ResultSet resultSet = this.tajoClient.executeQueryAndGetResult("SELECT 1;");
                boolean next = resultSet.next();
                boolean valid = next && resultSet.getLong(1) == 1L;
                resultSet.close();
                return valid;
            }
            return false;
        }
        catch (TajoException e) {
            throw SQLExceptionUtil.toSQLException((DefaultTajoException)e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("nativeSQL");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new TajoPreparedStatement(this, this.tajoClient, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new TajoPreparedStatement(this, this.tajoClient, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TajoPreparedStatement(this, this.tajoClient, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        LOG.warn((Object)"Tajo does not support setAutoCommit, so this invocation is ignored.");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.tajoClient.selectDatabase(catalog);
        }
        catch (TajoException e) {
            throw SQLExceptionUtil.toSQLException((DefaultTajoException)e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("setClientInfo");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("setClientInfo");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("setHoldability");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLFeatureNotSupportedException("setReadOnly");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTransactionIsolation");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (this.isWrapperFor(tClass)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + tClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> tClass) throws SQLException {
        return tClass.isInstance(this);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("abort is not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("getNetworkTimeout is not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNetworkTimeout not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        return "";
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSchema() is not supported yet");
    }
}

