/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.client.CatalogAdminClient;
import org.apache.tajo.client.ResultSetUtil;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.common.type.TajoTypeUtil;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.jdbc.JdbcConnection;
import org.apache.tajo.jdbc.MetaDataTuple;
import org.apache.tajo.jdbc.TajoMetaDataResultSet;
import org.apache.tajo.util.VersionInfo;

public class TajoDatabaseMetaData
implements DatabaseMetaData {
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final String KEYWORDS = "add,binary,boolean,explain,index,rename";
    private static final String NUMERIC_FUNCTIONS = "abs,acos,asin,atan,atan2,ceiling,cos,degrees,exp,,floor,mod,pi,pow,radians,round,sign,sin,sqrt,tan";
    private static final String STRING_FUNCTIONS = "ascii,chr,concat,left,length,ltrim,repeat,rtrim,substring";
    private static final String PROCEDURE_TERM = "UDF";
    private final JdbcConnection conn;
    private static final Schema importedExportedSchema = new Schema().addColumn("PKTABLE_CAT", TajoDataTypes.Type.VARCHAR).addColumn("PKTABLE_SCHEM", TajoDataTypes.Type.VARCHAR).addColumn("PKTABLE_NAME", TajoDataTypes.Type.VARCHAR).addColumn("PKCOLUMN_NAME", TajoDataTypes.Type.VARCHAR).addColumn("FKTABLE_CAT", TajoDataTypes.Type.VARCHAR).addColumn("FKTABLE_SCHEM", TajoDataTypes.Type.VARCHAR).addColumn("FKTABLE_NAME", TajoDataTypes.Type.VARCHAR).addColumn("FKCOLUMN_NAME", TajoDataTypes.Type.VARCHAR).addColumn("KEY_SEQ", TajoDataTypes.Type.INT2).addColumn("UPDATE_RULE", TajoDataTypes.Type.INT2).addColumn("DELETE_RULE", TajoDataTypes.Type.INT2).addColumn("FK_NAME", TajoDataTypes.Type.VARCHAR).addColumn("PK_NAME", TajoDataTypes.Type.VARCHAR).addColumn("DEFERRABILITY", TajoDataTypes.Type.INT2);

    public TajoDatabaseMetaData(JdbcConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.getUri();
    }

    @Override
    public String getUserName() throws SQLException {
        return "tajo";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Tajo";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return VersionInfo.getVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "tajo";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return KEYWORDS;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return STRING_FUNCTIONS;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return PROCEDURE_TERM;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 10240;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 131072;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2), new ArrayList());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT1, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    private String convertPattern(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (c == '_') {
                result.append('.');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public ResultSet getTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String[] types) throws SQLException {
        ArrayList<MetaDataTuple> resultTables = new ArrayList<MetaDataTuple>();
        String regtableNamePattern = this.convertPattern(tableNamePattern == null ? null : tableNamePattern);
        ArrayList targetCatalogs = Lists.newArrayList();
        if (catalog != null) {
            targetCatalogs.add(catalog);
        }
        try {
            CatalogAdminClient catalogAdmin = this.conn.getCatalogAdminClient();
            if (targetCatalogs.isEmpty()) {
                targetCatalogs.addAll(catalogAdmin.getAllDatabaseNames());
            }
            for (String databaseName : targetCatalogs) {
                List tableNames = catalogAdmin.getTableList(databaseName);
                for (String eachTableName : tableNames) {
                    if (!eachTableName.matches(regtableNamePattern)) continue;
                    MetaDataTuple tuple = new MetaDataTuple(5);
                    int index = 0;
                    tuple.put(index++, (Datum)new TextDatum(databaseName));
                    tuple.put(index++, (Datum)new TextDatum(""));
                    tuple.put(index++, (Datum)new TextDatum(eachTableName));
                    tuple.put(index++, (Datum)new TextDatum("TABLE"));
                    tuple.put(index++, (Datum)NullDatum.get());
                    resultTables.add(tuple);
                }
            }
            Collections.sort(resultTables, new Comparator<MetaDataTuple>(){

                @Override
                public int compare(MetaDataTuple table1, MetaDataTuple table2) {
                    int compVal = table1.getText(1).compareTo(table2.getText(1));
                    if (compVal == 0) {
                        compVal = table1.getText(2).compareTo(table2.getText(2));
                    }
                    return compVal;
                }
            });
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        TajoMetaDataResultSet result = new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), resultTables);
        return result;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String databaseName = this.conn.getQueryClient().getCurrentDatabase();
        MetaDataTuple tuple = new MetaDataTuple(2);
        tuple.put(0, (Datum)new TextDatum(""));
        tuple.put(1, (Datum)new TextDatum(databaseName));
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), Arrays.asList(tuple));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        List databaseNames = this.conn.getCatalogAdminClient().getAllDatabaseNames();
        ArrayList<MetaDataTuple> tuples = new ArrayList<MetaDataTuple>();
        for (String databaseName : databaseNames) {
            MetaDataTuple tuple = new MetaDataTuple(1);
            tuple.put(0, (Datum)new TextDatum(databaseName));
            tuples.add(tuple);
        }
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT"), Arrays.asList(TajoDataTypes.Type.VARCHAR), tuples);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<MetaDataTuple> columns = new ArrayList<MetaDataTuple>();
        MetaDataTuple tuple = new MetaDataTuple(2);
        tuple.put(0, (Datum)new TextDatum("TABLE"));
        columns.add(tuple);
        TajoMetaDataResultSet result = new TajoMetaDataResultSet(Arrays.asList("TABLE_TYPE"), Arrays.asList(TajoDataTypes.Type.VARCHAR), columns);
        return result;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ArrayList columns = new ArrayList();
        return new TajoMetaDataResultSet(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4), columns);
    }

    @Override
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String columnNamePattern) throws SQLException {
        ArrayList targetCatalogs = Lists.newArrayList();
        if (catalog != null) {
            targetCatalogs.add(catalog);
        }
        ArrayList<MetaDataTuple> columns = new ArrayList<MetaDataTuple>();
        try {
            if (targetCatalogs.isEmpty()) {
                targetCatalogs.addAll(this.conn.getCatalogAdminClient().getAllDatabaseNames());
            }
            for (String databaseName : targetCatalogs) {
                String regtableNamePattern = this.convertPattern(tableNamePattern == null ? null : tableNamePattern);
                String regcolumnNamePattern = this.convertPattern(columnNamePattern == null ? null : columnNamePattern);
                List tables = this.conn.getCatalogAdminClient().getTableList(databaseName);
                for (String table : tables) {
                    if (!table.matches(regtableNamePattern)) continue;
                    TableDesc tableDesc = this.conn.getCatalogAdminClient().getTableDesc(CatalogUtil.buildFQName((String[])new String[]{databaseName, table}));
                    int pos = 0;
                    for (Column column : tableDesc.getLogicalSchema().getRootColumns()) {
                        if (column.getSimpleName().matches(regcolumnNamePattern)) {
                            MetaDataTuple tuple = new MetaDataTuple(22);
                            int index = 0;
                            tuple.put(index++, (Datum)new TextDatum(databaseName));
                            tuple.put(index++, (Datum)new TextDatum(""));
                            tuple.put(index++, (Datum)new TextDatum(table));
                            tuple.put(index++, (Datum)new TextDatum(column.getSimpleName()));
                            tuple.put(index++, (Datum)new TextDatum("" + ResultSetUtil.tajoTypeToSqlType((TajoDataTypes.DataType)column.getDataType())));
                            tuple.put(index++, (Datum)new TextDatum(ResultSetUtil.toSqlType((TajoDataTypes.DataType)column.getDataType())));
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            tuple.put(index++, (Datum)new TextDatum("1"));
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            tuple.put(index++, (Datum)new TextDatum("" + pos));
                            tuple.put(index++, (Datum)new TextDatum("YES"));
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)NullDatum.get());
                            tuple.put(index++, (Datum)new TextDatum("0"));
                            columns.add(tuple);
                        }
                        ++pos;
                    }
                }
            }
            return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4), columns);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"), Arrays.asList(TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2), new ArrayList());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"), Arrays.asList(TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2), new ArrayList());
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return new TajoMetaDataResultSet(importedExportedSchema, new ArrayList());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return new TajoMetaDataResultSet(importedExportedSchema, new ArrayList());
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return new TajoMetaDataResultSet(importedExportedSchema, new ArrayList());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ArrayList<MetaDataTuple> tuples = new ArrayList<MetaDataTuple>();
        for (Datum[] eachDatums : TajoTypeUtil.getTypeInfos()) {
            MetaDataTuple tuple = new MetaDataTuple(eachDatums.length);
            for (int i = 0; i < eachDatums.length; ++i) {
                tuple.put(i, eachDatums[i]);
            }
            tuples.add(tuple);
        }
        return new TajoMetaDataResultSet(Arrays.asList("TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.BOOLEAN, TajoDataTypes.Type.INT2, TajoDataTypes.Type.BOOLEAN, TajoDataTypes.Type.BOOLEAN, TajoDataTypes.Type.BOOLEAN, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4), tuples);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.BOOLEAN, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT2, TajoDataTypes.Type.INT2, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("type hierarchies not supported");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("type hierarchies not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("user-defined types not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String databaseName = this.conn.getQueryClient().getCurrentDatabase();
        MetaDataTuple tuple = new MetaDataTuple(2);
        tuple.put(0, (Datum)new TextDatum(""));
        tuple.put(1, (Datum)new TextDatum(databaseName));
        return new TajoMetaDataResultSet(Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), Arrays.asList(tuple));
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new TajoMetaDataResultSet(Arrays.asList("NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"), Arrays.asList(TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.INT4, TajoDataTypes.Type.VARCHAR, TajoDataTypes.Type.VARCHAR), new ArrayList());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("getFunctions not supported");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("getFunctionColumns not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLFeatureNotSupportedException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("getPseudoColumns not supported");
    }
}

