/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.tajo.jdbc.JdbcConnection;

public class TajoDriver
implements Driver,
Closeable {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    public static final int JDBC_VERSION_MAJOR = 4;
    public static final int JDBC_VERSION_MINOR = 0;
    public static final String TAJO_JDBC_URL_PREFIX = "jdbc:tajo:";

    @Override
    public void close() throws IOException {
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        return this.acceptsURL(url) ? new JdbcConnection(url, properties) : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(TAJO_JDBC_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    static {
        try {
            DriverManager.registerDriver(new TajoDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

