/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.QueryId;
import org.apache.tajo.SessionVars;
import org.apache.tajo.client.QueryClient;
import org.apache.tajo.client.TajoClient;
import org.apache.tajo.client.TajoClientUtil;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.SQLExceptionUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.jdbc.JdbcConnection;
import org.apache.tajo.jdbc.TajoResultSetBase;
import org.apache.tajo.jdbc.TajoSQLException;
import org.apache.tajo.jdbc.WaitingResultSet;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class TajoStatement
implements Statement {
    protected JdbcConnection conn;
    protected TajoClient tajoClient;
    protected int fetchSize;
    protected TajoResultSetBase resultSet;
    protected SQLWarning warningChain;
    private boolean isClosed;
    private boolean blockWait;

    public TajoStatement(JdbcConnection conn, TajoClient tajoClient) {
        this.fetchSize = SessionVars.FETCH_ROWNUM.getConfVars().defaultIntVal;
        this.resultSet = null;
        this.warningChain = null;
        this.conn = conn;
        this.tajoClient = tajoClient;
        this.blockWait = tajoClient.getProperties().getBool((ConfigKey)SessionVars.BLOCK_ON_RESULT);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("addBatch() is not supported yet.");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection();
        if (this.resultSet == null || this.resultSet.getQueryId().isNull()) {
            return;
        }
        try {
            this.tajoClient.killQuery(this.resultSet.getQueryId());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            this.resultSet = null;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("clearBatch() is not supported yet.");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkConnection();
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("closeOnCompletion() is not supported yet.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.resultSet = (TajoResultSetBase)this.executeQuery(sql);
        return this.resultSet != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute() is not supported yet.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute() is not supported yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute() is not supported yet.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("executeBatch() is not supported yet.");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkConnection();
        return this.executeSQL(sql);
    }

    protected ResultSet executeSQL(String sql) throws SQLException {
        ClientProtos.SubmitQueryResponse response = this.tajoClient.executeQuery(sql);
        SQLExceptionUtil.throwIfError((PrimitiveProtos.ReturnState)response.getState());
        QueryId queryId = new QueryId(response.getQueryId());
        switch (response.getResultType()) {
            case ENCLOSED: {
                return TajoClientUtil.createResultSet((QueryClient)this.tajoClient, (ClientProtos.SubmitQueryResponse)response, (int)this.fetchSize);
            }
            case FETCH: {
                WaitingResultSet result = new WaitingResultSet((QueryClient)this.tajoClient, queryId, this.fetchSize);
                if (this.blockWait) {
                    result.getSchema();
                }
                return result;
            }
        }
        return TajoClientUtil.createNullResultSet((QueryId)queryId);
    }

    protected void checkConnection() throws SQLException {
        if (this.isClosed || this.conn.isClosed()) {
            throw new TajoSQLException(Errors.ResultCode.CLIENT_CONNECTION_DOES_NOT_EXIST, new String[0]);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkConnection();
        try {
            this.tajoClient.updateQuery(sql);
        }
        catch (TajoException e) {
            throw SQLExceptionUtil.toSQLException((DefaultTajoException)e);
        }
        return 1;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate() is not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate() is not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate() is not supported yet.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection();
        return this.conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys() is not supported yet.");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("getMaxFieldSize() is not supported yet.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.tajoClient.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLFeatureNotSupportedException("getMoreResults() is not supported yet.");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("getMoreResults() is not supported yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        System.err.println("getResultSetConcurrency() is not supported yet.");
        return -1;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        System.err.println("getResultSetConcurrency() is not supported yet.");
        return -1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        System.err.println("getResultSetHoldability() is not supported yet.");
        return -1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        System.err.println("getResultSetType() is not supported yet.");
        return -1;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        System.err.println("getResultSetType() is not supported yet.");
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("isCloseOnCompletion() is not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException("isPoolable() is not supported yet.");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        System.err.println("setCursorName() is not supported yet.");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        System.err.println("setEscapeProcessing() is not supported yet.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        System.err.println("setFetchDirection() is not supported yet.");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection();
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        System.err.println("setMaxFieldSize() is not supported yet.");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.tajoClient.setMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        System.err.println("setPoolable() is not supported yet.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        System.err.println("setQueryTimeout() is not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        System.err.println("isWrapperFor() is not supported yet.");
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        System.err.println("unwrap() is not supported yet.");
        return null;
    }
}

