/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private final Charset charset;
    private final String rawUri;
    private String queries;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String rawUri) {
        this(rawUri, Charset.defaultCharset());
    }

    public QueryStringDecoder(String rawUri, Charset charset) {
        this.rawUri = rawUri;
        this.charset = charset;
    }

    private void splitUri() {
        if (this.rawUri != null && !this.rawUri.isEmpty()) {
            int pathPos = this.rawUri.indexOf(63);
            this.queries = pathPos < 0 ? "" : (pathPos + 1 > this.rawUri.length() ? "" : this.rawUri.substring(pathPos + 1));
        }
    }

    protected void decodeParams() throws MalformedURLException, UnsupportedEncodingException {
        this.params = new HashMap<String, List<String>>();
        String queries = this.getQueries();
        if (queries != null && !queries.isEmpty()) {
            char c = '\u0000';
            int startPos = 0;
            String name = null;
            String value = null;
            for (int index = 0; index < queries.length(); ++index) {
                c = queries.charAt(index);
                if (c == '=') {
                    name = queries.substring(startPos, index);
                    if (name.isEmpty()) {
                        throw new MalformedURLException(this.rawUri + " is not a valid URL.");
                    }
                    name = this.decodeString(name);
                    startPos = index + 1;
                    continue;
                }
                if (c != '&') continue;
                if (name == null || name.isEmpty()) {
                    throw new MalformedURLException(this.rawUri + " is not a valid URL.");
                }
                value = queries.substring(startPos, index);
                if (value.isEmpty()) {
                    throw new MalformedURLException(this.rawUri + " is not a valid URL.");
                }
                value = this.decodeString(value);
                this.addParameter(name, value);
                startPos = index + 1;
            }
            if (startPos > 0 && name != null && !name.isEmpty()) {
                value = queries.substring(startPos);
                value = this.decodeString(value);
                this.addParameter(name, value);
            }
        }
    }

    protected String decodeString(String string) throws UnsupportedEncodingException {
        String decoded = "";
        if (string != null && !string.isEmpty()) {
            decoded = URLDecoder.decode(string, this.charset.name());
        }
        return decoded;
    }

    protected void addParameter(String name, String value) {
        List<String> valueList = this.params.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>();
            this.params.put(name, valueList);
        }
        valueList.add(value);
    }

    public String getRawUri() {
        return this.rawUri;
    }

    public String getQueries() {
        if (this.queries == null || this.queries.isEmpty()) {
            this.splitUri();
        }
        return this.queries;
    }

    public Map<String, List<String>> getParameters() throws MalformedURLException, UnsupportedEncodingException {
        if (this.params == null || this.params.size() <= 0) {
            this.decodeParams();
        }
        return this.params;
    }
}

