/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.hadoop.shim.HadoopShim;

@InterfaceAudience.Private
public interface AppContext {
    public DAGAppMaster getAppMaster();

    public Configuration getAMConf();

    public ApplicationId getApplicationID();

    public TezDAGID getCurrentDAGID();

    public long getCumulativeCPUTime();

    public long getCumulativeGCTime();

    public ApplicationAttemptId getApplicationAttemptId();

    public String getApplicationName();

    public Map<ApplicationAccessType, String> getApplicationACLs();

    public long getStartTime();

    public String getUser();

    public DAG getCurrentDAG();

    public ListeningExecutorService getExecService();

    public void setDAG(DAG var1);

    public void setDAGRecoveryData(RecoveryParser.DAGRecoveryData var1);

    public Set<String> getAllDAGIDs();

    public EventHandler getEventHandler();

    public Clock getClock();

    public ClusterInfo getClusterInfo();

    public AMContainerMap getAllContainers();

    public AMNodeTracker getNodeTracker();

    public TaskSchedulerManager getTaskScheduler();

    public boolean isSession();

    public boolean isLocal();

    public DAGAppMasterState getAMState();

    public HistoryEventHandler getHistoryHandler();

    public Path getCurrentRecoveryDir();

    public boolean isRecoveryEnabled();

    public ACLManager getAMACLManager();

    public String[] getLogDirs();

    public String[] getLocalDirs();

    public String getAMUser();

    public boolean isAMInCompletionState();

    public Credentials getAppCredentials();

    public Integer getTaskCommunicatorIdentifier(String var1);

    public Integer getTaskScheduerIdentifier(String var1);

    public Integer getContainerLauncherIdentifier(String var1);

    public String getTaskCommunicatorName(int var1);

    public String getTaskSchedulerName(int var1);

    public String getContainerLauncherName(int var1);

    public HadoopShim getHadoopShim();

    public RecoveryParser.DAGRecoveryData getDAGRecoveryData();
}

