/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherEventType;

public class ContainerLauncherEvent
extends AbstractEvent<ContainerLauncherEventType> {
    private final ContainerId containerId;
    private final NodeId nodeId;
    private final Token containerToken;
    private final int launcherId;
    private final int schedulerId;
    private final int taskCommId;

    public ContainerLauncherEvent(ContainerId containerId, NodeId nodeId, Token containerToken, ContainerLauncherEventType type, int launcherId, int schedulerId, int taskCommId) {
        super((Enum)type);
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.containerToken = containerToken;
        this.launcherId = launcherId;
        this.schedulerId = schedulerId;
        this.taskCommId = taskCommId;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Token getContainerToken() {
        return this.containerToken;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public int getSchedulerId() {
        return this.schedulerId;
    }

    public int getTaskCommId() {
        return this.taskCommId;
    }

    public String toSrting() {
        return super.toString() + " for container " + this.containerId + ", nodeId: " + this.nodeId + ", launcherId: " + this.launcherId + ", schedulerId=" + this.schedulerId + ", taskCommId=" + this.taskCommId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.containerToken == null ? 0 : this.containerToken.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ContainerLauncherEvent other = (ContainerLauncherEvent)((Object)obj);
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals((Object)other.containerId)) {
            return false;
        }
        if (this.containerToken == null ? other.containerToken != null : !this.containerToken.equals(other.containerToken)) {
            return false;
        }
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals((Object)other.nodeId));
    }
}

