/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class DAGFinishedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private long startTime;
    private long finishTime;
    private DAGState state;
    private String diagnostics;
    private TezCounters tezCounters;
    private String user;
    private String dagName;
    Map<String, Integer> dagTaskStats;
    private DAGProtos.DAGPlan dagPlan;
    private ApplicationAttemptId applicationAttemptId;

    public DAGFinishedEvent() {
    }

    public DAGFinishedEvent(TezDAGID dagId, long startTime, long finishTime, DAGState state, String diagnostics, TezCounters counters, String user, String dagName, Map<String, Integer> dagTaskStats, ApplicationAttemptId applicationAttemptId, DAGProtos.DAGPlan dagPlan) {
        this.dagID = dagId;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.user = user;
        this.dagName = dagName;
        this.dagTaskStats = dagTaskStats;
        this.applicationAttemptId = applicationAttemptId;
        this.dagPlan = dagPlan;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.DAGFinishedProto toProto() {
        RecoveryProtos.DAGFinishedProto.Builder builder = RecoveryProtos.DAGFinishedProto.newBuilder();
        builder.setDagId(this.dagID.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.DAGFinishedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.finishTime = proto.getFinishTime();
        this.state = DAGState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGFinishedProto proto = RecoveryProtos.DAGFinishedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagId=" + this.dagID + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " "));
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.dagID.toString()).setTimestamp(this.finishTime).setEventType(this.getEventType().ordinal()).setEventPayload(ByteString.copyFrom((byte[])Ints.toByteArray((int)this.state.ordinal())));
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.finishTime = proto.getTimestamp();
        this.state = DAGState.values()[Ints.fromByteArray((byte[])proto.getEventPayload().toByteArray())];
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return true;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public DAGState getState() {
        return this.state;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    public String getUser() {
        return this.user;
    }

    public String getDagName() {
        return this.dagName;
    }

    public Map<String, Integer> getDagTaskStats() {
        return this.dagTaskStats;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public DAGProtos.DAGPlan getDAGPlan() {
        return this.dagPlan;
    }
}

