/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.client.MRTezClient;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.MRDAGClient;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.mapreduce.client.ClientCache;
import org.apache.tez.mapreduce.client.DAGJobStatus;
import org.apache.tez.mapreduce.client.ResourceMgrDelegate;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.processor.map.MapProcessor;
import org.apache.tez.mapreduce.processor.reduce.ReduceProcessor;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Mapreduce"})
public class YARNRunner
implements ClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(YARNRunner.class);
    private ResourceMgrDelegate resMgrDelegate;
    private ClientCache clientCache;
    private Configuration conf;
    private final FileContext defaultFileContext;
    public static final FsPermission DAG_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    public static final int UTF8_CHUNK_SIZE = 16384;
    private final TezConfiguration tezConf;
    private MRTezClient tezClient;
    private MRDAGClient dagClient;

    public YARNRunner(Configuration conf) {
        this(conf, new ResourceMgrDelegate(new YarnConfiguration(conf)));
    }

    public YARNRunner(Configuration conf, ResourceMgrDelegate resMgrDelegate) {
        this(conf, resMgrDelegate, new ClientCache(conf, resMgrDelegate));
    }

    public YARNRunner(Configuration conf, ResourceMgrDelegate resMgrDelegate, ClientCache clientCache) {
        this.conf = conf;
        this.tezConf = new TezConfiguration(conf);
        try {
            this.resMgrDelegate = resMgrDelegate;
            this.clientCache = clientCache;
            this.defaultFileContext = FileContext.getFileContext((Configuration)this.conf);
        }
        catch (UnsupportedFileSystemException ufe) {
            throw new RuntimeException("Error in instantiating YarnClient", ufe);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setResourceMgrDelegate(ResourceMgrDelegate resMgrDelegate) {
        this.resMgrDelegate = resMgrDelegate;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> arg0) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use Token.renew instead");
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return this.resMgrDelegate.getActiveTrackers();
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        return this.resMgrDelegate.getAllJobs();
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return this.resMgrDelegate.getBlacklistedTrackers();
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        return this.resMgrDelegate.getClusterMetrics();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return this.resMgrDelegate.getDelegationToken(renewer);
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return this.resMgrDelegate.getFilesystemName();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        return this.resMgrDelegate.getNewJobID();
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        return this.resMgrDelegate.getQueue(queueName);
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        return this.resMgrDelegate.getQueueAclsForCurrentUser();
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        return this.resMgrDelegate.getQueues();
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        return this.resMgrDelegate.getRootQueues();
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        return this.resMgrDelegate.getChildQueues(parent);
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        return this.resMgrDelegate.getStagingAreaDir();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        return this.resMgrDelegate.getSystemDir();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return this.resMgrDelegate.getTaskTrackerExpiryInterval();
    }

    private Map<String, LocalResource> createJobLocalResources(Configuration jobConf, String jobSubmitDir) throws IOException {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        Path jobConfPath = new Path(jobSubmitDir, "job.xml");
        URL yarnUrlForJobSubmitDir = ConverterUtils.getYarnUrlFromPath((Path)this.defaultFileContext.getDefaultFileSystem().resolvePath(this.defaultFileContext.makeQualified(new Path(jobSubmitDir))));
        LOG.debug("Creating setup context, jobSubmitDir url is " + yarnUrlForJobSubmitDir);
        localResources.put("job.xml", this.createApplicationResource(this.defaultFileContext, jobConfPath, LocalResourceType.FILE));
        if (jobConf.get("mapreduce.job.jar") != null) {
            Path jobJarPath = new Path(jobConf.get("mapreduce.job.jar"));
            LocalResource rc = this.createApplicationResource(this.defaultFileContext, jobJarPath, LocalResourceType.FILE);
            localResources.put("job.jar", rc);
        } else {
            LOG.info("Job jar is not present. Not adding any jar to the list of resources.");
        }
        for (String s : new String[]{"job.split", "job.splitmetainfo"}) {
            localResources.put(s, this.createApplicationResource(this.defaultFileContext, new Path(jobSubmitDir, s), LocalResourceType.FILE));
        }
        MRApps.setupDistributedCache((Configuration)jobConf, localResources);
        return localResources;
    }

    private List<TaskLocationHint> getMapLocationHintsFromInputSplits(JobID jobId, FileSystem fs, Configuration conf, String jobSubmitDir) throws IOException {
        JobSplit.TaskSplitMetaInfo[] splitsInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)jobId, (FileSystem)fs, (Configuration)conf, (Path)new Path(jobSubmitDir));
        int splitsCount = splitsInfo.length;
        ArrayList<TaskLocationHint> locationHints = new ArrayList<TaskLocationHint>(splitsCount);
        for (int i = 0; i < splitsCount; ++i) {
            TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(splitsInfo[i].getLocations())), null);
            locationHints.add(locationHint);
        }
        return locationHints;
    }

    private void setupMapReduceEnv(Configuration jobConf, Map<String, String> environment, boolean isMap) throws IOException {
        if (isMap) {
            YARNRunner.warnForJavaLibPath(jobConf.get("mapreduce.map.java.opts", ""), "map", "mapreduce.map.java.opts", "mapreduce.map.env");
            YARNRunner.warnForJavaLibPath(jobConf.get("mapreduce.admin.map.child.java.opts", ""), "map", "mapreduce.admin.map.child.java.opts", "mapreduce.admin.user.env");
        } else {
            YARNRunner.warnForJavaLibPath(jobConf.get("mapreduce.reduce.java.opts", ""), "reduce", "mapreduce.reduce.java.opts", "mapreduce.reduce.env");
            YARNRunner.warnForJavaLibPath(jobConf.get("mapreduce.admin.reduce.child.java.opts", ""), "reduce", "mapreduce.admin.reduce.child.java.opts", "mapreduce.admin.user.env");
        }
        MRHelpers.updateEnvBasedOnMRTaskEnv(jobConf, environment, isMap);
    }

    private Vertex createVertexForStage(Configuration stageConf, Map<String, LocalResource> jobLocalResources, List<TaskLocationHint> locations, int stageNum, int totalStages) throws IOException {
        boolean isMap = false;
        if (stageNum == 0) {
            isMap = true;
        }
        int numTasks = isMap ? stageConf.getInt("mapreduce.job.maps", 0) : stageConf.getInt("mapreduce.job.reduces", 0);
        String processorName = isMap ? MapProcessor.class.getName() : ReduceProcessor.class.getName();
        String vertexName = null;
        vertexName = isMap ? MultiStageMRConfigUtil.getInitialMapVertexName() : (stageNum == totalStages - 1 ? MultiStageMRConfigUtil.getFinalReduceVertexName() : MultiStageMRConfigUtil.getIntermediateStageVertexName(stageNum));
        Resource taskResource = isMap ? MRHelpers.getResourceForMRMapper(stageConf) : MRHelpers.getResourceForMRReducer(stageConf);
        stageConf.set("mapreduce.tez.mroutput.file-name.prefix", "part");
        UserPayload vertexUserPayload = TezUtils.createUserPayloadFromConf((Configuration)stageConf);
        Vertex vertex = Vertex.create((String)vertexName, (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)processorName).setUserPayload(vertexUserPayload)), (int)numTasks, (Resource)taskResource);
        if (stageConf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
            vertex.getProcessorDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)stageConf));
        }
        if (isMap) {
            vertex.addDataSource("MRInput", YARNRunner.configureMRInputWithLegacySplitsGenerated(stageConf, true));
        }
        if (stageNum == totalStages - 1) {
            OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(vertexUserPayload);
            if (stageConf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
                od.setHistoryText(TezUtils.convertToHistoryText((Configuration)stageConf));
            }
            vertex.addDataSink("MROutput", DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), null));
        }
        HashMap<String, String> taskEnv = new HashMap<String, String>();
        this.setupMapReduceEnv(stageConf, taskEnv, isMap);
        TreeMap<String, LocalResource> taskLocalResources = new TreeMap<String, LocalResource>();
        taskLocalResources.putAll(jobLocalResources);
        String taskJavaOpts = isMap ? MRHelpers.getJavaOptsForMRMapper(stageConf) : MRHelpers.getJavaOptsForMRReducer(stageConf);
        vertex.setTaskEnvironment(taskEnv).addTaskLocalFiles(taskLocalResources).setLocationHint(VertexLocationHint.create(locations)).setTaskLaunchCmdOpts(taskJavaOpts);
        if (!isMap) {
            vertex.setVertexManagerPlugin(ShuffleVertexManager.createConfigBuilder((Configuration)stageConf).build());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding vertex to DAG, vertexName=" + vertex.getName() + ", processor=" + vertex.getProcessorDescriptor().getClassName() + ", parallelism=" + vertex.getParallelism() + ", javaOpts=" + vertex.getTaskLaunchCmdOpts() + ", resources=" + vertex.getTaskResource());
        }
        return vertex;
    }

    private DAG createDAG(FileSystem fs, JobID jobId, Configuration[] stageConfs, String jobSubmitDir, Credentials ts, Map<String, LocalResource> jobLocalResources) throws IOException {
        int i;
        String jobName = stageConfs[0].get("mapreduce.job.name", "N/A");
        DAG dag = DAG.create((String)jobName);
        LOG.info("Number of stages: " + stageConfs.length);
        List<TaskLocationHint> mapInputLocations = this.getMapLocationHintsFromInputSplits(jobId, fs, stageConfs[0], jobSubmitDir);
        Object reduceInputLocations = null;
        Vertex[] vertices = new Vertex[stageConfs.length];
        for (i = 0; i < stageConfs.length; ++i) {
            vertices[i] = this.createVertexForStage(stageConfs[i], jobLocalResources, i == 0 ? mapInputLocations : reduceInputLocations, i, stageConfs.length);
        }
        for (i = 0; i < vertices.length; ++i) {
            dag.addVertex(vertices[i]);
            if (i <= 0) continue;
            HashMap partitionerConf = null;
            if (stageConfs[i - 1] != null) {
                partitionerConf = Maps.newHashMap();
                for (Map.Entry entry : stageConfs[i - 1]) {
                    partitionerConf.put(entry.getKey(), entry.getValue());
                }
            }
            OrderedPartitionedKVEdgeConfig edgeConf = ((OrderedPartitionedKVEdgeConfig.Builder)OrderedPartitionedKVEdgeConfig.newBuilder((String)stageConfs[i - 1].get("tez.runtime.key.class"), (String)stageConfs[i - 1].get("tez.runtime.value.class"), (String)MRPartitioner.class.getName(), (Map)partitionerConf).configureInput().useLegacyInput().done()).setFromConfiguration(stageConfs[i - 1]).build();
            Edge edge = Edge.create((Vertex)vertices[i - 1], (Vertex)vertices[i], (EdgeProperty)edgeConf.createDefaultEdgeProperty());
            dag.addEdge(edge);
        }
        return dag;
    }

    private TezConfiguration getDAGAMConfFromMRConf() {
        TezConfiguration finalConf = new TezConfiguration((Configuration)this.tezConf);
        Map<String, String> mrParamToDAGParamMap = DeprecatedKeys.getMRToDAGParamMap();
        for (Map.Entry<String, String> entry : mrParamToDAGParamMap.entrySet()) {
            if (finalConf.get(entry.getKey()) == null) continue;
            finalConf.set(entry.getValue(), finalConf.get(entry.getKey()));
            finalConf.unset(entry.getKey());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("MR->DAG Translating MR key: " + entry.getKey() + " to Tez key: " + entry.getValue() + " with value " + finalConf.get(entry.getValue()));
        }
        return finalConf;
    }

    public JobStatus submitJob(JobID jobId, String jobSubmitDir, Credentials ts) throws IOException, InterruptedException {
        ApplicationId appId = this.resMgrDelegate.getApplicationId();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        JobConf jobConf = new JobConf((Configuration)new TezConfiguration(this.conf));
        Configuration[] stageConfs = MultiStageMRConfToTezTranslator.getStageConfs((Configuration)jobConf);
        for (int i = 0; i < stageConfs.length; ++i) {
            MRHelpers.translateMRConfToTez(stageConfs[i], false);
        }
        Map<String, LocalResource> jobLocalResources = this.createJobLocalResources(stageConfs[0], jobSubmitDir);
        DAG dag = this.createDAG(fs, jobId, stageConfs, jobSubmitDir, ts, jobLocalResources);
        LinkedList<String> vargs = new LinkedList<String>();
        String mrAppMasterAdminOptions = this.conf.get("yarn.app.mapreduce.am.admin-command-opts", "");
        YARNRunner.warnForJavaLibPath(mrAppMasterAdminOptions, "app master", "yarn.app.mapreduce.am.admin-command-opts", "yarn.app.mapreduce.am.admin.user.env");
        vargs.add(mrAppMasterAdminOptions);
        String mrAppMasterUserOptions = this.conf.get("yarn.app.mapreduce.am.command-opts", "-Xmx1024m");
        YARNRunner.warnForJavaLibPath(mrAppMasterUserOptions, "app master", "yarn.app.mapreduce.am.command-opts", "yarn.app.mapreduce.am.env");
        vargs.add(mrAppMasterUserOptions);
        StringBuilder javaOpts = new StringBuilder();
        for (String varg : vargs) {
            javaOpts.append(varg).append(" ");
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        MRHelpers.updateEnvBasedOnMRAMEnv(this.conf, environment);
        StringBuilder envStrBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : environment.entrySet()) {
            if (!first) {
                envStrBuilder.append(",");
            } else {
                first = false;
            }
            envStrBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        String envStr = envStrBuilder.toString();
        TezConfiguration dagAMConf = this.getDAGAMConfFromMRConf();
        dagAMConf.set("tez.am.launch.cmd-opts", javaOpts.toString());
        if (envStr.length() > 0) {
            dagAMConf.set("tez.am.launch.env", envStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting MR AM env to : " + envStr);
            }
        }
        try {
            dagAMConf.set("tez.staging-dir", jobSubmitDir);
            String queueName = jobConf.get("mapreduce.job.queuename", "default");
            dagAMConf.set("tez.queue.name", queueName);
            int amMemMB = jobConf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
            int amCores = jobConf.getInt("yarn.app.mapreduce.am.resource.cpu-vcores", 1);
            dagAMConf.setInt("tez.am.resource.memory.mb", amMemMB);
            dagAMConf.setInt("tez.am.resource.cpu.vcores", amCores);
            dagAMConf.setInt("tez.am.max.app.attempts", jobConf.getInt("mapreduce.am.max-attempts", 2));
            this.tezClient = new MRTezClient("MapReduce", dagAMConf, false, jobLocalResources, ts);
            this.tezClient.start();
            this.tezClient.submitDAGApplication(appId, dag);
            this.tezClient.stop();
        }
        catch (TezException e) {
            throw new IOException(e);
        }
        return this.getJobStatus(jobId);
    }

    private LocalResource createApplicationResource(FileContext fs, Path p, LocalResourceType type) throws IOException {
        LocalResource rsrc = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus rsrcStat = fs.getFileStatus(p);
        rsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)fs.getDefaultFileSystem().resolvePath(rsrcStat.getPath())));
        rsrc.setSize(rsrcStat.getLen());
        rsrc.setTimestamp(rsrcStat.getModificationTime());
        rsrc.setType(type);
        rsrc.setVisibility(LocalResourceVisibility.APPLICATION);
        return rsrc;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
        this.resMgrDelegate.setJobPriority(arg0, arg1);
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return this.resMgrDelegate.getProtocolVersion(arg0, arg1);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> arg0) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use Token.renew instead");
    }

    public Counters getJobCounters(JobID arg0) throws IOException, InterruptedException {
        return this.clientCache.getClient(arg0).getJobCounters(arg0);
    }

    public String getJobHistoryDir() throws IOException, InterruptedException {
        return JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)this.conf);
    }

    public JobStatus getJobStatus(JobID jobID) throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        String jobFile = MRApps.getJobFile((Configuration)this.conf, (String)user, (JobID)jobID);
        try {
            if (this.dagClient == null) {
                this.dagClient = MRTezClient.getDAGClient(TypeConverter.toYarn((JobID)jobID).getAppId(), this.tezConf, null);
            }
            DAGStatus dagStatus = this.dagClient.getDAGStatus(null);
            return new DAGJobStatus(this.dagClient.getApplicationReport(), dagStatus, jobFile);
        }
        catch (TezException e) {
            throw new IOException(e);
        }
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID arg0, int arg1, int arg2) throws IOException, InterruptedException {
        return this.clientCache.getClient(arg0).getTaskCompletionEvents(arg0, arg1, arg2);
    }

    public String[] getTaskDiagnostics(TaskAttemptID arg0) throws IOException, InterruptedException {
        return this.clientCache.getClient(arg0.getJobID()).getTaskDiagnostics(arg0);
    }

    public TaskReport[] getTaskReports(JobID jobID, TaskType taskType) throws IOException, InterruptedException {
        return this.clientCache.getClient(jobID).getTaskReports(jobID, taskType);
    }

    public void killJob(JobID arg0) throws IOException, InterruptedException {
        JobStatus status = this.getJobStatus(arg0);
        if (status.getState() == JobStatus.State.RUNNING || status.getState() == JobStatus.State.PREP) {
            try {
                this.resMgrDelegate.killApplication(TypeConverter.toYarn((JobID)arg0).getAppId());
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
            return;
        }
    }

    public boolean killTask(TaskAttemptID arg0, boolean arg1) throws IOException, InterruptedException {
        return this.clientCache.getClient(arg0.getJobID()).killTask(arg0, arg1);
    }

    public AccessControlList getQueueAdmins(String arg0) throws IOException {
        return new AccessControlList("*");
    }

    public Cluster.JobTrackerStatus getJobTrackerStatus() throws IOException, InterruptedException {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    public LogParams getLogFileParams(JobID jobID, TaskAttemptID taskAttemptID) throws IOException {
        try {
            return this.clientCache.getClient(jobID).getLogFilePath(jobID, taskAttemptID);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    private static void warnForJavaLibPath(String opts, String component, String javaConf, String envConf) {
        if (opts != null && opts.contains("-Djava.library.path")) {
            LOG.warn("Usage of -Djava.library.path in " + javaConf + " can cause " + "programs to no longer function if hadoop native libraries " + "are used. These values should be set as part of the " + "LD_LIBRARY_PATH in the " + component + " JVM env using " + envConf + " config settings.");
        }
    }

    @InterfaceAudience.Private
    private static DataSourceDescriptor configureMRInputWithLegacySplitsGenerated(Configuration conf, boolean useLegacyInput) {
        InputDescriptor inputDescriptor;
        try {
            inputDescriptor = (InputDescriptor)InputDescriptor.create((String)(useLegacyInput ? MRInputLegacy.class.getName() : MRInput.class.getName())).setUserPayload(MRInputHelpersInternal.createMRInputPayload(conf, null));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        DataSourceDescriptor dsd = DataSourceDescriptor.create((InputDescriptor)inputDescriptor, null, null);
        if (conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
            dsd.getInputDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)conf));
        }
        return dsd;
    }

    private static class MRInputHelpersInternal
    extends MRInputHelpers {
        private MRInputHelpersInternal() {
        }

        protected static UserPayload createMRInputPayload(Configuration conf, MRRuntimeProtos.MRSplitsProto mrSplitsProto) throws IOException {
            return MRInputHelpers.createMRInputPayload(conf, mrSplitsProto);
        }
    }
}

