/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.tez.common.TezUtils;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.lib.MRInputUtils;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MRInputSplitDistributor
extends InputInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(MRInputSplitDistributor.class);
    private boolean sendSerializedEvents;
    private MRRuntimeProtos.MRSplitsProto splitsProto;

    public MRInputSplitDistributor(InputInitializerContext initializerContext) {
        super(initializerContext);
    }

    public List<Event> initialize() throws IOException {
        Stopwatch sw = new Stopwatch().start();
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRInputHelpers.parseMRInputPayload(this.getContext().getInputUserPayload());
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Time to parse MRInput payload into prot: " + sw.elapsedMillis());
        }
        Configuration conf = TezUtils.createConfFromByteString((ByteString)userPayloadProto.getConfigurationBytes());
        JobConf jobConf = new JobConf(conf);
        boolean useNewApi = jobConf.getUseNewMapper();
        this.sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        LOG.info("Emitting serialized splits: " + this.sendSerializedEvents);
        this.splitsProto = userPayloadProto.getSplits();
        MRRuntimeProtos.MRInputUserPayloadProto.Builder updatedPayloadBuilder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder(userPayloadProto);
        updatedPayloadBuilder.clearSplits();
        ArrayList events = Lists.newArrayListWithCapacity((int)(this.splitsProto.getSplitsCount() + 1));
        InputUpdatePayloadEvent updatePayloadEvent = InputUpdatePayloadEvent.create((ByteBuffer)updatedPayloadBuilder.build().toByteString().asReadOnlyByteBuffer());
        events.add(updatePayloadEvent);
        int count = 0;
        for (MRRuntimeProtos.MRSplitProto mrSplit : this.splitsProto.getSplitsList()) {
            InputDataInformationEvent diEvent;
            if (this.sendSerializedEvents) {
                diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
            } else if (useNewApi) {
                InputSplit newInputSplit = MRInputUtils.getNewSplitDetailsFromEvent(mrSplit, conf);
                diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)newInputSplit);
            } else {
                org.apache.hadoop.mapred.InputSplit oldInputSplit = MRInputUtils.getOldSplitDetailsFromEvent(mrSplit, conf);
                diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)oldInputSplit);
            }
            events.add(diEvent);
        }
        return events;
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        throw new UnsupportedOperationException("Not expecting to handle any events");
    }
}

