/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.tika.client.TikaClientException;

public class HttpClientUtil {
    public static boolean postJson(HttpClient client, String url, String json) throws IOException, TikaClientException {
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Encoding", "gzip");
        ByteArrayEntity entity = new ByteArrayEntity(json.getBytes(StandardCharsets.UTF_8));
        post.setEntity((HttpEntity)entity);
        post.setHeader("Content-Type", "application/json");
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new TikaClientException("Bad status: " + response.getStatusLine().getStatusCode() + " : " + msg);
        }
        String msg = EntityUtils.toString((HttpEntity)response.getEntity());
        System.out.println("httputil: " + msg);
        return true;
    }

    public static boolean postJson(HttpClient client, String url, byte[] bytes, boolean gzipped) throws IOException, TikaClientException {
        HttpPost post = new HttpPost(url);
        if (gzipped) {
            post.setHeader("Content-Encoding", "gzip");
        }
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        post.setEntity((HttpEntity)entity);
        post.setHeader("Content-Type", "application/json");
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new TikaClientException("Bad status: " + response.getStatusLine().getStatusCode() + " : " + msg);
        }
        String msg = EntityUtils.toString((HttpEntity)response.getEntity());
        System.out.println("httputil: " + msg);
        return true;
    }
}

