/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.crypto;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.crypto.TSDParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class TSDParserTest
extends TikaTest {
    @Test
    public void testTSDFileData() throws Exception {
        try (InputStream inputXml = this.getResourceAsStream("/test-documents/MANIFEST.XML.TSD");
             InputStream inputTxt1 = this.getResourceAsStream("/test-documents/Test1.txt.tsd");
             InputStream inputTxt2 = this.getResourceAsStream("/test-documents/Test2.txt.tsd");
             InputStream inputDocx = this.getResourceAsStream("/test-documents/Test3.docx.tsd");
             InputStream inputPdf = this.getResourceAsStream("/test-documents/Test4.pdf.tsd");
             InputStream inputPng = this.getResourceAsStream("/test-documents/Test5.PNG.tsd");){
            TSDParser tsdParser = new TSDParser();
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            ParseContext parseContext = new ParseContext();
            tsdParser.parse(inputXml, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
            handler = new BodyContentHandler();
            metadata = new Metadata();
            parseContext = new ParseContext();
            tsdParser.parse(inputTxt1, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
            handler = new BodyContentHandler();
            metadata = new Metadata();
            parseContext = new ParseContext();
            tsdParser.parse(inputTxt2, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
            handler = new BodyContentHandler();
            metadata = new Metadata();
            parseContext = new ParseContext();
            tsdParser.parse(inputDocx, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
            handler = new BodyContentHandler();
            metadata = new Metadata();
            parseContext = new ParseContext();
            tsdParser.parse(inputPdf, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
            handler = new BodyContentHandler();
            metadata = new Metadata();
            parseContext = new ParseContext();
            tsdParser.parse(inputPng, (ContentHandler)handler, metadata, parseContext);
            Assertions.assertNotNull((Object)handler);
            Assertions.assertNotNull((Object)metadata);
            TSDParserTest.assertContains((String)"Description=Time Stamped Data Envelope", (String)metadata.toString());
            TSDParserTest.assertContains((String)"Content-Type=application/timestamped-data", (String)metadata.toString());
            TSDParserTest.assertContains((String)"File-Parsed=true", (String)metadata.toString());
        }
    }

    @Test
    public void testTSDFileDataRecursiveMetadataXML() throws Exception {
        List list = this.getRecursiveMetadata("MANIFEST.XML.TSD");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }

    @Test
    public void testTSDFileDataRecursiveMetadataTxt1() throws Exception {
        List list = this.getRecursiveMetadata("Test1.txt.tsd");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }

    @Test
    public void testTSDFileDataRecursiveMetadataTxt2() throws Exception {
        List list = this.getRecursiveMetadata("Test2.txt.tsd");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }

    @Test
    public void testTSDFileDataRecursiveMetadataDocx() throws Exception {
        List list = this.getRecursiveMetadata("Test3.docx.tsd");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }

    @Test
    public void testTSDFileDataRecursiveMetadataPdf() throws Exception {
        List list = this.getRecursiveMetadata("Test4.pdf.tsd");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }

    public void testTSDFileDataRecursiveMetadataPng() throws Exception {
        List list = this.getRecursiveMetadata("Test5.PNG.tsd");
        Assertions.assertEquals((int)2, (int)list.size());
        TSDParserTest.assertContains((Object)TSDParser.class.getName(), Arrays.asList(((Metadata)list.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY)));
    }
}

