/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mbox;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TypeDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mbox.MboxParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class MboxParserTest
extends TikaTest {
    protected ParseContext recursingContext;
    private Parser autoDetectParser;
    private TypeDetector typeDetector;
    private MboxParser mboxParser;

    @BeforeEach
    public void setUp() throws Exception {
        this.typeDetector = new TypeDetector();
        this.autoDetectParser = new AutoDetectParser((Detector)this.typeDetector);
        this.recursingContext = new ParseContext();
        this.recursingContext.set(Parser.class, (Object)this.autoDetectParser);
        this.mboxParser = new MboxParser();
        this.mboxParser.setTracking(true);
    }

    @Test
    public void testSimple() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/simple.mbox");){
            this.mboxParser.parse(stream, (ContentHandler)handler, metadata, this.recursingContext);
        }
        String content = handler.toString();
        MboxParserTest.assertContains((String)"Test content 1", (String)content);
        MboxParserTest.assertContains((String)"Test content 2", (String)content);
        Assertions.assertEquals((Object)"application/mbox", (Object)metadata.get("Content-Type"));
        Map mailsMetadata = this.mboxParser.getTrackingMetadata();
        Assertions.assertEquals((int)2, (int)mailsMetadata.size(), (String)"Nb. Of mails");
        Metadata mail1 = (Metadata)mailsMetadata.get(0);
        Assertions.assertEquals((Object)"message/rfc822", (Object)mail1.get("Content-Type"));
        Assertions.assertEquals((Object)"envelope-sender-mailbox-name Mon Jun 01 10:00:00 2009", (Object)mail1.get("MboxParser-from"));
        Metadata mail2 = (Metadata)mailsMetadata.get(1);
        Assertions.assertEquals((Object)"message/rfc822", (Object)mail2.get("Content-Type"));
        Assertions.assertEquals((Object)"envelope-sender-mailbox-name Mon Jun 01 11:00:00 2010", (Object)mail2.get("MboxParser-from"));
    }

    @Test
    public void testHeaders() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/headers.mbox");){
            this.mboxParser.parse(stream, (ContentHandler)handler, metadata, this.recursingContext);
        }
        MboxParserTest.assertContains((String)"Test content", (String)handler.toString());
        Assertions.assertEquals((int)1, (int)this.mboxParser.getTrackingMetadata().size(), (String)"Nb. Of mails");
        Metadata mailMetadata = (Metadata)this.mboxParser.getTrackingMetadata().get(0);
        Assertions.assertEquals((Object)"2009-06-10T03:58:45Z", (Object)mailMetadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"<author@domain.com>", (Object)mailMetadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"subject", (Object)mailMetadata.get(TikaCoreProperties.SUBJECT));
        Assertions.assertEquals((Object)"message/rfc822", (Object)mailMetadata.get("Content-Type"));
        Assertions.assertEquals((Object)"author@domain.com", (Object)mailMetadata.get("Message-From"));
        Assertions.assertEquals((Object)"<name@domain.com>", (Object)mailMetadata.get("MboxParser-return-path"));
    }

    @Test
    public void testMultilineHeader() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/multiline.mbox");){
            this.mboxParser.parse(stream, (ContentHandler)handler, metadata, this.recursingContext);
        }
        Assertions.assertEquals((int)1, (int)this.mboxParser.getTrackingMetadata().size(), (String)"Nb. Of mails");
        Metadata mailMetadata = (Metadata)this.mboxParser.getTrackingMetadata().get(0);
        Assertions.assertEquals((Object)"from xxx by xxx with xxx; date", (Object)mailMetadata.get("MboxParser-received"));
    }

    @Test
    public void testQuoted() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/quoted.mbox");){
            this.mboxParser.parse(stream, (ContentHandler)handler, metadata, this.recursingContext);
        }
        MboxParserTest.assertContains((String)"Test content", (String)handler.toString());
        MboxParserTest.assertContains((String)"> quoted stuff", (String)handler.toString());
    }

    @Test
    public void testComplex() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/complex.mbox");){
            this.mboxParser.parse(stream, (ContentHandler)handler, metadata, this.recursingContext);
        }
        Assertions.assertEquals((int)3, (int)this.mboxParser.getTrackingMetadata().size(), (String)"Nb. Of mails");
        Metadata firstMail = (Metadata)this.mboxParser.getTrackingMetadata().get(0);
        Assertions.assertEquals((Object)"Re: question about when shuffle/sort start working", (Object)firstMail.get(TikaCoreProperties.SUBJECT));
        Assertions.assertEquals((Object)"Re: question about when shuffle/sort start working", (Object)firstMail.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Jothi Padmanabhan <jothipn@yahoo-inc.com>", (Object)firstMail.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"core-user@hadoop.apache.org", (Object)firstMail.get("Message-Recipient-Address"));
        MboxParserTest.assertContains((String)"When a Mapper completes", (String)handler.toString());
    }

    @Test
    public void testTika2478() throws Exception {
        List metadataList = this.getRecursiveMetadata("testMBOX_complex.mbox");
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Assertions.assertEquals((Object)"application/mbox", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertEquals((Object)"message/rfc822", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        MboxParserTest.assertContains((String)"body 2", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        MboxParserTest.assertNotContained((String)"body 1", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
    }
}

